/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor;

import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.Extractor;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.util.ArrayList;
import java.util.Collection;

public class ChunkedArgumentExtractor
extends Extractor<ChunkedExtraction, ChunkedArgumentExtraction> {
    private Mode mode;

    public ChunkedArgumentExtractor(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    private boolean acceptRange(ChunkedExtraction rel, Range range) {
        if (this.mode == Mode.LEFT) {
            return rel.getStart() > range.getStart();
        }
        if (this.mode == Mode.RIGHT) {
            return rel.getStart() + rel.getLength() <= range.getStart();
        }
        return false;
    }

    private Collection<Range> removeRangeOverlapWithRelation(ChunkedExtraction rel, Iterable<Range> ranges) {
        ArrayList<Range> results = new ArrayList<Range>();
        Range relRange = rel.getRange();
        for (Range range : ranges) {
            Range result = range.removeOverlap(relRange);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    protected Collection<ChunkedArgumentExtraction> extractCandidates(ChunkedExtraction rel) {
        ChunkedSentence sent = rel.getSentence();
        Collection<Range> npChunkRanges = this.removeRangeOverlapWithRelation(rel, (Iterable<Range>)sent.getNpChunkRanges());
        ArrayList<ChunkedArgumentExtraction> args = new ArrayList<ChunkedArgumentExtraction>();
        for (Range npChunkRange : npChunkRanges) {
            if (!this.acceptRange(rel, npChunkRange)) continue;
            ChunkedArgumentExtraction arg = new ChunkedArgumentExtraction(sent, npChunkRange, rel);
            args.add(arg);
        }
        return args;
    }

    public static enum Mode {
        LEFT,
        RIGHT;

    }
}

