/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor;

import edu.washington.cs.knowitall.extractor.ExtractorComposition;
import edu.washington.cs.knowitall.extractor.ExtractorException;
import edu.washington.cs.knowitall.extractor.mapper.Mapper;
import edu.washington.cs.knowitall.extractor.mapper.MapperList;

public abstract class Extractor<S, T> {
    private MapperList<T> mappers = new MapperList();

    public MapperList<T> getMappers() {
        return this.mappers;
    }

    public void addMapper(Mapper<T> mapper) {
        this.mappers.addMapper(mapper);
    }

    protected abstract Iterable<T> extractCandidates(S var1) throws ExtractorException;

    public Iterable<T> extract(S source) throws ExtractorException {
        Iterable<T> candidates = this.extractCandidates(source);
        return this.mappers.map(candidates);
    }

    public static <R, S, T> Extractor<R, T> compose(Extractor<R, S> rsExtractor, Extractor<S, T> stExtractor) {
        return new ExtractorComposition<R, S, T>(rsExtractor, stExtractor);
    }
}

