/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor;

import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.Extractor;
import edu.washington.cs.knowitall.extractor.ExtractorException;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.sequence.LayeredTokenMatcher;
import edu.washington.cs.knowitall.sequence.LayeredTokenPattern;
import edu.washington.cs.knowitall.sequence.SequenceException;
import java.util.ArrayList;
import java.util.Collection;

public class RegexExtractor
extends Extractor<ChunkedSentence, ChunkedExtraction> {
    private String patternString;
    private LayeredTokenPattern pattern;

    public RegexExtractor(String patternString) throws SequenceException {
        this.patternString = patternString;
        this.pattern = new LayeredTokenPattern(patternString);
    }

    public String getPatternString() {
        return this.patternString;
    }

    public LayeredTokenPattern getPattern() {
        return this.pattern;
    }

    @Override
    public Collection<ChunkedExtraction> extractCandidates(ChunkedSentence sentence) throws ExtractorException {
        try {
            LayeredTokenMatcher m = this.pattern.matcher(sentence);
            ArrayList<ChunkedExtraction> results = new ArrayList<ChunkedExtraction>();
            while (m.find()) {
                int start = m.start();
                int length = m.end() - start;
                Range r = new Range(start, length);
                ChunkedExtraction extr = new ChunkedExtraction(sentence, r);
                results.add(extr);
            }
            return results;
        }
        catch (SequenceException e) {
            String msg = String.format("Couldn't extract from sentence '%s'", sentence);
            throw new ExtractorException(msg, e);
        }
    }
}

