/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf;

import com.google.common.collect.AbstractIterator;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.extractor.conf.LabeledBinaryExtraction;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.sequence.SequenceException;
import edu.washington.cs.knowitall.util.IterableAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class LabeledBinaryExtractionReader {
    private InputStream in;

    public LabeledBinaryExtractionReader(InputStream in) throws IOException {
        this.in = in;
    }

    public Iterable<LabeledBinaryExtraction> readExtractions() throws IOException {
        LBEIterator iter = new LBEIterator(this.in);
        return new IterableAdapter<LabeledBinaryExtraction>((Iterator<LabeledBinaryExtraction>)((Object)iter));
    }

    private class LBEIterator
    extends AbstractIterator<LabeledBinaryExtraction> {
        private BufferedReader reader;

        public LBEIterator(InputStream in) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(in));
        }

        private Range readRange(String line) throws IOException {
            String[] startLen = line.split(" ");
            int start = Integer.parseInt(startLen[0]);
            int length = Integer.parseInt(startLen[1]);
            return new Range(start, length);
        }

        private String[] readNextLines() throws IOException {
            String[] lines = new String[10];
            for (int i = 0; i < 10; ++i) {
                String line = this.reader.readLine();
                if (line == null) {
                    throw new IOException("Bad file format");
                }
                lines[i] = line;
            }
            return lines;
        }

        protected LabeledBinaryExtraction computeNext() {
            try {
                String[] lines = this.readNextLines();
                String[] tokens = lines[0].split(" ");
                String[] posTags = lines[1].split(" ");
                String[] npChunkTags = lines[2].split(" ");
                ChunkedSentence sent = new ChunkedSentence(tokens, posTags, npChunkTags);
                Range arg1Range = this.readRange(lines[4]);
                Range relRange = this.readRange(lines[6]);
                Range arg2Range = this.readRange(lines[8]);
                int label = Integer.parseInt(lines[9]);
                ChunkedExtraction rel = new ChunkedExtraction(sent, relRange);
                ChunkedArgumentExtraction arg1 = new ChunkedArgumentExtraction(sent, arg1Range, rel);
                ChunkedArgumentExtraction arg2 = new ChunkedArgumentExtraction(sent, arg2Range, rel);
                LabeledBinaryExtraction extr = new LabeledBinaryExtraction(rel, arg1, arg2, label);
                return extr;
            }
            catch (IOException e) {
                return (LabeledBinaryExtraction)this.endOfData();
            }
            catch (SequenceException e) {
                return (LabeledBinaryExtraction)this.endOfData();
            }
        }
    }
}

