/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.featureset;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import edu.washington.cs.knowitall.extractor.conf.featureset.FeatureSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DoubleFeatureSet<T>
extends FeatureSet<T> {
    private ImmutableList<Function<T, Double>> features;

    public DoubleFeatureSet(Map<String, Function<T, Double>> givenFeatures) {
        super((List<String>)ImmutableList.copyOf(givenFeatures.keySet()));
        TreeMap<String, Function<T, Double>> sortedFeatures = new TreeMap<String, Function<T, Double>>(givenFeatures);
        this.features = ImmutableList.copyOf(sortedFeatures.values());
    }

    public SortedMap<String, Double> featurize(T object) {
        TreeMap<String, Double> values = new TreeMap<String, Double>();
        for (int i = 0; i < this.getNumFeatures(); ++i) {
            String featureName = (String)this.featureNames.get(i);
            double featureValue = (Double)((Function)this.features.get(i)).apply(object);
            values.put(featureName, featureValue);
        }
        return values;
    }

    @Override
    public double[] featurizeToDouble(T object) {
        double[] values = new double[this.features.size()];
        for (int i = 0; i < this.features.size(); ++i) {
            values[i] = (Double)((Function)this.features.get(i)).apply(object);
        }
        return values;
    }

    public List<Function<T, Double>> getFeatures() {
        return this.features;
    }

    @Override
    public double featurize(String featureName, T object) {
        return (Double)((Function)this.features.get(this.featureNames.indexOf((Object)featureName))).apply(object);
    }
}

