/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.featureset;

import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.commonlib.Range;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedBinaryExtraction;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.normalization.BasicFieldNormalizer;

public abstract class ExtractionFeature
implements Predicate<ChunkedBinaryExtraction> {
    protected BasicFieldNormalizer stemmer = new BasicFieldNormalizer();

    protected ExtractionFeature() {
    }

    protected abstract Range rangeToExamine(ChunkedBinaryExtraction var1);

    public boolean apply(ChunkedBinaryExtraction cbe) {
        ChunkedSentence sentence = cbe.getSentence();
        for (Integer index : this.rangeToExamine(cbe)) {
            if (index < 0 || index > sentence.getLength() || !this.testAtIndex(index, sentence)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean testAtIndex(Integer var1, ChunkedSentence var2);

    public static Integer indexOfHeadVerb(ChunkedExtraction relation, boolean exception) {
        for (int i = relation.getLength() - 1; i >= 0; --i) {
            if (!relation.getPosTag(i).startsWith("V") && !relation.getPosTag(i).equals("MD")) continue;
            return i + relation.getStart();
        }
        if (exception) {
            throw new IllegalArgumentException(relation.toOpenNlpFormat());
        }
        return null;
    }
}

