/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.featureset;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.TreeSet;

public abstract class FeatureSet<T> {
    protected final ImmutableList<String> featureNames;

    public FeatureSet(List<String> featureNames) {
        this.featureNames = ImmutableList.copyOf(new TreeSet<String>(featureNames));
    }

    public abstract double featurize(String var1, T var2);

    public double[] featurizeToDouble(T object) {
        double[] values = new double[this.featureNames.size()];
        int i = 0;
        for (String name : this.featureNames) {
            values[i] = this.featurize(name, object);
            ++i;
        }
        return values;
    }

    public int getNumFeatures() {
        return this.featureNames.size();
    }

    public List<String> getFeatureNames() {
        return this.featureNames;
    }
}

