/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.conf.opennlp;

import com.google.common.collect.ImmutableMap;
import edu.washington.cs.knowitall.extractor.conf.featureset.BooleanFeatureSet;
import java.util.HashMap;

public class OpenNlpAlphabet<T> {
    public final ImmutableMap<Key, String> lookup;

    public OpenNlpAlphabet(BooleanFeatureSet<T> features) {
        HashMap<Key, String> lookup = new HashMap<Key, String>();
        for (String featureName : features.getFeatureNames()) {
            lookup.put(new Key(featureName, true), featureName + "=true");
            lookup.put(new Key(featureName, false), featureName + "=false");
        }
        this.lookup = ImmutableMap.copyOf(lookup);
    }

    public static class Key {
        public final String featureName;
        public final boolean value;

        public Key(String featureName, boolean value) {
            this.featureName = featureName;
            this.value = value;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            Key that = (Key)other;
            return that.featureName == this.featureName && that.value == this.value;
        }

        public int hashCode() {
            return this.featureName.hashCode() + (this.value ? 1 : 0);
        }
    }
}

