/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.IndependentMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class BracketsRemover
extends IndependentMapper<String> {
    private final String[] startBrackets;
    private final String[] endBrackets;
    private ArrayList<Pattern> patterns;

    public BracketsRemover(String[] startBrackets, String[] endBrackets) {
        this.startBrackets = startBrackets;
        this.endBrackets = endBrackets;
        this.initializePatterns();
    }

    public BracketsRemover() {
        this(new String[]{"(", "[", "{", "<"}, new String[]{")", "]", "}", ">"});
    }

    private void initializePatterns() {
        int numBrackets = this.startBrackets.length;
        this.patterns = new ArrayList();
        for (int i = 0; i < numBrackets; ++i) {
            String start = Pattern.quote(this.startBrackets[i]);
            String end = Pattern.quote(this.endBrackets[i]);
            String pattern = start + ".*" + end + "\\s*";
            this.patterns.add(Pattern.compile(pattern));
        }
    }

    @Override
    public String doMap(String sent) {
        for (Pattern p : this.patterns) {
            sent = p.matcher(sent).replaceAll("");
        }
        return sent;
    }

    public static void main(String[] args) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        BracketsRemover remover = new BracketsRemover();
        String line = reader.readLine();
        while (line != null) {
            System.out.println(remover.doMap(line));
            line = reader.readLine();
        }
    }
}

