/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.IndependentMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class JunkRemover
extends IndependentMapper<String> {
    private final String junk;
    private ArrayList<Pattern> patterns;

    public JunkRemover(String junk) {
        this.junk = junk;
        this.initializePatterns();
    }

    public JunkRemover() {
        this("()[]{}<>|\\\"");
    }

    private void initializePatterns() {
        this.patterns = new ArrayList(4);
        this.patterns.add(Pattern.compile("[" + Pattern.quote(this.junk) + "]+"));
        this.patterns.add(Pattern.compile("\\p{InCombiningDiacriticalMarks}+"));
        this.patterns.add(Pattern.compile("[^\\p{ASCII}]+"));
        this.patterns.add(Pattern.compile("\\p{Cntrl}"));
    }

    @Override
    public String doMap(String sent) {
        sent = Normalizer.normalize(sent, Normalizer.Form.NFD);
        for (Pattern p : this.patterns) {
            sent = p.matcher(sent).replaceAll("");
        }
        return sent;
    }

    public static void main(String[] args) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        JunkRemover remover = new JunkRemover();
        String line = reader.readLine();
        while (line != null) {
            System.out.println(remover.doMap(line));
            line = reader.readLine();
        }
    }
}

