/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.ClosestArgumentMapper;
import edu.washington.cs.knowitall.extractor.mapper.ConjunctionCommaArgumentFilter;
import edu.washington.cs.knowitall.extractor.mapper.FilterMapper;
import edu.washington.cs.knowitall.extractor.mapper.MapperList;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedArgumentExtraction;

public class ReVerbArgument1Mappers
extends MapperList<ChunkedArgumentExtraction> {
    public ReVerbArgument1Mappers() {
        this.init();
    }

    private void init() {
        this.addFirstPosTagNotEqualsFilter("EX");
        this.addFirstPosTagNotEqualsFilter("WDT");
        this.addFirstPosTagNotEqualsFilter("WP$");
        this.addFirstPosTagNotEqualsFilter("WRB");
        this.addFirstPosTagNotEqualsFilter("WP");
        this.addFirstPosTagNotEqualsFilter("IN");
        this.addFirstTokenNotEqualsFilter("that");
        this.addFirstTokenNotEqualsFilter("which");
        this.addFirstTokenNotEqualsFilter("myself");
        this.addFirstTokenNotEqualsFilter("yourself");
        this.addFirstTokenNotEqualsFilter("himself");
        this.addFirstTokenNotEqualsFilter("herself");
        this.addFirstTokenNotEqualsFilter("itself");
        this.addFirstTokenNotEqualsFilter("oneself");
        this.addFirstTokenNotEqualsFilter("ourselves");
        this.addFirstTokenNotEqualsFilter("ourself");
        this.addFirstTokenNotEqualsFilter("yourselves");
        this.addFirstTokenNotEqualsFilter("themselves");
        this.addMapper(new ConjunctionCommaArgumentFilter());
        this.addMapper(new ClosestArgumentMapper());
    }

    private void addFirstPosTagNotEqualsFilter(String posTag) {
        final String posTagCopy = posTag;
        this.addMapper(new FilterMapper<ChunkedArgumentExtraction>(){

            @Override
            public boolean doFilter(ChunkedArgumentExtraction extr) {
                return !((String)extr.getPosTags().get(0)).equals(posTagCopy);
            }
        });
    }

    private void addFirstTokenNotEqualsFilter(String token) {
        final String tokenCopy = token;
        this.addMapper(new FilterMapper<ChunkedArgumentExtraction>(){

            @Override
            public boolean doFilter(ChunkedArgumentExtraction extr) {
                return !((String)extr.getTokens().get(0)).equals(tokenCopy);
            }
        });
    }
}

