/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.extractor.mapper;

import edu.washington.cs.knowitall.extractor.mapper.FilterMapper;
import edu.washington.cs.knowitall.extractor.mapper.MapperList;
import edu.washington.cs.knowitall.extractor.mapper.MergeOverlappingMapper;
import edu.washington.cs.knowitall.extractor.mapper.ReVerbRelationDictionaryFilter;
import edu.washington.cs.knowitall.extractor.mapper.StopListFilter;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import java.io.IOException;

public class ReVerbRelationMappers
extends MapperList<ChunkedExtraction> {
    public ReVerbRelationMappers() throws IOException {
        this.init();
    }

    public ReVerbRelationMappers(int minFreq) throws IOException {
        this.init(minFreq);
    }

    public ReVerbRelationMappers(int minFreq, boolean useLexSynConstraints, boolean mergeOverlapRels) throws IOException {
        this.init(minFreq, useLexSynConstraints, mergeOverlapRels);
    }

    private void init() throws IOException {
        this.addLexicalAndSyntacticConstraints();
        this.addMapper(new ReVerbRelationDictionaryFilter());
        this.addMapper(new MergeOverlappingMapper());
    }

    private void init(int minFreq) throws IOException {
        this.addLexicalAndSyntacticConstraints();
        this.addMapper(new ReVerbRelationDictionaryFilter(minFreq));
        this.addMapper(new MergeOverlappingMapper());
    }

    private void init(int minFreq, boolean useLexSynConstraints, boolean mergeOverlapRels) throws IOException {
        if (useLexSynConstraints) {
            this.addLexicalAndSyntacticConstraints();
        }
        if (minFreq > 0) {
            this.addMapper(new ReVerbRelationDictionaryFilter(minFreq));
        }
        if (mergeOverlapRels) {
            this.addMapper(new MergeOverlappingMapper());
        }
    }

    private void addLexicalAndSyntacticConstraints() {
        this.addMapper(new FilterMapper<ChunkedExtraction>(){

            @Override
            public boolean doFilter(ChunkedExtraction rel) {
                if (rel.getLength() == 1) {
                    return rel.getToken(0).length() > 1;
                }
                return true;
            }
        });
        StopListFilter relStopList = new StopListFilter();
        relStopList.addStopPosTag("CC");
        relStopList.addStopPosTag(",");
        relStopList.addStopPosTag("PRP");
        relStopList.addStopToken("that");
        relStopList.addStopToken("if");
        relStopList.addStopToken("because");
        this.addMapper(relStopList);
        this.addMapper(new FilterMapper<ChunkedExtraction>(){

            @Override
            public boolean doFilter(ChunkedExtraction rel) {
                ChunkedSentence sent = rel.getSentence();
                int start = rel.getStart();
                int length = rel.getLength();
                for (int i = start; i < start + length; ++i) {
                    String posTag = (String)sent.getPosTags().get(i);
                    if (!posTag.startsWith("VB")) continue;
                    return !posTag.equals("VBG") && !posTag.equals("VBN");
                }
                return true;
            }
        });
        this.addMapper(new FilterMapper<ChunkedExtraction>(){

            @Override
            public boolean doFilter(ChunkedExtraction rel) {
                int s = rel.getStart();
                if (s == 0) {
                    return true;
                }
                String posTag = rel.getSentence().getPosTag(s - 1);
                return !posTag.equals("EX") && !posTag.equals("TO");
            }
        });
    }
}

