/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.io;

import com.google.common.collect.AbstractIterator;
import edu.washington.cs.knowitall.io.BufferedReaderIterator;
import java.io.BufferedReader;
import java.util.Iterator;
import java.util.regex.Pattern;

public class SmartTextBlockIterator
extends AbstractIterator<String> {
    private Iterator<String> lineIter;
    private String blockBreak = "";
    Pattern convertToSpace = Pattern.compile("\\xa0");

    public SmartTextBlockIterator(BufferedReader reader, String blockBreak) {
        this.init((Iterator<String>)((Object)new BufferedReaderIterator(reader)), blockBreak);
    }

    public SmartTextBlockIterator(BufferedReader reader) {
        this.init((Iterator<String>)((Object)new BufferedReaderIterator(reader)), "");
    }

    public SmartTextBlockIterator(Iterator<String> lineIter, String blockBreak) {
        this.init(lineIter, blockBreak);
    }

    public SmartTextBlockIterator(Iterator<String> lineIter) {
        this.init(lineIter, "");
    }

    public SmartTextBlockIterator(Iterable<String> iter, String blockBreak) {
        this.init(iter.iterator(), blockBreak);
    }

    public SmartTextBlockIterator(Iterable<String> iter) {
        this.init(iter.iterator(), "");
    }

    private void init(Iterator<String> lineIter, String blockBreak) {
        this.lineIter = lineIter;
        this.blockBreak = blockBreak;
    }

    private String cleanupLine(String line) {
        return this.convertToSpace.matcher(line).replaceAll(" ").trim();
    }

    protected String computeNext() {
        while (this.lineIter.hasNext()) {
            String line = this.cleanupLine(this.lineIter.next());
            StringBuffer buf = new StringBuffer(line).append(" ");
            while (this.lineIter.hasNext() && !line.equals(this.blockBreak)) {
                line = this.cleanupLine(this.lineIter.next());
                buf.append(line).append(" ");
            }
            String result = buf.toString();
            if (result.equals("")) continue;
            return result.trim();
        }
        return (String)this.endOfData();
    }
}

