/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.ChunkerException;
import edu.washington.cs.knowitall.nlp.SentenceChunker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ChunkedSentenceIterator
extends AbstractIterator<ChunkedSentence> {
    private SentenceChunker chunker;
    private Iterator<String> sentIter;
    private List<Predicate<ChunkedSentence>> filters;
    private long lastComputeTime = 0L;

    public ChunkedSentenceIterator(Iterator<String> sentIter, SentenceChunker chunker) {
        this.sentIter = sentIter;
        this.chunker = chunker;
        this.filters = new ArrayList<Predicate<ChunkedSentence>>();
    }

    public long getLastComputeTime() {
        return this.lastComputeTime;
    }

    public void addFilter(Predicate<ChunkedSentence> filter) {
        this.filters.add(filter);
    }

    protected ChunkedSentence computeNext() {
        while (this.sentIter.hasNext()) {
            try {
                long start = System.nanoTime();
                ChunkedSentence chunkedSentence = this.chunker.chunkSentence(this.sentIter.next());
                for (Predicate<ChunkedSentence> filter : this.filters) {
                    if (!filter.apply((Object)chunkedSentence)) continue;
                }
                this.lastComputeTime = System.nanoTime() - start;
                return chunkedSentence;
            }
            catch (ChunkerException e) {
            }
        }
        this.lastComputeTime = 0L;
        return (ChunkedSentence)this.endOfData();
    }
}

