/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp;

import edu.washington.cs.knowitall.nlp.ChunkedSentence;
import edu.washington.cs.knowitall.nlp.OpenNlpUtils;
import edu.washington.cs.knowitall.sequence.SequenceException;
import java.text.ParseException;
import java.util.ArrayList;

public class OpenNlpChunkedSentenceParser {
    private boolean attachOfs = true;
    private boolean attachPossessives = true;

    public boolean attachOfs() {
        return this.attachOfs;
    }

    public boolean attachPossessives() {
        return this.attachPossessives;
    }

    public void attachOfs(boolean attachOfs) {
        this.attachOfs = attachOfs;
    }

    public void attachPossessives(boolean attachPossessives) {
        this.attachPossessives = attachPossessives;
    }

    public ChunkedSentence parseSentence(String sent) throws ParseException {
        sent = sent.replace(" ]", "]");
        ArrayList<String> tokensList = new ArrayList<String>();
        ArrayList<String> posTagsList = new ArrayList<String>();
        ArrayList<String> npChunkTagsList = new ArrayList<String>();
        String[] parts = sent.trim().split(" ");
        String currentChunk = null;
        boolean atChunkStart = false;
        for (String part : parts) {
            if (this.isChunk(part)) {
                currentChunk = this.getChunkType(part);
                atChunkStart = true;
                continue;
            }
            String[] tokTag = this.getTokenTag(part);
            String token = tokTag[0];
            String posTag = tokTag[1];
            tokensList.add(token);
            posTagsList.add(posTag);
            if (currentChunk == null) {
                npChunkTagsList.add("O");
            } else if (atChunkStart) {
                npChunkTagsList.add("B-" + currentChunk);
                atChunkStart = false;
            } else {
                npChunkTagsList.add("I-" + currentChunk);
            }
            if (!this.isEndChunk(part)) continue;
            currentChunk = null;
        }
        String[] tokens = tokensList.toArray(new String[0]);
        String[] posTags = posTagsList.toArray(new String[0]);
        String[] npChunkTags = npChunkTagsList.toArray(new String[0]);
        if (this.attachOfs) {
            OpenNlpUtils.attachOfs(tokens, npChunkTags);
        } else {
            OpenNlpUtils.detatchOfs(tokens, npChunkTags);
        }
        if (this.attachPossessives) {
            OpenNlpUtils.attachPossessives(posTags, npChunkTags);
        } else {
            OpenNlpUtils.detatchPossessives(posTags, npChunkTags);
        }
        try {
            return new ChunkedSentence(tokens, posTags, npChunkTags);
        }
        catch (SequenceException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private boolean isChunk(String part) {
        return part.startsWith("[");
    }

    private String getChunkType(String part) throws ParseException {
        if (part.length() >= 2) {
            return part.subSequence(1, part.length()).toString();
        }
        throw new ParseException("Couldn't parse part: " + part, 0);
    }

    private boolean isEndChunk(String part) {
        return part.endsWith("]");
    }

    private String[] getTokenTag(String piece) throws ParseException {
        int i;
        if (piece.endsWith("]")) {
            piece = piece.substring(0, piece.length() - 1);
        }
        if ((i = piece.lastIndexOf("/")) > 0) {
            String token = piece.substring(0, i);
            String posTag = piece.substring(i + 1);
            return new String[]{token, posTag};
        }
        throw new ParseException("Couldn't get token/tag: " + piece, 0);
    }
}

