/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.nlp;

import edu.washington.cs.knowitall.commonlib.Range;
import java.util.ArrayList;
import java.util.List;

public class OpenNlpUtils {
    public static final String START_CHUNK = "B-";
    public static final String IN_CHUNK = "I-";
    public static final String START_NP = "B-NP";
    public static final String IN_NP = "I-NP";
    public static final String POS = "POS";
    public static final String OUT = "O";

    public static boolean isChunkBeginTag(String tag, String chunk) {
        return tag.equals(START_CHUNK + chunk);
    }

    public static boolean isChunkInTag(String tag, String chunk) {
        return tag.equals(IN_CHUNK + chunk);
    }

    public static boolean isNpBeginTag(String s) {
        return s.equals(START_NP);
    }

    public static boolean isNpInTag(String s) {
        return s.equals(IN_NP);
    }

    public static boolean isPossessive(String s) {
        return s.equals(POS);
    }

    public static boolean isInNpChunk(String s) {
        return s.equals(START_NP) || s.equals(IN_NP);
    }

    public static List<Range> computeChunkRanges(String[] tags, String name) {
        int start = 0;
        int chunkLength = 0;
        boolean inChunk = false;
        ArrayList<Range> chunkRanges = new ArrayList<Range>();
        int length = tags.length;
        for (int i = 0; i < length; ++i) {
            if (inChunk) {
                if (OpenNlpUtils.isChunkInTag(tags[i], name)) {
                    ++chunkLength;
                } else {
                    Range r = new Range(start, chunkLength);
                    chunkRanges.add(r);
                    inChunk = false;
                    chunkLength = 0;
                }
            }
            if (!OpenNlpUtils.isChunkBeginTag(tags[i], name)) continue;
            inChunk = true;
            start = i;
            chunkLength = 1;
        }
        if (inChunk) {
            Range r = new Range(start, chunkLength);
            chunkRanges.add(r);
        }
        return chunkRanges;
    }

    public static List<Range> computeNpChunkRanges(String[] npChunkTags) {
        return OpenNlpUtils.computeChunkRanges(npChunkTags, "NP");
    }

    public static List<Range> computeNpChunkRanges(List<String> npChunkTags) {
        return OpenNlpUtils.computeNpChunkRanges(npChunkTags.toArray(new String[0]));
    }

    public static void attachOfs(String[] tokens, String[] npChunkTags) {
        for (int i = 1; i < npChunkTags.length - 1; ++i) {
            if (!tokens[i].equals("of") || !OpenNlpUtils.isInNpChunk(npChunkTags[i - 1]) || !OpenNlpUtils.isInNpChunk(npChunkTags[i + 1])) continue;
            npChunkTags[i] = IN_NP;
            npChunkTags[i + 1] = IN_NP;
        }
    }

    public static void detatchOfs(String[] tokens, String[] npChunkTags) {
        for (int i = 1; i < npChunkTags.length - 1; ++i) {
            if (!tokens[i].equals("of") || !OpenNlpUtils.isInNpChunk(npChunkTags[i + 1])) continue;
            npChunkTags[i] = OUT;
            npChunkTags[i + 1] = START_NP;
        }
    }

    public static void attachPossessives(String[] posTags, String[] npChunkTags) {
        for (int i = 1; i < npChunkTags.length - 1; ++i) {
            if (!OpenNlpUtils.isPossessive(posTags[i]) || !OpenNlpUtils.isInNpChunk(npChunkTags[i - 1])) continue;
            npChunkTags[i] = IN_NP;
            if (!OpenNlpUtils.isInNpChunk(npChunkTags[i + 1])) continue;
            npChunkTags[i + 1] = IN_NP;
        }
    }

    public static void detatchPossessives(String[] posTags, String[] npChunkTags) {
        for (int i = 1; i < npChunkTags.length - 1; ++i) {
            if (!OpenNlpUtils.isPossessive(posTags[i]) || !OpenNlpUtils.isInNpChunk(npChunkTags[i + 1])) continue;
            npChunkTags[i] = OUT;
            if (!OpenNlpUtils.isInNpChunk(npChunkTags[i + 1])) continue;
            npChunkTags[i + 1] = START_NP;
        }
    }
}

