/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.normalization;

import com.google.common.base.Joiner;
import edu.washington.cs.knowitall.nlp.extraction.ChunkedExtraction;
import edu.washington.cs.knowitall.sequence.SequenceException;
import edu.washington.cs.knowitall.sequence.SimpleLayeredSequence;
import java.util.List;

public class NormalizedField
extends SimpleLayeredSequence {
    public static final String TOKEN_LAYER = "tok";
    public static final String POS_LAYER = "pos";
    private ChunkedExtraction original;

    public NormalizedField(ChunkedExtraction original, String[] tokens, String[] posTags) throws SequenceException {
        super(tokens.length);
        this.addLayer(TOKEN_LAYER, tokens);
        this.addLayer(POS_LAYER, posTags);
        this.original = original;
    }

    public NormalizedField(ChunkedExtraction original, List<String> tokens, List<String> posTags) throws SequenceException {
        super(tokens.size());
        this.addLayer(TOKEN_LAYER, tokens);
        this.addLayer(POS_LAYER, posTags);
        this.original = original;
    }

    public ChunkedExtraction getOriginalField() {
        return this.original;
    }

    public List<String> getTokens() {
        return this.getLayer(TOKEN_LAYER);
    }

    public List<String> getPosTags() {
        return this.getLayer(POS_LAYER);
    }

    public String getTokensAsString() {
        return Joiner.on((String)" ").join(this.getTokens());
    }

    public String getPosTagsAsString() {
        return Joiner.on((String)" ").join(this.getPosTags());
    }

    public String toString() {
        return this.getTokensAsString();
    }
}

