/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.elasticsearch;

import edu.wgu.osmt.api.GeneralApiException;
import edu.wgu.osmt.api.model.ApiJobCode;
import edu.wgu.osmt.api.model.ApiNamedReference;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.api.model.ApiSimilaritySearch;
import edu.wgu.osmt.api.model.ApiSkillSummary;
import edu.wgu.osmt.api.model.CollectionSortEnum;
import edu.wgu.osmt.api.model.SkillSortEnum;
import edu.wgu.osmt.api.model.SortOrderCompanion;
import edu.wgu.osmt.collection.CollectionDoc;
import edu.wgu.osmt.collection.CollectionEsRepo;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.elasticsearch.OffsetPageable;
import edu.wgu.osmt.elasticsearch.PaginatedLinks;
import edu.wgu.osmt.jobcode.JobCode;
import edu.wgu.osmt.jobcode.JobCodeEsRepo;
import edu.wgu.osmt.keyword.Keyword;
import edu.wgu.osmt.keyword.KeywordEsRepo;
import edu.wgu.osmt.keyword.KeywordTypeEnum;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Controller
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJq\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u001e2\u000e\b\u0001\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\"2\b\b\u0001\u0010$\u001a\u00020\"2\b\b\u0001\u0010%\u001a\u00020&2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010(H\u0017\u00a2\u0006\u0002\u0010)Jg\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u001e2\u000e\b\u0001\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\"2\b\b\u0001\u0010%\u001a\u00020&2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010(H\u0017\u00a2\u0006\u0002\u0010,J&\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010/\u001a\u00020\"H\u0017J0\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010/\u001a\u00020\"2\b\b\u0001\u00102\u001a\u00020\"H\u0017J\u001e\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\u00190\u00182\b\b\u0001\u00105\u001a\u000206H\u0017Js\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u001e2\u000e\b\u0001\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\"2\n\b\u0001\u00108\u001a\u0004\u0018\u00010\"2\b\b\u0001\u0010%\u001a\u00020&2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010(H\u0017\u00a2\u0006\u0002\u0010)J)\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\u00190\u00182\u000e\b\u0001\u0010;\u001a\b\u0012\u0004\u0012\u0002060!H\u0017\u00a2\u0006\u0002\u0010<R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006="}, d2={"Ledu/wgu/osmt/elasticsearch/SearchController;", "", "keywordEsRepo", "Ledu/wgu/osmt/keyword/KeywordEsRepo;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "collectionEsRepo", "Ledu/wgu/osmt/collection/CollectionEsRepo;", "jobCodeEsRepo", "Ledu/wgu/osmt/jobcode/JobCodeEsRepo;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/keyword/KeywordEsRepo;Ledu/wgu/osmt/richskill/RichSkillEsRepo;Ledu/wgu/osmt/collection/CollectionEsRepo;Ledu/wgu/osmt/jobcode/JobCodeEsRepo;Ledu/wgu/osmt/config/AppConfig;)V", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getCollectionEsRepo", "()Ledu/wgu/osmt/collection/CollectionEsRepo;", "getJobCodeEsRepo", "()Ledu/wgu/osmt/jobcode/JobCodeEsRepo;", "getKeywordEsRepo", "()Ledu/wgu/osmt/keyword/KeywordEsRepo;", "getRichSkillEsRepo", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "collectionSkills", "Lorg/springframework/http/HttpEntity;", "", "Ledu/wgu/osmt/richskill/RichSkillDoc;", "uriComponentsBuilder", "Lorg/springframework/web/util/UriComponentsBuilder;", "size", "", "from", "status", "", "", "sort", "uuid", "apiSearch", "Ledu/wgu/osmt/api/model/ApiSearch;", "user", "Lorg/springframework/security/oauth2/jwt/Jwt;", "(Lorg/springframework/web/util/UriComponentsBuilder;II[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ledu/wgu/osmt/api/model/ApiSearch;Lorg/springframework/security/oauth2/jwt/Jwt;)Lorg/springframework/http/HttpEntity;", "searchCollections", "Ledu/wgu/osmt/collection/CollectionDoc;", "(Lorg/springframework/web/util/UriComponentsBuilder;II[Ljava/lang/String;Ljava/lang/String;Ledu/wgu/osmt/api/model/ApiSearch;Lorg/springframework/security/oauth2/jwt/Jwt;)Lorg/springframework/http/HttpEntity;", "searchJobCodes", "Ledu/wgu/osmt/api/model/ApiJobCode;", "query", "searchKeywords", "Ledu/wgu/osmt/api/model/ApiNamedReference;", "type", "searchSimilarSkills", "Ledu/wgu/osmt/api/model/ApiSkillSummary;", "apiSimilaritySearch", "Ledu/wgu/osmt/api/model/ApiSimilaritySearch;", "searchSkills", "collectionId", "similarSkillWarnings", "", "similarities", "([Ledu/wgu/osmt/api/model/ApiSimilaritySearch;)Lorg/springframework/http/HttpEntity;", "osmt-api"})
public class SearchController {
    @NotNull
    private final KeywordEsRepo keywordEsRepo;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final CollectionEsRepo collectionEsRepo;
    @NotNull
    private final JobCodeEsRepo jobCodeEsRepo;
    @NotNull
    private final AppConfig appConfig;

    @Autowired
    public SearchController(@NotNull KeywordEsRepo keywordEsRepo, @NotNull RichSkillEsRepo richSkillEsRepo, @NotNull CollectionEsRepo collectionEsRepo, @NotNull JobCodeEsRepo jobCodeEsRepo, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)keywordEsRepo, (String)"keywordEsRepo");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        Intrinsics.checkNotNullParameter((Object)collectionEsRepo, (String)"collectionEsRepo");
        Intrinsics.checkNotNullParameter((Object)jobCodeEsRepo, (String)"jobCodeEsRepo");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.keywordEsRepo = keywordEsRepo;
        this.richSkillEsRepo = richSkillEsRepo;
        this.collectionEsRepo = collectionEsRepo;
        this.jobCodeEsRepo = jobCodeEsRepo;
        this.appConfig = appConfig;
    }

    @NotNull
    public KeywordEsRepo getKeywordEsRepo() {
        return this.keywordEsRepo;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public CollectionEsRepo getCollectionEsRepo() {
        return this.collectionEsRepo;
    }

    @NotNull
    public JobCodeEsRepo getJobCodeEsRepo() {
        return this.jobCodeEsRepo;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/api/search/collections"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<CollectionDoc>> searchCollections(@NotNull UriComponentsBuilder uriComponentsBuilder, @RequestParam(required=false, defaultValue="50") int size, @RequestParam(required=false, defaultValue="0") int from, @RequestParam(required=false, defaultValue="draft,published") @NotNull String[] status, @RequestParam(required=false) @Nullable String sort, @RequestBody @NotNull ApiSearch apiSearch, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        String[] $this$mapNotNull$iv = status;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var16_17 = $this$forEach$iv$iv$iv;
        int n = ((void)var16_17).length;
        for (int i = 0; i < n; ++i) {
            PublishStatus publishStatus;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var16_17[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            PublishStatus status2 = PublishStatus.Companion.forApiValue((String)it);
            if ((user == null && (status2 == PublishStatus.Deleted || status2 == PublishStatus.Draft) ? null : status2) == null) continue;
            publishStatus = publishStatus;
            boolean bl3 = false;
            boolean bl4 = false;
            PublishStatus it$iv$iv = publishStatus;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set publishStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        CollectionSortEnum sortEnum = (CollectionSortEnum)SortOrderCompanion.DefaultImpls.forValueOrDefault$default(CollectionSortEnum.Companion, sort, null, 2, null);
        OffsetPageable pageable = new OffsetPageable(from, size, sortEnum.getSort());
        SearchHits searchHits = this.getCollectionEsRepo().byApiSearch(apiSearch, publishStatuses, pageable);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("X-Total-Count", String.valueOf(searchHits.getTotalHits()));
        Object[] objectArray = new Object[]{from};
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder.path("/api/search/collections").queryParam("from", objectArray);
        objectArray = new Object[]{size};
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2.queryParam("size", objectArray);
        objectArray = new Object[1];
        Object object = ArraysKt.joinToString$default((Object[])status, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        Intrinsics.checkNotNullExpressionValue((Object)object.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
        uriComponentsBuilder3.queryParam("status", objectArray);
        objectArray = sort;
        if (objectArray != null) {
            object = objectArray;
            bl = false;
            boolean bl6 = false;
            Object it = object;
            boolean bl7 = false;
            Object[] objectArray2 = new Object[]{it};
            uriComponentsBuilder.queryParam("sort", objectArray2);
        }
        new PaginatedLinks(pageable, (int)searchHits.getTotalHits(), uriComponentsBuilder).addToHeaders(responseHeaders);
        objectArray = ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)200).headers(responseHeaders)).body((Object)searchHits.map(SearchController::searchCollections$lambda-2).toList());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"status(200).headers(responseHeaders).body(searchHits.map { it.content }.toList())");
        return (HttpEntity)objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/api/search/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<RichSkillDoc>> searchSkills(@NotNull UriComponentsBuilder uriComponentsBuilder, @RequestParam(required=false, defaultValue="50") int size, @RequestParam(required=false, defaultValue="0") int from, @RequestParam(required=false, defaultValue="draft,published") @NotNull String[] status, @RequestParam(required=false) @Nullable String sort, @RequestParam(required=false) @Nullable String collectionId, @RequestBody @NotNull ApiSearch apiSearch, @AuthenticationPrincipal @Nullable Jwt user) {
        Object it;
        boolean bl;
        SkillSortEnum skillSortEnum;
        String $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        String[] $this$mapNotNull$iv = status;
        boolean $i$f$mapNotNull22 = false;
        String[] stringArray = $this$mapNotNull$iv;
        Object destination$iv$iv2 = (Object[])new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var17_20 = $this$forEach$iv$iv$iv;
        int n = ((void)var17_20).length;
        for (int i = 0; i < n; ++i) {
            PublishStatus publishStatus;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var17_20[i];
            boolean bl2 = false;
            void it2 = element$iv$iv;
            boolean bl3 = false;
            PublishStatus status2 = PublishStatus.Companion.forApiValue((String)it2);
            if ((user == null && (status2 == PublishStatus.Deleted || status2 == PublishStatus.Draft) ? null : status2) == null) continue;
            publishStatus = publishStatus;
            boolean bl4 = false;
            boolean bl5 = false;
            PublishStatus it$iv$iv = publishStatus;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set publishStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        String $i$f$mapNotNull22 = sort;
        if ($i$f$mapNotNull22 == null) {
            skillSortEnum = null;
        } else {
            $this$mapNotNullTo$iv$iv = $i$f$mapNotNull22;
            boolean destination$iv$iv2 = false;
            boolean bl7 = false;
            String it3 = $this$mapNotNullTo$iv$iv;
            boolean bl8 = false;
            skillSortEnum = SkillSortEnum.Companion.forApiValue(it3);
        }
        SkillSortEnum sortEnum = skillSortEnum;
        $this$mapNotNullTo$iv$iv = sortEnum;
        OffsetPageable pageable = new OffsetPageable(from, size, $this$mapNotNullTo$iv$iv == null ? null : $this$mapNotNullTo$iv$iv.getSort());
        SearchHits searchHits = this.getRichSkillEsRepo().byApiSearch(apiSearch, publishStatuses, pageable, collectionId);
        destination$iv$iv2 = new Object[]{from};
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder.path("/api/search/skills").queryParam("from", destination$iv$iv2);
        destination$iv$iv2 = new Object[]{size};
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2.queryParam("size", destination$iv$iv2);
        destination$iv$iv2 = new Object[1];
        ResponseEntity responseEntity = ArraysKt.joinToString$default((Object[])status, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        boolean bl9 = false;
        if (responseEntity == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
        uriComponentsBuilder3.queryParam("status", destination$iv$iv2);
        destination$iv$iv2 = sort;
        if (destination$iv$iv2 != null) {
            responseEntity = destination$iv$iv2;
            bl9 = false;
            bl = false;
            it = responseEntity;
            boolean bl10 = false;
            Object[] objectArray = new Object[]{it};
            uriComponentsBuilder.queryParam("sort", objectArray);
        }
        destination$iv$iv2 = collectionId;
        if (destination$iv$iv2 != null) {
            responseEntity = destination$iv$iv2;
            bl9 = false;
            bl = false;
            it = responseEntity;
            boolean bl11 = false;
            Object[] objectArray = new Object[]{it};
            uriComponentsBuilder.queryParam("collectionId", objectArray);
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("X-Total-Count", String.valueOf(searchHits.getTotalHits()));
        new PaginatedLinks(pageable, (int)searchHits.getTotalHits(), uriComponentsBuilder).addToHeaders(responseHeaders);
        responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)200).headers(responseHeaders)).body((Object)searchHits.map(SearchController::searchSkills$lambda-7).toList());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).headers(responseHeaders)\n            .body(searchHits.map { it.content }.toList())");
        return (HttpEntity)responseEntity;
    }

    @PostMapping(value={"/api/collections/{uuid}/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<RichSkillDoc>> collectionSkills(@NotNull UriComponentsBuilder uriComponentsBuilder, @RequestParam(required=false, defaultValue="50") int size, @RequestParam(required=false, defaultValue="0") int from, @RequestParam(required=false, defaultValue="draft,published") @NotNull String[] status, @RequestParam(required=false) @Nullable String sort, @PathVariable @NotNull String uuid, @RequestBody @NotNull ApiSearch apiSearch, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        return this.searchSkills(uriComponentsBuilder, size, from, status, sort, uuid, apiSearch, user);
    }

    @GetMapping(value={"/api/search/jobcodes"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<ApiJobCode>> searchJobCodes(@NotNull UriComponentsBuilder uriComponentsBuilder, @RequestParam(required=true) @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        SearchHits searchResults = this.getJobCodeEsRepo().typeAheadSearch(query);
        ResponseEntity responseEntity = ResponseEntity.status((int)200).body((Object)searchResults.map(SearchController::searchJobCodes$lambda-8).toList());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).body(searchResults.map { ApiJobCode.fromJobCode(it.content) }.toList())");
        return (HttpEntity)responseEntity;
    }

    @GetMapping(value={"/api/search/keywords"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<ApiNamedReference>> searchKeywords(@NotNull UriComponentsBuilder uriComponentsBuilder, @RequestParam(required=true) @NotNull String query, @RequestParam(required=true) @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KeywordTypeEnum keywordTypeEnum = KeywordTypeEnum.Companion.forApiValue(type);
        if (keywordTypeEnum == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
        }
        KeywordTypeEnum keywordType = keywordTypeEnum;
        SearchHits searchResults = this.getKeywordEsRepo().typeAheadSearch(query, keywordType);
        ResponseEntity responseEntity = ResponseEntity.status((int)200).body((Object)searchResults.map(SearchController::searchKeywords$lambda-9).toList());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).body(searchResults.map { ApiNamedReference.fromKeyword(it.content) }.toList())");
        return (HttpEntity)responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/api/search/skills/similarity"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<ApiSkillSummary>> searchSimilarSkills(@RequestBody(required=true) @NotNull ApiSimilaritySearch apiSimilaritySearch) {
        Collection<ApiSkillSummary> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)apiSimilaritySearch, (String)"apiSimilaritySearch");
        List list = this.getRichSkillEsRepo().findSimilar(apiSimilaritySearch).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"richSkillEsRepo.findSimilar(apiSimilaritySearch).toList()");
        List hits = list;
        Iterable iterable = hits;
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((int)200);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SearchHit searchHit = (SearchHit)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.content");
            ApiSkillSummary apiSkillSummary = ApiSkillSummary.Companion.fromDoc((RichSkillDoc)object);
            collection.add(apiSkillSummary);
        }
        collection = (List)destination$iv$iv;
        list = bodyBuilder.body((Object)collection);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"status(200).body(hits.map{ApiSkillSummary.fromDoc(it.content)})");
        return (HttpEntity)list;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/api/search/skills/similarities"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<Boolean>> similarSkillWarnings(@RequestBody(required=true) @NotNull ApiSimilaritySearch[] similarities) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)similarities, (String)"similarities");
        int arrayLimit = 100;
        ApiSimilaritySearch[] apiSimilaritySearchArray = similarities;
        boolean bl = false;
        if (apiSimilaritySearchArray.length > arrayLimit) {
            throw new GeneralApiException("Request contained more than " + arrayLimit + " objects", HttpStatus.BAD_REQUEST);
        }
        ApiSimilaritySearch[] $this$map$iv = similarities;
        boolean $i$f$map = false;
        ApiSimilaritySearch[] apiSimilaritySearchArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var9_10 = $this$mapTo$iv$iv;
        int n = ((void)var9_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_14 = item$iv$iv = var9_10[i];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Boolean bl3 = CollectionsKt.count((Iterable)((Iterable)this.getRichSkillEsRepo().findSimilar((ApiSimilaritySearch)it))) > 0;
            collection.add(bl3);
        }
        List hits = (List)destination$iv$iv;
        ResponseEntity responseEntity = ResponseEntity.status((int)200).body((Object)hits);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).body(hits)");
        return (HttpEntity)responseEntity;
    }

    private static final CollectionDoc searchCollections$lambda-2(SearchHit it) {
        return (CollectionDoc)it.getContent();
    }

    private static final RichSkillDoc searchSkills$lambda-7(SearchHit it) {
        return (RichSkillDoc)it.getContent();
    }

    private static final ApiJobCode searchJobCodes$lambda-8(SearchHit it) {
        Object object = it.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.content");
        return ApiJobCode.factory.fromJobCode$default(ApiJobCode.factory, (JobCode)object, null, null, 6, null);
    }

    private static final ApiNamedReference searchKeywords$lambda-9(SearchHit it) {
        Object object = it.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.content");
        return ApiNamedReference.factory.fromKeyword((Keyword)object);
    }
}

