/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.elasticsearch;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ#\u0010\r\u001a\u00020\f2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u000f\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ledu/wgu/osmt/elasticsearch/ProcessLogger;", "", "name", "", "logger", "Lorg/slf4j/Logger;", "(Ljava/lang/String;Lorg/slf4j/Logger;)V", "count", "", "start", "totalCount", "finish", "", "increment", "args", "", "([Ljava/lang/String;)V", "offset", "limit", "", "osmt-api"})
public final class ProcessLogger {
    @NotNull
    private final String name;
    @NotNull
    private final Logger logger;
    private final long start;
    private long totalCount;
    private long count;

    public ProcessLogger(@NotNull String name, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.name = name;
        this.logger = logger;
        this.start = System.currentTimeMillis();
    }

    public final void increment(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ProcessLogger processLogger = this;
        long l = processLogger.count;
        processLogger.count = l + 1L;
        if (this.logger.isTraceEnabled()) {
            String string;
            processLogger = StringCompanionObject.INSTANCE;
            String string2 = "Re-indexing %s (%.1f%%): %s";
            Object[] objectArray = new Object[3];
            objectArray[0] = this.name;
            objectArray[1] = Float.valueOf((float)((double)this.count * 100.0 / (double)this.totalCount));
            if (args.length > 1 && args[1] != null) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string3 = "%s (\"%s\")";
                Object[] objectArray2 = new Object[]{args[0], args[1]};
                boolean bl = false;
                String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            } else {
                string = args[0];
            }
            objectArray[2] = string;
            boolean bl = false;
            String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
            this.logger.trace(string5);
        }
    }

    public final long offset() {
        return this.count;
    }

    public final void start(long totalCount, long count, int limit) {
        this.totalCount = totalCount;
        this.count = count;
        if (this.logger.isDebugEnabled()) {
            Object[] objectArray = new Object[]{totalCount, count + 1L, Long.min(totalCount, count + (long)limit), this.name};
            this.logger.debug("Re-indexing {} records ({}-{}) for {}", objectArray);
        } else if (this.count == 0L) {
            this.logger.info("Re-indexing {} records for {}", (Object)totalCount, (Object)this.name);
        }
    }

    public final void finish() {
        long totalTime = System.currentTimeMillis() - this.start;
        Object[] objectArray = new Object[]{this.count, this.name, totalTime / (long)1000, totalTime % (long)1000};
        this.logger.info("Re-indexed {} {} ({}.{}s)", objectArray);
    }
}

