/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.richskill;

import com.github.sonus21.rqueue.annotation.RqueueListener;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.task.CreateSkillsTask;
import edu.wgu.osmt.task.TaskMessageService;
import edu.wgu.osmt.task.TaskStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"apiserver"})
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Ledu/wgu/osmt/richskill/CreateSkillsTaskProcessor;", "", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "setRichSkillRepository", "(Ledu/wgu/osmt/richskill/RichSkillRepository;)V", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "setTaskMessageService", "(Ledu/wgu/osmt/task/TaskMessageService;)V", "process", "", "task", "Ledu/wgu/osmt/task/CreateSkillsTask;", "osmt-api"})
public class CreateSkillsTaskProcessor {
    @NotNull
    private final Logger logger;
    @Autowired
    public TaskMessageService taskMessageService;
    @Autowired
    public RichSkillRepository richSkillRepository;
    @Autowired
    private AppConfig appConfig;

    public CreateSkillsTaskProcessor() {
        Logger logger = LoggerFactory.getLogger(CreateSkillsTaskProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CreateSkillsTaskProcessor::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        TaskMessageService taskMessageService = this.taskMessageService;
        if (taskMessageService != null) {
            return taskMessageService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"taskMessageService");
        throw null;
    }

    public void setTaskMessageService(@NotNull TaskMessageService taskMessageService) {
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"<set-?>");
        this.taskMessageService = taskMessageService;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        RichSkillRepository richSkillRepository = this.richSkillRepository;
        if (richSkillRepository != null) {
            return richSkillRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"richSkillRepository");
        throw null;
    }

    public void setRichSkillRepository(@NotNull RichSkillRepository richSkillRepository) {
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"<set-?>");
        this.richSkillRepository = richSkillRepository;
    }

    /*
     * WARNING - void declaration
     */
    @RqueueListener(value={"create-skills"}, deadLetterQueue="dead-letters", deadLetterQueueListenerEnabled="true", concurrency="1")
    public void process(@NotNull CreateSkillsTask task) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getLogger().info(Intrinsics.stringPlus((String)"Started processing createSkillsTask uuid: ", (Object)task.getUuid()));
        Iterable $this$map$iv = this.getRichSkillRepository().createFromApi(task.getApiSkillUpdates(), task.getUserString());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getUuid();
            collection.add(string);
        }
        List results = (List)destination$iv$iv;
        this.getTaskMessageService().publishResult(CreateSkillsTask.copy$default(task, null, null, null, null, results, TaskStatus.Ready, 15, null));
        this.getLogger().info("Task " + task.getUuid() + " completed");
    }
}

