/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.richskill;

import edu.wgu.osmt.api.FormValidationException;
import edu.wgu.osmt.api.model.ApiAlignment;
import edu.wgu.osmt.api.model.ApiAlignmentListUpdate;
import edu.wgu.osmt.api.model.ApiBatchResult;
import edu.wgu.osmt.api.model.ApiFieldError;
import edu.wgu.osmt.api.model.ApiNamedReference;
import edu.wgu.osmt.api.model.ApiReferenceListUpdate;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.api.model.ApiSkillUpdate;
import edu.wgu.osmt.api.model.ApiStringListUpdate;
import edu.wgu.osmt.auditlog.AuditLog;
import edu.wgu.osmt.auditlog.AuditLogRepository;
import edu.wgu.osmt.auditlog.AuditOperationType;
import edu.wgu.osmt.auditlog.Change;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.collection.CollectionDoc;
import edu.wgu.osmt.collection.CollectionEsRepo;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.ListFieldUpdate;
import edu.wgu.osmt.db.NullableFieldUpdate;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.jobcode.JobCodeRepository;
import edu.wgu.osmt.jobcode.JobCodeTable;
import edu.wgu.osmt.keyword.KeywordDao;
import edu.wgu.osmt.keyword.KeywordRepository;
import edu.wgu.osmt.keyword.KeywordTypeEnum;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillDescriptorKt;
import edu.wgu.osmt.richskill.RichSkillDescriptorTable;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import edu.wgu.osmt.richskill.RichSkillJobCodes;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.richskill.RsdUpdateObject;
import edu.wgu.osmt.task.PublishTask;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.LongEntity;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.util.Streamable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H\u0016J\u001a\u00104\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000203H\u0016J$\u00108\u001a\b\u0012\u0004\u0012\u000201092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;092\u0006\u00107\u001a\u000203H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0012\u0010=\u001a\u0004\u0018\u0001012\u0006\u0010>\u001a\u00020?H\u0016J\u0012\u0010@\u001a\u0004\u0018\u0001012\u0006\u0010A\u001a\u000203H\u0016J\u001e\u0010B\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001092\f\u0010C\u001a\b\u0012\u0004\u0012\u00020309H\u0016J\u0018\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020;2\u0006\u00107\u001a\u000203H\u0016J\u001a\u0010F\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000203H\u0016J\"\u0010G\u001a\u0004\u0018\u0001012\u0006\u0010H\u001a\u00020?2\u0006\u0010E\u001a\u00020;2\u0006\u00107\u001a\u000203H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u001a8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020 8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006I"}, d2={"Ledu/wgu/osmt/richskill/RichSkillRepositoryImpl;", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "auditLogRepository", "Ledu/wgu/osmt/auditlog/AuditLogRepository;", "collectionRepository", "Ledu/wgu/osmt/collection/CollectionRepository;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "collectionEsRepo", "Ledu/wgu/osmt/collection/CollectionEsRepo;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/auditlog/AuditLogRepository;Ledu/wgu/osmt/collection/CollectionRepository;Ledu/wgu/osmt/richskill/RichSkillEsRepo;Ledu/wgu/osmt/collection/CollectionEsRepo;Ledu/wgu/osmt/config/AppConfig;)V", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getAuditLogRepository", "()Ledu/wgu/osmt/auditlog/AuditLogRepository;", "getCollectionEsRepo", "()Ledu/wgu/osmt/collection/CollectionEsRepo;", "getCollectionRepository", "()Ledu/wgu/osmt/collection/CollectionRepository;", "dao", "Ledu/wgu/osmt/richskill/RichSkillDescriptorDao$Companion;", "getDao", "()Ledu/wgu/osmt/richskill/RichSkillDescriptorDao$Companion;", "jobCodeRepository", "Ledu/wgu/osmt/jobcode/JobCodeRepository;", "getJobCodeRepository", "()Ledu/wgu/osmt/jobcode/JobCodeRepository;", "setJobCodeRepository", "(Ledu/wgu/osmt/jobcode/JobCodeRepository;)V", "keywordRepository", "Ledu/wgu/osmt/keyword/KeywordRepository;", "getKeywordRepository", "()Ledu/wgu/osmt/keyword/KeywordRepository;", "setKeywordRepository", "(Ledu/wgu/osmt/keyword/KeywordRepository;)V", "getRichSkillEsRepo", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "table", "Ledu/wgu/osmt/richskill/RichSkillDescriptorTable;", "getTable", "()Ledu/wgu/osmt/richskill/RichSkillDescriptorTable;", "changeStatusesForTask", "Ledu/wgu/osmt/api/model/ApiBatchResult;", "publishTask", "Ledu/wgu/osmt/task/PublishTask;", "containingJobCode", "Lorg/jetbrains/exposed/sql/SizedIterable;", "Ledu/wgu/osmt/richskill/RichSkillDescriptorDao;", "jobCode", "", "create", "updateObject", "Ledu/wgu/osmt/richskill/RsdUpdateObject;", "user", "createFromApi", "", "skillUpdates", "Ledu/wgu/osmt/api/model/ApiSkillUpdate;", "findAll", "findById", "id", "", "findByUUID", "uuid", "findManyByUUIDs", "uuids", "rsdUpdateFromApi", "skillUpdate", "update", "updateFromApi", "existingSkillId", "osmt-api"})
public class RichSkillRepositoryImpl
implements RichSkillRepository {
    @NotNull
    private final AuditLogRepository auditLogRepository;
    @NotNull
    private final CollectionRepository collectionRepository;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final CollectionEsRepo collectionEsRepo;
    @NotNull
    private final AppConfig appConfig;
    @Autowired
    @Lazy
    public JobCodeRepository jobCodeRepository;
    @Autowired
    @Lazy
    public KeywordRepository keywordRepository;
    @NotNull
    private final RichSkillDescriptorDao.Companion dao;
    @NotNull
    private final RichSkillDescriptorTable table;

    @Autowired
    public RichSkillRepositoryImpl(@NotNull AuditLogRepository auditLogRepository, @NotNull CollectionRepository collectionRepository, @NotNull RichSkillEsRepo richSkillEsRepo, @NotNull CollectionEsRepo collectionEsRepo, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)auditLogRepository, (String)"auditLogRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        Intrinsics.checkNotNullParameter((Object)collectionEsRepo, (String)"collectionEsRepo");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.auditLogRepository = auditLogRepository;
        this.collectionRepository = collectionRepository;
        this.richSkillEsRepo = richSkillEsRepo;
        this.collectionEsRepo = collectionEsRepo;
        this.appConfig = appConfig;
        this.dao = RichSkillDescriptorDao.Companion;
        this.table = RichSkillDescriptorTable.INSTANCE;
    }

    @NotNull
    public AuditLogRepository getAuditLogRepository() {
        return this.auditLogRepository;
    }

    @NotNull
    public CollectionRepository getCollectionRepository() {
        return this.collectionRepository;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public CollectionEsRepo getCollectionEsRepo() {
        return this.collectionEsRepo;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public JobCodeRepository getJobCodeRepository() {
        JobCodeRepository jobCodeRepository = this.jobCodeRepository;
        if (jobCodeRepository != null) {
            return jobCodeRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jobCodeRepository");
        throw null;
    }

    public void setJobCodeRepository(@NotNull JobCodeRepository jobCodeRepository) {
        Intrinsics.checkNotNullParameter((Object)jobCodeRepository, (String)"<set-?>");
        this.jobCodeRepository = jobCodeRepository;
    }

    @NotNull
    public KeywordRepository getKeywordRepository() {
        KeywordRepository keywordRepository = this.keywordRepository;
        if (keywordRepository != null) {
            return keywordRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keywordRepository");
        throw null;
    }

    public void setKeywordRepository(@NotNull KeywordRepository keywordRepository) {
        Intrinsics.checkNotNullParameter((Object)keywordRepository, (String)"<set-?>");
        this.keywordRepository = keywordRepository;
    }

    @Override
    @NotNull
    public RichSkillDescriptorDao.Companion getDao() {
        return this.dao;
    }

    @Override
    @NotNull
    public RichSkillDescriptorTable getTable() {
        return this.table;
    }

    @Override
    @NotNull
    public SizedIterable<RichSkillDescriptorDao> findAll() {
        return this.getDao().all();
    }

    @Override
    @Nullable
    public RichSkillDescriptorDao findById(long id) {
        return (RichSkillDescriptorDao)this.getDao().findById(Long.valueOf(id));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao update(@NotNull RsdUpdateObject updateObject, @NotNull String user) {
        List<Change> it;
        boolean bl;
        List<Change> list;
        Object element$iv2;
        Pair pair;
        RichSkillDescriptor richSkillDescriptor;
        Object it2;
        RichSkillDescriptorDao richSkillDescriptorDao;
        RichSkillDescriptorDao daoObject;
        Intrinsics.checkNotNullParameter((Object)updateObject, (String)"updateObject");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        RichSkillDescriptorDao.Companion companion = this.getDao();
        Long l = updateObject.getId();
        Intrinsics.checkNotNull((Object)l);
        RichSkillDescriptorDao richSkillDescriptorDao2 = daoObject = (RichSkillDescriptorDao)companion.findById(l);
        RichSkillDescriptor old = richSkillDescriptorDao2 == null ? null : richSkillDescriptorDao2.toModel();
        richSkillDescriptorDao2 = daoObject;
        if (richSkillDescriptorDao2 != null) {
            richSkillDescriptorDao = richSkillDescriptorDao2;
            boolean bl2 = false;
            boolean bl3 = false;
            it2 = richSkillDescriptorDao;
            boolean bl4 = false;
            updateObject.applyToDao((RichSkillDescriptorDao)it2);
        }
        List<Change> list2 = daoObject;
        RichSkillDescriptor richSkillDescriptor2 = richSkillDescriptor = list2 == null ? null : ((RichSkillDescriptorDao)((Object)list2)).toModel();
        if (richSkillDescriptor == null) {
            pair = null;
        } else {
            list2 = RichSkillDescriptorKt.diff(richSkillDescriptor, old);
            if (list2 == null) {
                pair = null;
            } else {
                void $this$partition$iv;
                it2 = list2;
                boolean $i$f$partition = false;
                ArrayList<Object> first$iv = new ArrayList<Object>();
                ArrayList<Object> second$iv = new ArrayList<Object>();
                for (Object element$iv2 : $this$partition$iv) {
                    Change it3 = (Change)element$iv2;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual((Object)it3.getFieldName(), (Object)"publishStatus")) {
                        first$iv.add(element$iv2);
                        continue;
                    }
                    second$iv.add(element$iv2);
                }
                pair = new Pair(first$iv, second$iv);
            }
        }
        richSkillDescriptorDao = pair;
        richSkillDescriptorDao2 = richSkillDescriptorDao == null ? TuplesKt.to(null, null) : richSkillDescriptorDao;
        List publishStatusChanges = (List)richSkillDescriptorDao2.component1();
        List otherChanges = (List)richSkillDescriptorDao2.component2();
        list2 = otherChanges;
        if (list2 != null) {
            list = list2;
            bl = false;
            boolean bl6 = false;
            it = list;
            boolean bl7 = false;
            element$iv2 = it;
            boolean bl8 = false;
            if (!element$iv2.isEmpty()) {
                this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), (long)updateObject.getId(), it, user, AuditOperationType.Update));
            }
        }
        list2 = publishStatusChanges;
        if (list2 != null) {
            list = list2;
            bl = false;
            boolean bl9 = false;
            it = list;
            boolean bl10 = false;
            element$iv2 = it;
            boolean bl11 = false;
            if (!element$iv2.isEmpty()) {
                this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), (long)updateObject.getId(), it, user, AuditOperationType.PublishStatusChange));
            }
        }
        list2 = daoObject;
        if (list2 != null) {
            Collection<CollectionDoc> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            list = list2;
            bl = false;
            boolean bl12 = false;
            it = list;
            boolean bl13 = false;
            element$iv2 = (Iterable)((RichSkillDescriptorDao)((Object)it)).getCollections();
            CollectionEsRepo collectionEsRepo = this.getCollectionEsRepo();
            boolean $i$f$map = false;
            void var17_28 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                CollectionDao collectionDao = (CollectionDao)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl14 = false;
                CollectionDoc collectionDoc = CollectionDao.toDoc$default((CollectionDao)it4, false, 1, null);
                collection.add(collectionDoc);
            }
            collection = (List)destination$iv$iv;
            collectionEsRepo.saveAll(collection);
            RichSkillDoc cfr_ignored_0 = (RichSkillDoc)this.getRichSkillEsRepo().save(RichSkillDoc.Companion.fromDao((RichSkillDescriptorDao)((Object)it), this.getAppConfig()));
        }
        return daoObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao findByUUID(@NotNull String uuid) {
        RichSkillDescriptorDao richSkillDescriptorDao;
        ResultRow query;
        void $this$findByUUID_u24lambda_u2d6;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        Op op = $this$findByUUID_u24lambda_u2d6.eq((ExpressionWithColumnType)this.getTable().getUuid(), (Object)uuid);
        ResultRow resultRow = query = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.select((FieldSet)fieldSet, (Op)op)));
        if (resultRow == null) {
            richSkillDescriptorDao = null;
        } else {
            ResultRow resultRow2 = resultRow;
            boolean bl2 = false;
            boolean bl3 = false;
            ResultRow it = resultRow2;
            boolean bl4 = false;
            richSkillDescriptorDao = (RichSkillDescriptorDao)this.getDao().wrapRow(it);
        }
        return richSkillDescriptorDao;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<RichSkillDescriptorDao> findManyByUUIDs(@NotNull List<String> uuids) {
        void $this$mapTo$iv$iv;
        Iterable $this$findManyByUUIDs_u24lambda_u2d8;
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        Object object = $this$select$iv;
        boolean bl = false;
        Object object2 = (Op)$this$findManyByUUIDs_u24lambda_u2d8.inList((ExpressionWithColumnType)this.getTable().getUuid(), uuids);
        Query query = QueriesKt.select((FieldSet)object, (Op)object2);
        Iterable $this$map$iv = (Iterable)query;
        boolean $i$f$map = false;
        $this$findManyByUUIDs_u24lambda_u2d8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultRow resultRow = (ResultRow)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object2 = (RichSkillDescriptorDao)this.getDao().wrapRow((ResultRow)it);
            object.add(object2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao create(@NotNull RsdUpdateObject updateObject, @NotNull String user) {
        Collection<CollectionDoc> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)updateObject, (String)"updateObject");
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                CharSequence charSequence = updateObject.getName();
                boolean bl2 = false;
                bl = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block3;
                charSequence = updateObject.getStatement();
                bl2 = false;
                bl = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block4;
            }
            return null;
        }
        RichSkillDescriptorDao newRsd2 = (RichSkillDescriptorDao)this.getDao().new((Function1)new Function1<RichSkillDescriptorDao, Unit>(updateObject){
            final /* synthetic */ RsdUpdateObject $updateObject;
            {
                this.$updateObject = $updateObject;
                super(1);
            }

            public final void invoke(@NotNull RichSkillDescriptorDao $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setName(this.$updateObject.getName());
                $this$new.setStatement(this.$updateObject.getStatement());
                NullableFieldUpdate<KeywordDao> nullableFieldUpdate = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)nullableFieldUpdate, (String)"now(ZoneOffset.UTC)");
                $this$new.setUpdateDate((LocalDateTime)((Object)nullableFieldUpdate));
                nullableFieldUpdate = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)nullableFieldUpdate, (String)"now(ZoneOffset.UTC)");
                $this$new.setCreationDate((LocalDateTime)((Object)nullableFieldUpdate));
                nullableFieldUpdate = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)nullableFieldUpdate, (String)"randomUUID().toString()");
                $this$new.setUuid((String)((Object)nullableFieldUpdate));
                nullableFieldUpdate = this.$updateObject.getAuthor();
                $this$new.setAuthor(nullableFieldUpdate == null ? null : nullableFieldUpdate.getT());
                nullableFieldUpdate = this.$updateObject.getCategory();
                $this$new.setCategory(nullableFieldUpdate == null ? null : nullableFieldUpdate.getT());
            }
        });
        RsdUpdateObject.copy$default(updateObject, (Long)newRsd2.getId().getValue(), null, null, null, null, null, null, null, null, 510, null).applyToDao(newRsd2);
        RichSkillDescriptorDao richSkillDescriptorDao = newRsd2;
        bl = false;
        boolean bl3 = false;
        RichSkillDescriptorDao it = richSkillDescriptorDao;
        boolean bl4 = false;
        Iterable iterable = (Iterable)it.getCollections();
        CollectionEsRepo collectionEsRepo = this.getCollectionEsRepo();
        boolean $i$f$map = false;
        void var12_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            CollectionDao collectionDao = (CollectionDao)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            CollectionDoc collectionDoc = CollectionDao.toDoc$default((CollectionDao)it2, false, 1, null);
            collection.add(collectionDoc);
        }
        collection = (List)destination$iv$iv;
        collectionEsRepo.saveAll(collection);
        RichSkillDoc cfr_ignored_0 = (RichSkillDoc)this.getRichSkillEsRepo().save(RichSkillDoc.Companion.fromDao(it, this.getAppConfig()));
        this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), ((Number)((Object)newRsd2.getId().getValue())).longValue(), RichSkillDescriptorKt.diff(newRsd2.toModel(), null), user, AuditOperationType.Insert));
        return newRsd2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RichSkillDescriptorDao> createFromApi(@NotNull List<ApiSkillUpdate> skillUpdates, @NotNull String user) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(skillUpdates, (String)"skillUpdates");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Iterable $this$mapIndexed$iv = skillUpdates;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void updateDto;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ApiSkillUpdate apiSkillUpdate = (ApiSkillUpdate)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object = updateDto.validateForCreation((int)i);
            collection.add(object);
        }
        List allErrors = CollectionsKt.flatten((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        $this$mapIndexed$iv = allErrors;
        $i$f$mapIndexed = false;
        if (!$this$mapIndexed$iv.isEmpty()) {
            throw new FormValidationException("Invalid SkillUpdateDescriptor", allErrors);
        }
        Iterable $this$map$iv = skillUpdates;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void update;
            ApiSkillUpdate apiSkillUpdate = (ApiSkillUpdate)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            RsdUpdateObject rsdUpdateObject = this.rsdUpdateFromApi((ApiSkillUpdate)update, user);
            object = this.create(rsdUpdateObject, user);
            collection.add(object);
        }
        List newSkills = (List)destination$iv$iv2;
        return CollectionsKt.filterNotNull((Iterable)newSkills);
    }

    @Override
    @Nullable
    public RichSkillDescriptorDao updateFromApi(long existingSkillId, @NotNull ApiSkillUpdate skillUpdate, @NotNull String user) {
        Boolean bl;
        List<ApiFieldError> errors;
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        List<ApiFieldError> list = errors = skillUpdate.validate(0);
        if (list == null) {
            bl = null;
        } else {
            Collection collection = list;
            boolean bl2 = false;
            bl = !collection.isEmpty();
        }
        if (Intrinsics.areEqual(bl, (Object)true)) {
            throw new FormValidationException("Invalid SkillUpdateDescriptor", errors);
        }
        RsdUpdateObject rsdUpdateObject = this.rsdUpdateFromApi(skillUpdate, user);
        RsdUpdateObject updateObjectWithId = RsdUpdateObject.copy$default(rsdUpdateObject, existingSkillId, null, null, null, null, null, null, null, null, 510, null);
        return this.update(updateObjectWithId, user);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RsdUpdateObject rsdUpdateFromApi(@NotNull ApiSkillUpdate skillUpdate, @NotNull String user) {
        NullableFieldUpdate<Object> nullableFieldUpdate;
        ListFieldUpdate listFieldUpdate;
        ListFieldUpdate allKeywordsUpdate;
        ListFieldUpdate listFieldUpdate2;
        Unit unit;
        Unit unit2;
        Unit unit3;
        Unit unit4;
        Unit unit5;
        boolean bl;
        Object object;
        Object it;
        Boolean bl2;
        Object it2;
        LongEntity longEntity;
        Collection destination$iv$iv;
        List<String> list;
        boolean bl3;
        boolean bl4;
        Object object2;
        Boolean bl5;
        boolean bl6;
        KeywordDao keywordDao;
        boolean bl7;
        boolean bl8;
        String string;
        KeywordDao keywordDao2;
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        String string2 = skillUpdate.getAuthor();
        if (string2 == null) {
            keywordDao2 = null;
        } else {
            string = string2;
            bl8 = false;
            bl7 = false;
            String it3 = string;
            boolean bl9 = false;
            keywordDao2 = KeywordRepository.DefaultImpls.findOrCreate$default(this.getKeywordRepository(), KeywordTypeEnum.Author, it3, null, null, 12, null);
        }
        KeywordDao authorKeyword = keywordDao2;
        string = skillUpdate.getCategory();
        if (string == null) {
            keywordDao = null;
        } else {
            String string3 = string;
            bl7 = false;
            boolean it3 = false;
            String it4 = string3;
            bl6 = false;
            keywordDao = KeywordRepository.DefaultImpls.findOrCreate$default(this.getKeywordRepository(), KeywordTypeEnum.Category, it4, null, null, 12, null);
        }
        KeywordDao categoryKeyword = keywordDao;
        bl8 = false;
        List addingCollections = new ArrayList();
        bl7 = false;
        List removingCollections = new ArrayList();
        boolean it3 = false;
        List addingKeywords = new ArrayList();
        boolean it4 = false;
        List removingKeywords = new ArrayList();
        bl6 = false;
        List jobsToAdd = new ArrayList();
        boolean bl10 = false;
        List jobsToRemove = new ArrayList();
        Object object3 = skillUpdate.getCollections();
        if (object3 == null) {
            bl5 = null;
        } else {
            boolean $this$mapNotNullTo$iv$iv32;
            List list2;
            boolean bl11;
            CollectionDao it$iv$iv;
            boolean bl12;
            boolean bl13;
            CollectionDao collectionDao;
            String it5;
            boolean bl14;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterator iterator;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv$iv$iv;
            boolean $i$f$mapNotNullTo;
            boolean $i$f$mapNotNull;
            Iterable $this$mapNotNull$iv;
            Boolean bl15;
            object2 = object3;
            bl4 = false;
            bl3 = false;
            ApiStringListUpdate slu = object2;
            boolean bl16 = false;
            list = slu.getAdd();
            if (list == null) {
                bl15 = null;
            } else {
                void $this$mapNotNullTo$iv$iv32;
                $this$mapNotNull$iv = list;
                $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv32;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl14 = false;
                    it5 = (String)element$iv$iv;
                    boolean bl17 = false;
                    longEntity = this.getCollectionRepository().findByName(it5);
                    if ((longEntity == null ? this.getCollectionRepository().create(it5, user) : longEntity) == null) continue;
                    collectionDao = collectionDao;
                    bl13 = false;
                    bl12 = false;
                    it$iv$iv = collectionDao;
                    bl11 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                $this$mapNotNull$iv = list2;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv32 = false;
                it2 = $this$mapNotNull$iv;
                boolean bl18 = false;
                bl15 = addingCollections.addAll((Collection)it2);
            }
            list = slu.getRemove();
            if (list == null) {
                bl5 = null;
            } else {
                $this$mapNotNull$iv = list;
                $i$f$mapNotNull = false;
                Iterable $this$mapNotNullTo$iv$iv32 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv32;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl14 = false;
                    it5 = (String)element$iv$iv;
                    boolean bl19 = false;
                    longEntity = this.getCollectionRepository().findByName(it5);
                    if ((longEntity == null ? this.getCollectionRepository().create(it5, user) : longEntity) == null) continue;
                    collectionDao = collectionDao;
                    bl13 = false;
                    bl12 = false;
                    it$iv$iv = collectionDao;
                    bl11 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                $this$mapNotNull$iv = list2;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv32 = false;
                it2 = $this$mapNotNull$iv;
                boolean bl20 = false;
                bl5 = removingCollections.addAll((Collection)it2);
            }
        }
        object3 = skillUpdate.getOccupations();
        if (object3 == null) {
            bl2 = null;
        } else {
            List list3;
            boolean $i$f$mapTo;
            boolean $i$f$map;
            Iterable $this$map$iv;
            Boolean bl21;
            boolean bl22;
            CharSequence charSequence;
            String it6;
            boolean $i$f$filterTo;
            boolean $i$f$filter;
            Iterable $this$filter$iv;
            List list4;
            object2 = object3;
            bl4 = false;
            bl3 = false;
            it = object2;
            boolean bl23 = false;
            list = ((ApiStringListUpdate)it).getAdd();
            if (list == null) {
                list4 = null;
            } else {
                void $this$filterTo$iv$iv;
                $this$filter$iv = list;
                $i$f$filter = false;
                Iterable $this$mapNotNullTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it6 = (String)element$iv$iv;
                    boolean bl24 = false;
                    charSequence = it6;
                    bl22 = false;
                    boolean bl25 = !StringsKt.isBlank((CharSequence)charSequence);
                    if (!bl25) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list4 = (List)destination$iv$iv;
            }
            List list5 = list4;
            if (list5 == null) {
                bl21 = null;
            } else {
                void $this$mapTo$iv$iv2;
                $this$map$iv = list5;
                $i$f$map = false;
                Iterable $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it6 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl26 = false;
                    longEntity = JobCodeRepository.DefaultImpls.findByCodeOrCreate$default(this.getJobCodeRepository(), it6, null, 2, null);
                    collection.add(longEntity);
                }
                list = (List)destination$iv$iv;
                $this$map$iv = list;
                $i$f$map = false;
                boolean $this$mapTo$iv$iv2 = false;
                it2 = $this$map$iv;
                boolean bl27 = false;
                bl21 = jobsToAdd.addAll((Collection)it2);
            }
            list = ((ApiStringListUpdate)it).getRemove();
            if (list == null) {
                list3 = null;
            } else {
                void $this$filterTo$iv$iv;
                $this$filter$iv = list;
                $i$f$filter = false;
                Iterable $this$mapTo$iv$iv2 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it6 = (String)element$iv$iv;
                    boolean bl28 = false;
                    charSequence = it6;
                    bl22 = false;
                    boolean bl29 = !StringsKt.isBlank((CharSequence)charSequence);
                    if (!bl29) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            }
            list5 = list3;
            if (list5 == null) {
                bl2 = null;
            } else {
                void $this$mapTo$iv$iv;
                $this$map$iv = list5;
                $i$f$map = false;
                Iterable $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it6 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl30 = false;
                    longEntity = this.getJobCodeRepository().findByCode(it6);
                    collection.add(longEntity);
                }
                list = (List)destination$iv$iv;
                object = list;
                bl = false;
                boolean bl31 = false;
                it2 = object;
                boolean bl32 = false;
                bl2 = jobsToRemove.addAll(CollectionsKt.filterNotNull((Iterable)it2));
            }
        }
        object3 = skillUpdate.getKeywords();
        if (object3 == null) {
            unit5 = null;
        } else {
            object2 = object3;
            bl4 = false;
            bl3 = false;
            it = object2;
            boolean bl33 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupKeywords(this, addingKeywords, removingKeywords, (ApiStringListUpdate)it, KeywordTypeEnum.Keyword);
            unit5 = Unit.INSTANCE;
        }
        object3 = skillUpdate.getCertifications();
        if (object3 == null) {
            unit4 = null;
        } else {
            object2 = object3;
            bl4 = false;
            bl3 = false;
            it = object2;
            boolean bl34 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupReferences(this, addingKeywords, removingKeywords, (ApiReferenceListUpdate)it, KeywordTypeEnum.Certification);
            unit4 = Unit.INSTANCE;
        }
        object3 = skillUpdate.getStandards();
        if (object3 == null) {
            unit3 = null;
        } else {
            object2 = object3;
            bl4 = false;
            bl3 = false;
            it = object2;
            boolean bl35 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupAlignments(this, addingKeywords, removingKeywords, (ApiAlignmentListUpdate)it, KeywordTypeEnum.Standard);
            unit3 = Unit.INSTANCE;
        }
        object3 = skillUpdate.getAlignments();
        if (object3 == null) {
            unit2 = null;
        } else {
            object2 = object3;
            bl4 = false;
            bl3 = false;
            it = object2;
            boolean bl36 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupAlignments(this, addingKeywords, removingKeywords, (ApiAlignmentListUpdate)it, KeywordTypeEnum.Alignment);
            unit2 = Unit.INSTANCE;
        }
        object3 = skillUpdate.getEmployers();
        if (object3 == null) {
            unit = null;
        } else {
            object2 = object3;
            bl4 = false;
            bl3 = false;
            it = object2;
            boolean bl37 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupReferences(this, addingKeywords, removingKeywords, (ApiReferenceListUpdate)it, KeywordTypeEnum.Employer);
            unit = Unit.INSTANCE;
        }
        if (addingKeywords.size() > 0 || removingKeywords.size() > 0) {
            List list6;
            List list7;
            if (addingKeywords.size() > 0) {
                list7 = addingKeywords;
            } else {
                boolean bl38 = false;
                list7 = CollectionsKt.emptyList();
            }
            if (removingKeywords.size() > 0) {
                list6 = removingKeywords;
            } else {
                boolean bl39 = false;
                list6 = CollectionsKt.emptyList();
            }
            listFieldUpdate2 = new ListFieldUpdate(list7, list6);
        } else {
            listFieldUpdate2 = allKeywordsUpdate = (ListFieldUpdate)null;
        }
        if (jobsToAdd.size() > 0 || jobsToRemove.size() > 0) {
            List list8;
            List list9;
            if (jobsToAdd.size() > 0) {
                list9 = jobsToAdd;
            } else {
                bl4 = false;
                list9 = CollectionsKt.emptyList();
            }
            if (jobsToRemove.size() > 0) {
                list8 = jobsToRemove;
            } else {
                bl4 = false;
                list8 = CollectionsKt.emptyList();
            }
            listFieldUpdate = new ListFieldUpdate(list9, list8);
        } else {
            listFieldUpdate = null;
        }
        ListFieldUpdate jobCodesUpdate = listFieldUpdate;
        String string4 = skillUpdate.getSkillName();
        String string5 = skillUpdate.getSkillStatement();
        PublishStatus publishStatus = skillUpdate.getPublishStatus();
        list = authorKeyword;
        if (list == null) {
            nullableFieldUpdate = null;
        } else {
            object = list;
            bl = false;
            boolean bl40 = false;
            it2 = object;
            boolean bl41 = false;
            nullableFieldUpdate = new NullableFieldUpdate<Object>(it2);
        }
        NullableFieldUpdate<Object> nullableFieldUpdate2 = nullableFieldUpdate;
        list = skillUpdate.getCategory() != null || Intrinsics.areEqual((Object)((object = skillUpdate.getCategory()) == null ? null : Boolean.valueOf(StringsKt.isBlank((CharSequence)((CharSequence)object)))), (Object)true) ? new NullableFieldUpdate<KeywordDao>(categoryKeyword) : null;
        object = addingCollections.size() + removingCollections.size() > 0 ? new ListFieldUpdate(addingCollections, removingCollections) : null;
        return new RsdUpdateObject(null, string4, string5, nullableFieldUpdate2, (NullableFieldUpdate)((Object)list), allKeywordsUpdate, jobCodesUpdate, (ListFieldUpdate)object, publishStatus, 1, null);
    }

    @Override
    @NotNull
    public ApiBatchResult changeStatusesForTask(@NotNull PublishTask publishTask) {
        Intrinsics.checkNotNullParameter((Object)publishTask, (String)"publishTask");
        Ref.IntRef modifiedCount = new Ref.IntRef();
        int totalCount = 0;
        Function2 publishSkill2 = (Function2)new Function2<RichSkillDescriptorDao, PublishTask, Boolean>(this){
            final /* synthetic */ RichSkillRepositoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final boolean invoke(@NotNull RichSkillDescriptorDao skillDao, @NotNull PublishTask task) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)skillDao, (String)"skillDao");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                PublishStatus oldStatus = skillDao.publishStatus();
                if (oldStatus != task.getPublishStatus()) {
                    PublishStatus newStatus;
                    RsdUpdateObject updateObj = new RsdUpdateObject((Long)skillDao.getId().getValue(), null, null, null, null, null, null, null, task.getPublishStatus(), 254, null);
                    RichSkillDescriptorDao updatedDao = this.this$0.update(updateObj, task.getUserString());
                    RichSkillDescriptorDao richSkillDescriptorDao = updatedDao;
                    PublishStatus publishStatus = newStatus = richSkillDescriptorDao == null ? null : richSkillDescriptorDao.publishStatus();
                    bl = newStatus != oldStatus;
                } else {
                    bl = false;
                }
                return bl;
            }
        };
        Function1 handleSkillDao2 = (Function1)new Function1<RichSkillDescriptorDao, Unit>((Function2<? super RichSkillDescriptorDao, ? super PublishTask, Boolean>)publishSkill2, publishTask, modifiedCount){
            final /* synthetic */ Function2<RichSkillDescriptorDao, PublishTask, Boolean> $publishSkill;
            final /* synthetic */ PublishTask $publishTask;
            final /* synthetic */ Ref.IntRef $modifiedCount;
            {
                this.$publishSkill = $publishSkill;
                this.$publishTask = $publishTask;
                this.$modifiedCount = $modifiedCount;
                super(1);
            }

            @Nullable
            public final Unit invoke(@Nullable RichSkillDescriptorDao skillDao) {
                Unit unit;
                RichSkillDescriptorDao richSkillDescriptorDao = skillDao;
                if (richSkillDescriptorDao == null) {
                    unit = null;
                } else {
                    RichSkillDescriptorDao richSkillDescriptorDao2 = richSkillDescriptorDao;
                    Function2<RichSkillDescriptorDao, PublishTask, Boolean> function2 = this.$publishSkill;
                    PublishTask publishTask = this.$publishTask;
                    Ref.IntRef intRef = this.$modifiedCount;
                    boolean bl = false;
                    boolean bl2 = false;
                    RichSkillDescriptorDao it = richSkillDescriptorDao2;
                    boolean bl3 = false;
                    if (((Boolean)function2.invoke((Object)it, (Object)publishTask)).booleanValue()) {
                        ++intRef.element;
                    }
                    unit = Unit.INSTANCE;
                }
                return unit;
            }
        };
        Collection collection = publishTask.getSearch().getUuids();
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            totalCount = publishTask.getSearch().getUuids().size();
            Iterable $this$forEach$iv = publishTask.getSearch().getUuids();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String uuid = (String)element$iv;
                boolean bl3 = false;
                handleSkillDao2.invoke((Object)this.findByUUID(uuid));
            }
        } else {
            RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
            ApiSearch apiSearch = publishTask.getSearch();
            Set<PublishStatus> set = publishTask.getFilterByStatus();
            Pageable $i$f$forEach = Pageable.unpaged();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach, (String)"unpaged()");
            SearchHits searchHits = richSkillEsRepo.byApiSearch(apiSearch, set, $i$f$forEach, publishTask.getCollectionUuid());
            totalCount = (int)searchHits.getTotalHits();
            Iterable $this$forEach$iv = (Iterable)searchHits;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                SearchHit hit = (SearchHit)element$iv;
                boolean bl4 = false;
                handleSkillDao2.invoke((Object)this.findById(((RichSkillDoc)hit.getContent()).getId()));
            }
        }
        return new ApiBatchResult(true, null, modifiedCount.element, totalCount, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SizedIterable<RichSkillDescriptorDao> containingJobCode(@NotNull String jobCode) {
        void $this$containingJobCode_u24lambda_u2d48;
        Intrinsics.checkNotNullParameter((Object)jobCode, (String)"jobCode");
        FieldSet $this$select$iv = RichSkillDescriptorTable.INSTANCE.innerJoin((ColumnSet)RichSkillJobCodes.INSTANCE).innerJoin((ColumnSet)JobCodeTable.INSTANCE).slice(RichSkillDescriptorTable.INSTANCE.getColumns());
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        Op op = $this$containingJobCode_u24lambda_u2d48.eq((ExpressionWithColumnType)JobCodeTable.INSTANCE.getCode(), (Object)jobCode);
        Query query = QueriesKt.select((FieldSet)fieldSet, (Op)op);
        return RichSkillDescriptorDao.Companion.wrapRows((SizedIterable)query);
    }

    @Override
    @NotNull
    public Query publishStatusSetToQuery(@NotNull Set<? extends PublishStatus> publishStatusSet) {
        return RichSkillRepository.DefaultImpls.publishStatusSetToQuery(this, publishStatusSet);
    }

    @Override
    @NotNull
    public Streamable<Pair<Column<?>, SortOrder>> sortToQueryOrder(@NotNull Sort sort, @NotNull Query query) {
        return RichSkillRepository.DefaultImpls.sortToQueryOrder(this, sort, query);
    }

    private static final void rsdUpdateFromApi$lookupReferences(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiReferenceListUpdate lud, KeywordTypeEnum keywordType) {
        Iterable it;
        KeywordDao keywordDao;
        ApiNamedReference it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        List list;
        List list2 = lud.getAdd();
        if (list2 == null) {
            list = null;
        } else {
            $this$map$iv = list2;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                ApiNamedReference apiNamedReference = (ApiNamedReference)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                keywordDao = KeywordRepository.DefaultImpls.findOrCreate$default(this$0.getKeywordRepository(), keywordType, it2.getName(), it2.getId(), null, 8, null);
                collection.add(keywordDao);
            }
            list = (List)destination$iv$iv;
        }
        List list3 = list;
        if (list3 != null && (list2 = CollectionsKt.filterNotNull((Iterable)list3)) != null) {
            $this$map$iv = list2;
            $i$f$map = false;
            boolean $this$mapTo$iv$iv2 = false;
            it = $this$map$iv;
            boolean bl = false;
            addingKeywords.addAll((Collection)it);
        }
        if ((list3 = lud.getRemove()) != null) {
            $this$map$iv = list3;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it2 = (ApiNamedReference)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                keywordDao = KeywordRepository.DefaultImpls.findByValueOrUri$default(this$0.getKeywordRepository(), keywordType, it2.getName(), it2.getId(), null, 8, null);
                collection.add(keywordDao);
            }
            List list4 = list2 = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            it = list4;
            boolean bl3 = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it));
        }
    }

    private static final void rsdUpdateFromApi$lookupAlignments(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiAlignmentListUpdate lud, KeywordTypeEnum keywordType) {
        Iterable it;
        KeywordDao keywordDao;
        ApiNamedReference apiNamedReference;
        ApiAlignment it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        List list;
        List list2 = lud.getAdd();
        if (list2 == null) {
            list = null;
        } else {
            $this$map$iv = list2;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                ApiAlignment apiAlignment = (ApiAlignment)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                keywordDao = this$0.getKeywordRepository().findOrCreate(keywordType, it2.getSkillName(), it2.getId(), (apiNamedReference = it2.isPartOf()) == null ? null : apiNamedReference.getName());
                collection.add(keywordDao);
            }
            list = (List)destination$iv$iv;
        }
        List list3 = list;
        if (list3 != null && (list2 = CollectionsKt.filterNotNull((Iterable)list3)) != null) {
            $this$map$iv = list2;
            $i$f$map = false;
            boolean $this$mapTo$iv$iv2 = false;
            it = $this$map$iv;
            boolean bl = false;
            addingKeywords.addAll((Collection)it);
        }
        if ((list3 = lud.getRemove()) != null) {
            $this$map$iv = list3;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it2 = (ApiAlignment)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                keywordDao = this$0.getKeywordRepository().findByValueOrUri(keywordType, it2.getSkillName(), it2.getId(), (apiNamedReference = it2.isPartOf()) == null ? null : apiNamedReference.getName());
                collection.add(keywordDao);
            }
            List list4 = list2 = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            it = list4;
            boolean bl3 = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it));
        }
    }

    private static final void rsdUpdateFromApi$lookupKeywords(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiStringListUpdate slud, KeywordTypeEnum keywordType) {
        Iterable it;
        KeywordDao keywordDao;
        String it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        List list;
        List list2 = slud.getAdd();
        if (list2 == null) {
            list = null;
        } else {
            $this$map$iv = list2;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                keywordDao = KeywordRepository.DefaultImpls.findOrCreate$default(this$0.getKeywordRepository(), keywordType, it2, null, null, 12, null);
                collection.add(keywordDao);
            }
            list = (List)destination$iv$iv;
        }
        List list3 = list;
        if (list3 != null && (list2 = CollectionsKt.filterNotNull((Iterable)list3)) != null) {
            $this$map$iv = list2;
            $i$f$map = false;
            boolean $this$mapTo$iv$iv2 = false;
            it = $this$map$iv;
            boolean bl = false;
            addingKeywords.addAll((Collection)it);
        }
        if ((list3 = slud.getRemove()) != null) {
            $this$map$iv = list3;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                keywordDao = KeywordRepository.DefaultImpls.findByValueOrUri$default(this$0.getKeywordRepository(), keywordType, it2, null, null, 12, null);
                collection.add(keywordDao);
            }
            List list4 = list2 = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            it = list4;
            boolean bl3 = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it));
        }
    }
}

