/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.collection;

import com.github.sonus21.rqueue.annotation.RqueueListener;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.collection.CsvTaskProcessor;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.richskill.RichSkillAndCollections;
import edu.wgu.osmt.richskill.RichSkillCsvExport;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.task.CsvTask;
import edu.wgu.osmt.task.TaskMessageService;
import edu.wgu.osmt.task.TaskStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.ReferencesKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Profile(value={"apiserver"})
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00148\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u001a8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Ledu/wgu/osmt/collection/CsvTaskProcessor;", "", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "setAppConfig", "(Ledu/wgu/osmt/config/AppConfig;)V", "collectionRepository", "Ledu/wgu/osmt/collection/CollectionRepository;", "getCollectionRepository", "()Ledu/wgu/osmt/collection/CollectionRepository;", "setCollectionRepository", "(Ledu/wgu/osmt/collection/CollectionRepository;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "setRichSkillRepository", "(Ledu/wgu/osmt/richskill/RichSkillRepository;)V", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "setTaskMessageService", "(Ledu/wgu/osmt/task/TaskMessageService;)V", "csvSkillsInCollectionProcessor", "", "csvTask", "Ledu/wgu/osmt/task/CsvTask;", "csvSkillsInFullLibraryProcessor", "osmt-api"})
public class CsvTaskProcessor {
    @NotNull
    private final Logger logger;
    @Autowired
    public TaskMessageService taskMessageService;
    @Autowired
    public CollectionRepository collectionRepository;
    @Autowired
    public RichSkillRepository richSkillRepository;
    @Autowired
    public AppConfig appConfig;

    public CsvTaskProcessor() {
        Logger logger = LoggerFactory.getLogger(CsvTaskProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CsvTaskProcessor::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        TaskMessageService taskMessageService = this.taskMessageService;
        if (taskMessageService != null) {
            return taskMessageService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"taskMessageService");
        throw null;
    }

    public void setTaskMessageService(@NotNull TaskMessageService taskMessageService) {
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"<set-?>");
        this.taskMessageService = taskMessageService;
    }

    @NotNull
    public CollectionRepository getCollectionRepository() {
        CollectionRepository collectionRepository = this.collectionRepository;
        if (collectionRepository != null) {
            return collectionRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"collectionRepository");
        throw null;
    }

    public void setCollectionRepository(@NotNull CollectionRepository collectionRepository) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"<set-?>");
        this.collectionRepository = collectionRepository;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        RichSkillRepository richSkillRepository = this.richSkillRepository;
        if (richSkillRepository != null) {
            return richSkillRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"richSkillRepository");
        throw null;
    }

    public void setRichSkillRepository(@NotNull RichSkillRepository richSkillRepository) {
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"<set-?>");
        this.richSkillRepository = richSkillRepository;
    }

    @NotNull
    public AppConfig getAppConfig() {
        AppConfig appConfig = this.appConfig;
        if (appConfig != null) {
            return appConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appConfig");
        throw null;
    }

    public void setAppConfig(@NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"<set-?>");
        this.appConfig = appConfig;
    }

    /*
     * WARNING - void declaration
     */
    @RqueueListener(value={"collection-skills-csv-process"}, deadLetterQueue="dead-letters", deadLetterQueueListenerEnabled="true", concurrency="1")
    public void csvSkillsInCollectionProcessor(@NotNull CsvTask csvTask) {
        String string;
        List list;
        Object object;
        List list2;
        Intrinsics.checkNotNullParameter((Object)csvTask, (String)"csvTask");
        this.getLogger().info(Intrinsics.stringPlus((String)"Started processing task id: ", (Object)csvTask.getUuid()));
        Object object2 = this.getCollectionRepository().findByUUID(csvTask.getCollectionUuid());
        if (object2 == null) {
            list2 = null;
        } else {
            object = ((CollectionDao)object2).getSkills();
            if (object == null) {
                list2 = null;
            } else {
                KProperty1[] kProperty1Array = new KProperty1[]{(KProperty1)csvSkillsInCollectionProcessor.csv.1.INSTANCE};
                list2 = list = ReferencesKt.with(object, (KProperty1[])kProperty1Array);
            }
        }
        if (list == null) {
            string = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = list;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RichSkillAndCollections richSkillAndCollections = RichSkillAndCollections.Companion.fromDao((RichSkillDescriptorDao)it);
                collection.add(richSkillAndCollections);
            }
            object2 = (List)destination$iv$iv;
            object = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            string = new RichSkillCsvExport(this.getAppConfig()).toCsv(it);
        }
        String csv2 = string;
        this.getTaskMessageService().publishResult(CsvTask.copy$default(csvTask, null, null, null, csv2, TaskStatus.Ready, 7, null));
        this.getLogger().info("Task " + csvTask.getUuid() + " completed");
    }

    /*
     * WARNING - void declaration
     */
    @RqueueListener(value={"full-library-skills-csv-process"}, deadLetterQueue="dead-letters", deadLetterQueueListenerEnabled="true", concurrency="1")
    public void csvSkillsInFullLibraryProcessor(@NotNull CsvTask csvTask) {
        String string;
        List list;
        Object object;
        List list2;
        Intrinsics.checkNotNullParameter((Object)csvTask, (String)"csvTask");
        this.getLogger().info("Started processing task for Full Library export");
        Object object2 = this.getRichSkillRepository().findAll();
        if (object2 == null) {
            list2 = null;
        } else {
            object = new KProperty1[]{(KProperty1)csvSkillsInFullLibraryProcessor.csv.1.INSTANCE};
            list2 = list = ReferencesKt.with(object2, (KProperty1[])object);
        }
        if (list == null) {
            string = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object = list;
            boolean $i$f$map = false;
            void var7_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RichSkillAndCollections richSkillAndCollections = RichSkillAndCollections.Companion.fromDao((RichSkillDescriptorDao)it);
                collection.add(richSkillAndCollections);
            }
            object = object2 = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            string = new RichSkillCsvExport(this.getAppConfig()).toCsv(it);
        }
        String csv2 = string;
        this.getTaskMessageService().publishResult(CsvTask.copy$default(csvTask, null, null, null, csv2, TaskStatus.Ready, 7, null));
        this.getLogger().info("Full Library export task completed");
    }
}

