/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.richskill;

import edu.wgu.osmt.HasAllPaginated;
import edu.wgu.osmt.api.GeneralApiException;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.api.model.ApiSkill;
import edu.wgu.osmt.api.model.ApiSkillUpdate;
import edu.wgu.osmt.api.model.SkillSortEnum;
import edu.wgu.osmt.api.model.SortOrderCompanion;
import edu.wgu.osmt.auditlog.AuditLog;
import edu.wgu.osmt.auditlog.AuditLogDao;
import edu.wgu.osmt.auditlog.AuditLogRepository;
import edu.wgu.osmt.auditlog.AuditLogSortEnum;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.elasticsearch.OffsetPageable;
import edu.wgu.osmt.keyword.KeywordDao;
import edu.wgu.osmt.richskill.RichSkillAndCollections;
import edu.wgu.osmt.richskill.RichSkillCsvExport;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillDescriptorTable;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.security.OAuthHelper;
import edu.wgu.osmt.task.AppliesToType;
import edu.wgu.osmt.task.CreateSkillsTask;
import edu.wgu.osmt.task.CsvTask;
import edu.wgu.osmt.task.PublishTask;
import edu.wgu.osmt.task.Task;
import edu.wgu.osmt.task.TaskMessageService;
import edu.wgu.osmt.task.TaskResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.SizedIterable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJU\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011032\b\u00104\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u00107J \u00108\u001a\u0004\u0018\u0001092\b\b\u0001\u0010:\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\"\u0010;\u001a\u0006\u0012\u0002\b\u00030+2\b\b\u0001\u0010:\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u001e\u0010<\u001a\u00020\u00112\b\b\u0001\u0010:\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J*\u0010=\u001a\b\u0012\u0004\u0012\u00020>0+2\u000e\b\u0001\u0010?\u001a\b\u0012\u0004\u0012\u00020@0,2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020>0+2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017JH\u0010B\u001a\b\u0012\u0004\u0012\u00020>0+2\b\b\u0001\u0010C\u001a\u00020D2\b\b\u0001\u0010E\u001a\u00020\u00112\u000e\b\u0001\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00110,2\b\b\u0001\u0010G\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u001e\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0,0+2\b\b\u0001\u0010:\u001a\u00020\u0011H\u0017J(\u0010J\u001a\u0002092\b\b\u0001\u0010:\u001a\u00020\u00112\b\b\u0001\u0010K\u001a\u00020@2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006L"}, d2={"Ledu/wgu/osmt/richskill/RichSkillController;", "Ledu/wgu/osmt/HasAllPaginated;", "Ledu/wgu/osmt/richskill/RichSkillDoc;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "auditLogRepository", "Ledu/wgu/osmt/auditlog/AuditLogRepository;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "oAuthHelper", "Ledu/wgu/osmt/security/OAuthHelper;", "(Ledu/wgu/osmt/richskill/RichSkillRepository;Ledu/wgu/osmt/task/TaskMessageService;Ledu/wgu/osmt/richskill/RichSkillEsRepo;Ledu/wgu/osmt/auditlog/AuditLogRepository;Ledu/wgu/osmt/config/AppConfig;Ledu/wgu/osmt/security/OAuthHelper;)V", "allPaginatedPath", "", "getAllPaginatedPath", "()Ljava/lang/String;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getAuditLogRepository", "()Ledu/wgu/osmt/auditlog/AuditLogRepository;", "elasticRepository", "getElasticRepository", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "keywordDao", "Ledu/wgu/osmt/keyword/KeywordDao$Companion;", "getKeywordDao", "()Ledu/wgu/osmt/keyword/KeywordDao$Companion;", "getOAuthHelper", "()Ledu/wgu/osmt/security/OAuthHelper;", "getRichSkillEsRepo", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "sortOrderCompanion", "Ledu/wgu/osmt/api/model/SkillSortEnum$Companion;", "getSortOrderCompanion", "()Ledu/wgu/osmt/api/model/SkillSortEnum$Companion;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "allPaginated", "Lorg/springframework/http/HttpEntity;", "", "uriComponentsBuilder", "Lorg/springframework/web/util/UriComponentsBuilder;", "size", "", "from", "status", "", "sort", "user", "Lorg/springframework/security/oauth2/jwt/Jwt;", "(Lorg/springframework/web/util/UriComponentsBuilder;II[Ljava/lang/String;Ljava/lang/String;Lorg/springframework/security/oauth2/jwt/Jwt;)Lorg/springframework/http/HttpEntity;", "byUUID", "Ledu/wgu/osmt/api/model/ApiSkill;", "uuid", "byUUIDCsvView", "byUUIDHtmlView", "createSkills", "Ledu/wgu/osmt/task/TaskResult;", "apiSkillUpdates", "Ledu/wgu/osmt/api/model/ApiSkillUpdate;", "exportLibrary", "publishSkills", "search", "Ledu/wgu/osmt/api/model/ApiSearch;", "newStatus", "filterByStatus", "collectionUuid", "skillAuditLog", "Ledu/wgu/osmt/auditlog/AuditLog;", "updateSkill", "skillUpdate", "osmt-api"})
public class RichSkillController
implements HasAllPaginated<RichSkillDoc> {
    @NotNull
    private final RichSkillRepository richSkillRepository;
    @NotNull
    private final TaskMessageService taskMessageService;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final AuditLogRepository auditLogRepository;
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final OAuthHelper oAuthHelper;
    @NotNull
    private final RichSkillEsRepo elasticRepository;
    @NotNull
    private final KeywordDao.Companion keywordDao;
    @NotNull
    private final String allPaginatedPath;
    @NotNull
    private final SkillSortEnum.Companion sortOrderCompanion;

    @Autowired
    public RichSkillController(@NotNull RichSkillRepository richSkillRepository, @NotNull TaskMessageService taskMessageService, @NotNull RichSkillEsRepo richSkillEsRepo, @NotNull AuditLogRepository auditLogRepository, @NotNull AppConfig appConfig, @NotNull OAuthHelper oAuthHelper) {
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"richSkillRepository");
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"taskMessageService");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        Intrinsics.checkNotNullParameter((Object)auditLogRepository, (String)"auditLogRepository");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)oAuthHelper, (String)"oAuthHelper");
        this.richSkillRepository = richSkillRepository;
        this.taskMessageService = taskMessageService;
        this.richSkillEsRepo = richSkillEsRepo;
        this.auditLogRepository = auditLogRepository;
        this.appConfig = appConfig;
        this.oAuthHelper = oAuthHelper;
        this.elasticRepository = this.getRichSkillEsRepo();
        this.keywordDao = KeywordDao.Companion;
        this.allPaginatedPath = "/api/skills";
        this.sortOrderCompanion = SkillSortEnum.Companion;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        return this.richSkillRepository;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        return this.taskMessageService;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public AuditLogRepository getAuditLogRepository() {
        return this.auditLogRepository;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public OAuthHelper getOAuthHelper() {
        return this.oAuthHelper;
    }

    @NotNull
    public RichSkillEsRepo getElasticRepository() {
        return this.elasticRepository;
    }

    @NotNull
    public KeywordDao.Companion getKeywordDao() {
        return this.keywordDao;
    }

    @Override
    @NotNull
    public String getAllPaginatedPath() {
        return this.allPaginatedPath;
    }

    @NotNull
    public SkillSortEnum.Companion getSortOrderCompanion() {
        return this.sortOrderCompanion;
    }

    @Override
    @GetMapping(value={"/api/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<RichSkillDoc>> allPaginated(@NotNull UriComponentsBuilder uriComponentsBuilder, int size, int from, @NotNull String[] status, @Nullable String sort, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (!this.getAppConfig().getAllowPublicLists() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        return HasAllPaginated.DefaultImpls.allPaginated(this, uriComponentsBuilder, size, from, status, sort, user);
    }

    @PostMapping(value={"/api/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> createSkills(@RequestBody @NotNull List<ApiSkillUpdate> apiSkillUpdates, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter(apiSkillUpdates, (String)"apiSkillUpdates");
        CreateSkillsTask task = new CreateSkillsTask(apiSkillUpdates, null, null, null, null, null, 62, null);
        this.getTaskMessageService().enqueueJob("create-skills", task);
        return Task.Companion.processingResponse(task);
    }

    @GetMapping(value={"/api/skills/{uuid}"}, produces={"application/json"})
    @ResponseBody
    @Nullable
    public ApiSkill byUUID(@PathVariable @NotNull String uuid, @AuthenticationPrincipal @Nullable Jwt user) {
        ApiSkill apiSkill;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        RichSkillDescriptorDao richSkillDescriptorDao = this.getRichSkillRepository().findByUUID(uuid);
        if (richSkillDescriptorDao == null) {
            apiSkill = null;
        } else {
            RichSkillDescriptorDao richSkillDescriptorDao2 = richSkillDescriptorDao;
            boolean bl = false;
            boolean bl2 = false;
            RichSkillDescriptorDao it = richSkillDescriptorDao2;
            boolean bl3 = false;
            if (user == null && it.publishStatus() == PublishStatus.Unarchived) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND);
            }
            apiSkill = ApiSkill.Companion.fromDao(it, this.getAppConfig());
        }
        ApiSkill apiSkill2 = apiSkill;
        if (apiSkill2 == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        return apiSkill2;
    }

    @RequestMapping(value={"/api/skills/{uuid}"}, produces={"text/html"})
    @NotNull
    public String byUUIDHtmlView(@PathVariable @NotNull String uuid, @AuthenticationPrincipal @Nullable Jwt user) {
        String string;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        RichSkillDescriptorDao richSkillDescriptorDao = this.getRichSkillRepository().findByUUID(uuid);
        if (richSkillDescriptorDao == null) {
            string = null;
        } else {
            RichSkillDescriptorDao richSkillDescriptorDao2 = richSkillDescriptorDao;
            boolean bl = false;
            boolean bl2 = false;
            RichSkillDescriptorDao it = richSkillDescriptorDao2;
            boolean bl3 = false;
            if (user == null && it.publishStatus() == PublishStatus.Unarchived) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND);
            }
            string = Intrinsics.stringPlus((String)"forward:/skills/", (Object)uuid);
        }
        String string2 = string;
        if (string2 == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"/api/skills/{uuid}"}, produces={"text/csv"})
    @NotNull
    public HttpEntity<?> byUUIDCsvView(@PathVariable @NotNull String uuid, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        RichSkillDescriptorDao richSkillDescriptorDao = this.getRichSkillRepository().findByUUID(uuid);
        if (richSkillDescriptorDao != null) {
            void $this$mapTo$iv$iv;
            RichSkillDescriptorDao richSkillDescriptorDao2 = richSkillDescriptorDao;
            boolean bl = false;
            boolean bl2 = false;
            RichSkillDescriptorDao it = richSkillDescriptorDao2;
            boolean bl3 = false;
            if (user == null && it.publishStatus() == PublishStatus.Unarchived) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND);
            }
            RichSkillDescriptor skill = it.toModel();
            Iterable $this$map$iv = (Iterable)it.getCollections();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                CollectionDao collectionDao = (CollectionDao)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                edu.wgu.osmt.collection.Collection collection2 = it2.toModel();
                collection.add(collection2);
            }
            Set collections = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            String result = new RichSkillCsvExport(this.getAppConfig()).toCsv(CollectionsKt.listOf((Object)new RichSkillAndCollections(skill, collections)));
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Content-Type", "text/csv");
            iterable = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)result);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"ok().headers(responseHeaders).body(result)");
            return (HttpEntity)iterable;
        }
        Object var3_23 = null;
        throw new ResponseStatusException(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/skills/{uuid}/update"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public ApiSkill updateSkill(@PathVariable @NotNull String uuid, @RequestBody @NotNull ApiSkillUpdate skillUpdate, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        if (this.getOAuthHelper().hasRole(this.getAppConfig().getRoleCurator()) && !this.getOAuthHelper().isArchiveRelated(skillUpdate.getPublishStatus())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        RichSkillDescriptorDao richSkillDescriptorDao = this.getRichSkillRepository().findByUUID(uuid);
        if (richSkillDescriptorDao == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        RichSkillDescriptorDao existingSkill = richSkillDescriptorDao;
        RichSkillDescriptorDao richSkillDescriptorDao2 = this.getRichSkillRepository().updateFromApi(((Number)((Object)existingSkill.getId().getValue())).longValue(), skillUpdate, OAuthHelper.readableUsername$default(this.getOAuthHelper(), user, null, 2, null));
        if (richSkillDescriptorDao2 == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
        RichSkillDescriptorDao updatedSkill = richSkillDescriptorDao2;
        return ApiSkill.Companion.fromDao(updatedSkill, this.getAppConfig());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/api/skills/publish"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> publishSkills(@RequestBody @NotNull ApiSearch search, @RequestParam(required=false, defaultValue="Published") @NotNull String newStatus, @RequestParam(required=false, defaultValue="draft,published") @NotNull List<String> filterByStatus, @RequestParam(required=false, defaultValue="") @NotNull String collectionUuid, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        Intrinsics.checkNotNullParameter(filterByStatus, (String)"filterByStatus");
        Intrinsics.checkNotNullParameter((Object)collectionUuid, (String)"collectionUuid");
        Iterable $this$mapNotNull$iv = filterByStatus;
        boolean $i$f$mapNotNull22 = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PublishStatus publishStatus;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PublishStatus.Companion.forApiValue(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PublishStatus it$iv$iv = publishStatus;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filterStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        PublishStatus $i$f$mapNotNull22 = PublishStatus.Companion.forApiValue(newStatus);
        if ($i$f$mapNotNull22 == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
        }
        PublishStatus publishStatus = $i$f$mapNotNull22;
        object = collectionUuid;
        boolean bl = false;
        boolean bl6 = false;
        PublishTask task = new PublishTask(AppliesToType.Skill, search, filterStatuses, publishStatus, OAuthHelper.readableUsername$default(this.getOAuthHelper(), user, null, 2, null), StringsKt.isBlank((CharSequence)object) ? null : collectionUuid, null, null, null, null, 960, null);
        this.getTaskMessageService().enqueueJob("batch-publish-skills", task);
        return Task.Companion.processingResponse(task);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/api/skills/{uuid}/log"}, produces={"application/json"})
    @NotNull
    public HttpEntity<List<AuditLog>> skillAuditLog(@PathVariable @NotNull String uuid) {
        Collection<AuditLog> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        OffsetPageable pageable = new OffsetPageable(0, Integer.MAX_VALUE, ((AuditLogSortEnum)SortOrderCompanion.DefaultImpls.forValueOrDefault$default(AuditLogSortEnum.Companion, AuditLogSortEnum.DateDesc.getApiValue(), null, 2, null)).getSort());
        RichSkillDescriptorDao skill = this.getRichSkillRepository().findByUUID(uuid);
        AuditLogRepository auditLogRepository = this.getAuditLogRepository();
        String string = RichSkillDescriptorTable.INSTANCE.getTableName();
        Intrinsics.checkNotNull((Object)skill);
        SizedIterable<AuditLogDao> sizedIterable = auditLogRepository.findByTableAndId(string, ((Number)((Object)skill.getId().getValue())).longValue(), pageable);
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)sizedIterable));
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((int)200);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AuditLogDao auditLogDao = (AuditLogDao)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            AuditLog auditLog2 = it.toModel();
            collection.add(auditLog2);
        }
        collection = (List)destination$iv$iv;
        ResponseEntity responseEntity = bodyBuilder.body((Object)collection);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).body(sizedIterable.toList().map{it.toModel()})");
        return (HttpEntity)responseEntity;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/export/library"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> exportLibrary(@AuthenticationPrincipal @Nullable Jwt user) {
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        if (!this.getOAuthHelper().hasRole(this.getAppConfig().getRoleAdmin())) {
            throw new GeneralApiException("OSMT user must have an Admin role.", HttpStatus.UNAUTHORIZED);
        }
        CsvTask task = new CsvTask("FullLibrary", null, null, null, null, 30, null);
        this.getTaskMessageService().enqueueJob("full-library-skills-csv-process", task);
        return Task.Companion.processingResponse(task);
    }
}

