/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.elasticsearch;

import edu.wgu.osmt.elasticsearch.ElasticSearchReindexer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"reindex"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u00068\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Ledu/wgu/osmt/elasticsearch/ReindexCommand;", "Lorg/springframework/boot/CommandLineRunner;", "()V", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "elasticSearchReindexer", "Ledu/wgu/osmt/elasticsearch/ElasticSearchReindexer;", "getElasticSearchReindexer", "()Ledu/wgu/osmt/elasticsearch/ElasticSearchReindexer;", "setElasticSearchReindexer", "(Ledu/wgu/osmt/elasticsearch/ElasticSearchReindexer;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "run", "", "args", "", "", "([Ljava/lang/String;)V", "osmt-api"})
public class ReindexCommand
implements CommandLineRunner {
    @NotNull
    private final Logger logger;
    @Autowired
    public ElasticSearchReindexer elasticSearchReindexer;
    @Autowired
    private ApplicationContext applicationContext;

    public ReindexCommand() {
        Logger logger = LoggerFactory.getLogger(ReindexCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ReindexCommand::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public ElasticSearchReindexer getElasticSearchReindexer() {
        ElasticSearchReindexer elasticSearchReindexer = this.elasticSearchReindexer;
        if (elasticSearchReindexer != null) {
            return elasticSearchReindexer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"elasticSearchReindexer");
        throw null;
    }

    public void setElasticSearchReindexer(@NotNull ElasticSearchReindexer elasticSearchReindexer) {
        Intrinsics.checkNotNullParameter((Object)elasticSearchReindexer, (String)"<set-?>");
        this.elasticSearchReindexer = elasticSearchReindexer;
    }

    public void run(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.getElasticSearchReindexer().reindexAll();
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
            throw null;
        }
        ((ConfigurableApplicationContext)applicationContext).close();
    }
}

