/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.security;

import edu.wgu.osmt.db.PublishStatus;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000bH\u0016J\u001c\u0010\r\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0013"}, d2={"Ledu/wgu/osmt/security/OAuthHelper;", "", "()V", "hasPublishStatus", "", "status", "Ledu/wgu/osmt/db/PublishStatus;", "statuses", "", "hasRole", "role", "", "isArchiveRelated", "readableUsername", "user", "Lorg/springframework/security/oauth2/core/user/OAuth2User;", "default", "jwt", "Lorg/springframework/security/oauth2/jwt/Jwt;", "osmt-api"})
public class OAuthHelper {
    @NotNull
    public String readableUsername(@Nullable OAuth2User user, @NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"default");
        OAuth2User oAuth2User = user;
        return oAuth2User == null ? string : ((string2 = oAuth2User.getName()) == null ? string : string2);
    }

    public static /* synthetic */ String readableUsername$default(OAuthHelper oAuthHelper, OAuth2User oAuth2User, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readableUsername");
        }
        if ((n & 2) != 0) {
            string = "unauthenticated";
        }
        return oAuthHelper.readableUsername(oAuth2User, string);
    }

    @NotNull
    public String readableUsername(@Nullable Jwt jwt, @NotNull String string) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)string, (String)"default");
        Jwt jwt2 = jwt;
        String string2 = jwt2 == null ? null : ((map = jwt2.getClaims()) == null ? null : map.get("name"));
        return string2 == null ? string : string2;
    }

    public static /* synthetic */ String readableUsername$default(OAuthHelper oAuthHelper, Jwt jwt, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readableUsername");
        }
        if ((n & 2) != 0) {
            string = "unauthenticated";
        }
        return oAuthHelper.readableUsername(jwt, string);
    }

    public boolean hasRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        String roles = SecurityContextHolder.getContext().getAuthentication().getAuthorities().toString();
        return StringsKt.contains$default((CharSequence)roles, (CharSequence)role, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasPublishStatus(@Nullable PublishStatus status, @NotNull List<? extends PublishStatus> statuses) {
        boolean bl;
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        if (status == null) return true;
        Iterable $this$any$iv = statuses;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            PublishStatus it = (PublishStatus)element$iv;
            boolean bl2 = false;
            if (it == status) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public boolean isArchiveRelated(@Nullable PublishStatus status) {
        Object[] objectArray = new PublishStatus[]{PublishStatus.Archived, PublishStatus.Unarchived};
        return this.hasPublishStatus(status, CollectionsKt.listOf((Object[])objectArray));
    }
}

