/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.task;

import com.github.sonus21.rqueue.annotation.RqueueListener;
import edu.wgu.osmt.task.Task;
import edu.wgu.osmt.task.TaskMessageService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Profile(value={"apiserver"})
@Transactional
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\b8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Ledu/wgu/osmt/task/TaskQueueHandler;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "setTaskMessageService", "(Ledu/wgu/osmt/task/TaskMessageService;)V", "onMessage", "", "task", "Ledu/wgu/osmt/task/Task;", "osmt-api"})
public class TaskQueueHandler {
    @NotNull
    private final Logger logger;
    @Autowired
    public TaskMessageService taskMessageService;

    public TaskQueueHandler() {
        Logger logger = LoggerFactory.getLogger(TaskQueueHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(TaskQueueHandler::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        TaskMessageService taskMessageService = this.taskMessageService;
        if (taskMessageService != null) {
            return taskMessageService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"taskMessageService");
        throw null;
    }

    public void setTaskMessageService(@NotNull TaskMessageService taskMessageService) {
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"<set-?>");
        this.taskMessageService = taskMessageService;
    }

    @RqueueListener(value={"dead-letters"})
    public void onMessage(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getLogger().warn("Task " + task.getUuid() + " failed, removing from hash table");
        Object[] objectArray = new Object[]{task.getUuid()};
        this.getTaskMessageService().getOpsForHash().delete((Object)"tasks", objectArray);
    }
}

