/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.keyword;

import edu.wgu.osmt.elasticsearch.OffsetPageable;
import edu.wgu.osmt.keyword.CustomKeywordRepository;
import edu.wgu.osmt.keyword.Keyword;
import edu.wgu.osmt.keyword.KeywordTypeEnum;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ledu/wgu/osmt/keyword/CustomKeywordRepositoryImpl;", "Ledu/wgu/osmt/keyword/CustomKeywordRepository;", "elasticSearchTemplate", "Lorg/springframework/data/elasticsearch/core/ElasticsearchRestTemplate;", "(Lorg/springframework/data/elasticsearch/core/ElasticsearchRestTemplate;)V", "getElasticSearchTemplate", "()Lorg/springframework/data/elasticsearch/core/ElasticsearchRestTemplate;", "typeAheadSearch", "Lorg/springframework/data/elasticsearch/core/SearchHits;", "Ledu/wgu/osmt/keyword/Keyword;", "query", "", "type", "Ledu/wgu/osmt/keyword/KeywordTypeEnum;", "osmt-api"})
public final class CustomKeywordRepositoryImpl
implements CustomKeywordRepository {
    @NotNull
    private final ElasticsearchRestTemplate elasticSearchTemplate;

    @Autowired
    public CustomKeywordRepositoryImpl(@NotNull ElasticsearchRestTemplate elasticSearchTemplate) {
        Intrinsics.checkNotNullParameter((Object)elasticSearchTemplate, (String)"elasticSearchTemplate");
        this.elasticSearchTemplate = elasticSearchTemplate;
    }

    @Override
    @NotNull
    public ElasticsearchRestTemplate getElasticSearchTemplate() {
        return this.elasticSearchTemplate;
    }

    @Override
    @NotNull
    public SearchHits<Keyword> typeAheadSearch(@NotNull String query, @NotNull KeywordTypeEnum type) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        OffsetPageable limitedPageable = new OffsetPageable(0, 10, null);
        BoolQueryBuilder bq = QueryBuilders.boolQuery();
        NativeSearchQueryBuilder nativeSearchQueryBuilder = ((NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withPageable((Pageable)limitedPageable)).withQuery((QueryBuilder)bq).withSort((SortBuilder)SortBuilders.scoreSort());
        Intrinsics.checkNotNullExpressionValue((Object)nativeSearchQueryBuilder, (String)"NativeSearchQueryBuilder\u2026SortBuilders.scoreSort())");
        NativeSearchQueryBuilder nsq = nativeSearchQueryBuilder;
        bq.must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)type.name())).should((QueryBuilder)QueryBuilders.matchBoolPrefixQuery((String)"value", (Object)query)).should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"value", (Object)query).boost(5.0f)).minimumShouldMatch(1);
        SearchHits searchHits = this.getElasticSearchTemplate().search((Query)nsq.build(), Keyword.class);
        Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"elasticSearchTemplate.se\u2026d(), Keyword::class.java)");
        return searchHits;
    }

    @Override
    public void deleteIndex() {
        CustomKeywordRepository.DefaultImpls.deleteIndex(this);
    }
}

