/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.elasticsearch;

import edu.wgu.osmt.collection.CollectionEsRepo;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.elasticsearch.ProcessLogger;
import edu.wgu.osmt.jobcode.JobCodeEsRepo;
import edu.wgu.osmt.jobcode.JobCodeRepository;
import edu.wgu.osmt.keyword.KeywordEsRepo;
import edu.wgu.osmt.keyword.KeywordRepository;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import edu.wgu.osmt.richskill.RichSkillRepository;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020DH\u0016J\b\u0010F\u001a\u00020DH\u0012J\b\u0010G\u001a\u00020DH\u0012J\b\u0010H\u001a\u00020DH\u0012J\b\u0010I\u001a\u00020DH\u0012R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u001c8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u00020\"8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001e\u0010'\u001a\u00020(8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001e\u0010-\u001a\u00020.8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\u000204X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u001e\u00107\u001a\u0002088\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001e\u0010=\u001a\u00020>8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010B\u00a8\u0006J"}, d2={"Ledu/wgu/osmt/elasticsearch/ElasticSearchReindexer;", "", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "setAppConfig", "(Ledu/wgu/osmt/config/AppConfig;)V", "collectionEsRepo", "Ledu/wgu/osmt/collection/CollectionEsRepo;", "getCollectionEsRepo", "()Ledu/wgu/osmt/collection/CollectionEsRepo;", "setCollectionEsRepo", "(Ledu/wgu/osmt/collection/CollectionEsRepo;)V", "collectionRepository", "Ledu/wgu/osmt/collection/CollectionRepository;", "getCollectionRepository", "()Ledu/wgu/osmt/collection/CollectionRepository;", "setCollectionRepository", "(Ledu/wgu/osmt/collection/CollectionRepository;)V", "jobCodeEsRepo", "Ledu/wgu/osmt/jobcode/JobCodeEsRepo;", "getJobCodeEsRepo", "()Ledu/wgu/osmt/jobcode/JobCodeEsRepo;", "setJobCodeEsRepo", "(Ledu/wgu/osmt/jobcode/JobCodeEsRepo;)V", "jobCodeRepository", "Ledu/wgu/osmt/jobcode/JobCodeRepository;", "getJobCodeRepository", "()Ledu/wgu/osmt/jobcode/JobCodeRepository;", "setJobCodeRepository", "(Ledu/wgu/osmt/jobcode/JobCodeRepository;)V", "keywordEsRepo", "Ledu/wgu/osmt/keyword/KeywordEsRepo;", "getKeywordEsRepo", "()Ledu/wgu/osmt/keyword/KeywordEsRepo;", "setKeywordEsRepo", "(Ledu/wgu/osmt/keyword/KeywordEsRepo;)V", "keywordRepository", "Ledu/wgu/osmt/keyword/KeywordRepository;", "getKeywordRepository", "()Ledu/wgu/osmt/keyword/KeywordRepository;", "setKeywordRepository", "(Ledu/wgu/osmt/keyword/KeywordRepository;)V", "limit", "Ljava/lang/Integer;", "getLimit", "()Ljava/lang/Integer;", "setLimit", "(Ljava/lang/Integer;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "getRichSkillEsRepo", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "setRichSkillEsRepo", "(Ledu/wgu/osmt/richskill/RichSkillEsRepo;)V", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "setRichSkillRepository", "(Ledu/wgu/osmt/richskill/RichSkillRepository;)V", "deleteAllIndices", "", "reindexAll", "reindexCollections", "reindexJobCodes", "reindexKeywords", "reindexSkills", "osmt-api"})
public class ElasticSearchReindexer {
    @NotNull
    private final Logger logger;
    @Autowired
    public AppConfig appConfig;
    @Autowired
    public RichSkillEsRepo richSkillEsRepo;
    @Autowired
    public CollectionEsRepo collectionEsRepo;
    @Autowired
    public JobCodeEsRepo jobCodeEsRepo;
    @Autowired
    public KeywordEsRepo keywordEsRepo;
    @Autowired
    public RichSkillRepository richSkillRepository;
    @Autowired
    public CollectionRepository collectionRepository;
    @Autowired
    public KeywordRepository keywordRepository;
    @Autowired
    public JobCodeRepository jobCodeRepository;
    @Value(value="${edu.wgu.osmt.elasticsearch.Reindex.batch_size:1000}")
    public Integer limit;

    public ElasticSearchReindexer() {
        Logger logger = LoggerFactory.getLogger(ElasticSearchReindexer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ElasticSearchReindexer::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public AppConfig getAppConfig() {
        AppConfig appConfig = this.appConfig;
        if (appConfig != null) {
            return appConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appConfig");
        return null;
    }

    public void setAppConfig(@NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"<set-?>");
        this.appConfig = appConfig;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        RichSkillEsRepo richSkillEsRepo = this.richSkillEsRepo;
        if (richSkillEsRepo != null) {
            return richSkillEsRepo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"richSkillEsRepo");
        return null;
    }

    public void setRichSkillEsRepo(@NotNull RichSkillEsRepo richSkillEsRepo) {
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"<set-?>");
        this.richSkillEsRepo = richSkillEsRepo;
    }

    @NotNull
    public CollectionEsRepo getCollectionEsRepo() {
        CollectionEsRepo collectionEsRepo = this.collectionEsRepo;
        if (collectionEsRepo != null) {
            return collectionEsRepo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"collectionEsRepo");
        return null;
    }

    public void setCollectionEsRepo(@NotNull CollectionEsRepo collectionEsRepo) {
        Intrinsics.checkNotNullParameter((Object)collectionEsRepo, (String)"<set-?>");
        this.collectionEsRepo = collectionEsRepo;
    }

    @NotNull
    public JobCodeEsRepo getJobCodeEsRepo() {
        JobCodeEsRepo jobCodeEsRepo = this.jobCodeEsRepo;
        if (jobCodeEsRepo != null) {
            return jobCodeEsRepo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jobCodeEsRepo");
        return null;
    }

    public void setJobCodeEsRepo(@NotNull JobCodeEsRepo jobCodeEsRepo) {
        Intrinsics.checkNotNullParameter((Object)jobCodeEsRepo, (String)"<set-?>");
        this.jobCodeEsRepo = jobCodeEsRepo;
    }

    @NotNull
    public KeywordEsRepo getKeywordEsRepo() {
        KeywordEsRepo keywordEsRepo = this.keywordEsRepo;
        if (keywordEsRepo != null) {
            return keywordEsRepo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keywordEsRepo");
        return null;
    }

    public void setKeywordEsRepo(@NotNull KeywordEsRepo keywordEsRepo) {
        Intrinsics.checkNotNullParameter((Object)keywordEsRepo, (String)"<set-?>");
        this.keywordEsRepo = keywordEsRepo;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        RichSkillRepository richSkillRepository = this.richSkillRepository;
        if (richSkillRepository != null) {
            return richSkillRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"richSkillRepository");
        return null;
    }

    public void setRichSkillRepository(@NotNull RichSkillRepository richSkillRepository) {
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"<set-?>");
        this.richSkillRepository = richSkillRepository;
    }

    @NotNull
    public CollectionRepository getCollectionRepository() {
        CollectionRepository collectionRepository = this.collectionRepository;
        if (collectionRepository != null) {
            return collectionRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"collectionRepository");
        return null;
    }

    public void setCollectionRepository(@NotNull CollectionRepository collectionRepository) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"<set-?>");
        this.collectionRepository = collectionRepository;
    }

    @NotNull
    public KeywordRepository getKeywordRepository() {
        KeywordRepository keywordRepository = this.keywordRepository;
        if (keywordRepository != null) {
            return keywordRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keywordRepository");
        return null;
    }

    public void setKeywordRepository(@NotNull KeywordRepository keywordRepository) {
        Intrinsics.checkNotNullParameter((Object)keywordRepository, (String)"<set-?>");
        this.keywordRepository = keywordRepository;
    }

    @NotNull
    public JobCodeRepository getJobCodeRepository() {
        JobCodeRepository jobCodeRepository = this.jobCodeRepository;
        if (jobCodeRepository != null) {
            return jobCodeRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jobCodeRepository");
        return null;
    }

    public void setJobCodeRepository(@NotNull JobCodeRepository jobCodeRepository) {
        Intrinsics.checkNotNullParameter((Object)jobCodeRepository, (String)"<set-?>");
        this.jobCodeRepository = jobCodeRepository;
    }

    @NotNull
    public Integer getLimit() {
        Integer n = this.limit;
        if (n != null) {
            return n;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"limit");
        return null;
    }

    public void setLimit(@NotNull Integer n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"<set-?>");
        this.limit = n;
    }

    public void deleteAllIndices() {
        this.getRichSkillEsRepo().deleteIndex();
        this.getCollectionEsRepo().deleteIndex();
        this.getKeywordEsRepo().deleteIndex();
        this.getJobCodeEsRepo().deleteIndex();
    }

    public void reindexAll() {
        this.reindexSkills();
        this.reindexCollections();
        this.reindexKeywords();
        this.reindexJobCodes();
    }

    private void reindexSkills() {
        Ref.IntRef page = new Ref.IntRef();
        Ref.BooleanRef exit = new Ref.BooleanRef();
        ProcessLogger trace = new ProcessLogger("skills", this.getLogger());
        while (!exit.element) {
            ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        }
    }

    private void reindexCollections() {
        Ref.IntRef page = new Ref.IntRef();
        Ref.BooleanRef exit = new Ref.BooleanRef();
        Ref.ObjectRef trace = new Ref.ObjectRef();
        trace.element = new ProcessLogger("collections", this.getLogger());
        while (!exit.element) {
            ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        }
    }

    private void reindexKeywords() {
        Ref.IntRef page = new Ref.IntRef();
        Ref.BooleanRef exit = new Ref.BooleanRef();
        Ref.ObjectRef trace = new Ref.ObjectRef();
        trace.element = new ProcessLogger("keywords", this.getLogger());
        while (!exit.element) {
            ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        }
    }

    private void reindexJobCodes() {
        Ref.IntRef page = new Ref.IntRef();
        Ref.BooleanRef exit = new Ref.BooleanRef();
        Ref.ObjectRef trace = new Ref.ObjectRef();
        trace.element = new ProcessLogger("jobCodes", this.getLogger());
        while (!exit.element) {
            ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        }
    }
}

