/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.api;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import edu.wgu.osmt.api.FormValidationException;
import edu.wgu.osmt.api.model.ApiError;
import edu.wgu.osmt.api.model.ApiFieldError;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Order(value=1)
@ControllerAdvice
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0011H\u0017\u00a8\u0006\u0012"}, d2={"Ledu/wgu/osmt/api/ApiErrorHandler;", "Lorg/springframework/web/servlet/mvc/method/annotation/ResponseEntityExceptionHandler;", "()V", "handleFormValidationException", "Lorg/springframework/http/ResponseEntity;", "", "ex", "Ledu/wgu/osmt/api/FormValidationException;", "handleHttpMessageNotReadable", "Lorg/springframework/http/converter/HttpMessageNotReadableException;", "headers", "Lorg/springframework/http/HttpHeaders;", "status", "Lorg/springframework/http/HttpStatus;", "request", "Lorg/springframework/web/context/request/WebRequest;", "handleResponseStatus", "Lorg/springframework/web/server/ResponseStatusException;", "osmt-api"})
public class ApiErrorHandler
extends ResponseEntityExceptionHandler {
    @NotNull
    protected ResponseEntity<Object> handleHttpMessageNotReadable(@NotNull HttpMessageNotReadableException ex, @NotNull HttpHeaders headers, @NotNull HttpStatus status, @NotNull WebRequest request) {
        ApiError apiError;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (ex.getRootCause() instanceof MismatchedInputException) {
            Throwable throwable = ex.getRootCause();
            Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.exc.MismatchedInputException");
            MismatchedInputException mie = (MismatchedInputException)throwable;
            String string = mie.getMessage();
            Intrinsics.checkNotNull((Object)string);
            apiError = new ApiError("JSON Parse Error", CollectionsKt.listOf((Object)new ApiFieldError("body", string, null, 4, null)));
        } else {
            apiError = new ApiError("Bad Request", null, 2, null);
        }
        ApiError apiError2 = apiError;
        return new ResponseEntity((Object)apiError2, status);
    }

    @ExceptionHandler(value={FormValidationException.class})
    @NotNull
    public ResponseEntity<Object> handleFormValidationException(@NotNull FormValidationException ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        ApiError apiError = new ApiError(ex.getMessage(), ex.getErrors());
        return new ResponseEntity((Object)apiError, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    @NotNull
    public ResponseEntity<Object> handleResponseStatus(@NotNull ResponseStatusException ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        ApiError apiError = new ApiError(ex.getStatus().toString(), null, 2, null);
        return new ResponseEntity((Object)apiError, ex.getStatus());
    }
}

