/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.elasticsearch;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\u0001H\u0016J\b\u0010\n\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0001H\u0096\u0002J\u0006\u0010\u0013\u001a\u00020\u0001J\b\u0010\u0014\u001a\u00020\u0001H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ledu/wgu/osmt/elasticsearch/OffsetPageable;", "Lorg/springframework/data/domain/Pageable;", "offset", "", "limit", "sort", "Lorg/springframework/data/domain/Sort;", "(IILorg/springframework/data/domain/Sort;)V", "getLimit", "()I", "getOffset", "first", "", "getPageNumber", "getPageSize", "getSort", "hasPrevious", "", "next", "previous", "previousOrFirst", "withPage", "pageNumber", "osmt-api"})
public final class OffsetPageable
implements Pageable {
    @Nullable
    private final Sort sort;
    private final int offset;
    private final int limit;

    public OffsetPageable(int offset, int limit, @Nullable Sort sort) {
        this.sort = sort;
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must not be less than one!");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must not be less than zero!");
        }
        this.offset = offset;
        this.limit = limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLimit() {
        return this.limit;
    }

    public int getPageNumber() {
        return this.offset / this.limit;
    }

    public boolean hasPrevious() {
        return this.offset >= this.limit;
    }

    @NotNull
    public Sort getSort() {
        Sort sort = this.sort;
        if (sort == null) {
            Sort sort2 = Sort.unsorted();
            sort = sort2;
            Intrinsics.checkNotNullExpressionValue((Object)sort2, (String)"unsorted()");
        }
        return sort;
    }

    @NotNull
    public Pageable next() {
        return new OffsetPageable(this.getPageSize(), this.offset + this.getPageSize(), this.getSort());
    }

    @NotNull
    public final Pageable previous() {
        return this.hasPrevious() ? (Pageable)new OffsetPageable(this.getPageSize(), this.offset - this.getPageSize(), this.getSort()) : (Pageable)this;
    }

    public int getPageSize() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    @NotNull
    public Pageable first() {
        return new OffsetPageable(this.getPageSize(), 0, this.getSort());
    }

    @NotNull
    public Pageable withPage(int pageNumber) {
        return new OffsetPageable(this.getPageSize(), pageNumber * this.getPageSize(), this.getSort());
    }

    @NotNull
    public Pageable previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }
}

