/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.security;

import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.security.RedirectToFrontend;
import edu.wgu.osmt.security.ReturnUnauthorized;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@Profile(value={"oauth2-okta | OTHER-OAUTH-PROFILE"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Ledu/wgu/osmt/security/SecurityConfig;", "Lorg/springframework/security/config/annotation/web/configuration/WebSecurityConfigurerAdapter;", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "setAppConfig", "(Ledu/wgu/osmt/config/AppConfig;)V", "redirectToFrontend", "Ledu/wgu/osmt/security/RedirectToFrontend;", "getRedirectToFrontend", "()Ledu/wgu/osmt/security/RedirectToFrontend;", "setRedirectToFrontend", "(Ledu/wgu/osmt/security/RedirectToFrontend;)V", "returnUnauthorized", "Ledu/wgu/osmt/security/ReturnUnauthorized;", "getReturnUnauthorized", "()Ledu/wgu/osmt/security/ReturnUnauthorized;", "setReturnUnauthorized", "(Ledu/wgu/osmt/security/ReturnUnauthorized;)V", "configure", "", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "configureForNoRoles", "configureForRoles", "corsConfigurationSource", "Lorg/springframework/web/cors/CorsConfigurationSource;", "osmt-api"})
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    public AppConfig appConfig;
    @Autowired
    public RedirectToFrontend redirectToFrontend;
    @Autowired
    public ReturnUnauthorized returnUnauthorized;

    @NotNull
    public AppConfig getAppConfig() {
        AppConfig appConfig = this.appConfig;
        if (appConfig != null) {
            return appConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appConfig");
        return null;
    }

    public void setAppConfig(@NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"<set-?>");
        this.appConfig = appConfig;
    }

    @NotNull
    public RedirectToFrontend getRedirectToFrontend() {
        RedirectToFrontend redirectToFrontend = this.redirectToFrontend;
        if (redirectToFrontend != null) {
            return redirectToFrontend;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"redirectToFrontend");
        return null;
    }

    public void setRedirectToFrontend(@NotNull RedirectToFrontend redirectToFrontend) {
        Intrinsics.checkNotNullParameter((Object)redirectToFrontend, (String)"<set-?>");
        this.redirectToFrontend = redirectToFrontend;
    }

    @NotNull
    public ReturnUnauthorized getReturnUnauthorized() {
        ReturnUnauthorized returnUnauthorized = this.returnUnauthorized;
        if (returnUnauthorized != null) {
            return returnUnauthorized;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"returnUnauthorized");
        return null;
    }

    public void setReturnUnauthorized(@NotNull ReturnUnauthorized returnUnauthorized) {
        Intrinsics.checkNotNullParameter((Object)returnUnauthorized, (String)"<set-?>");
        this.returnUnauthorized = returnUnauthorized;
    }

    protected void configure(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        String[] stringArray = new String[]{"/api/skills/{uuid}/log"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).httpBasic().disable()).authorizeRequests().mvcMatchers(HttpMethod.GET, stringArray).authenticated();
        stringArray = new String[]{"/api/collections/{uuid}/log"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry2 = expressionInterceptUrlRegistry.mvcMatchers(HttpMethod.GET, stringArray).authenticated();
        stringArray = new String[]{"/api/results/skills/{uuid}"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry3 = expressionInterceptUrlRegistry2.mvcMatchers(HttpMethod.GET, stringArray).authenticated();
        stringArray = new String[]{"/api/results/batch/{uuid}"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry4 = expressionInterceptUrlRegistry3.mvcMatchers(HttpMethod.GET, stringArray).authenticated();
        stringArray = new String[]{"/api/search/jobcodes"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry5 = expressionInterceptUrlRegistry4.mvcMatchers(HttpMethod.GET, stringArray).authenticated();
        stringArray = new String[]{"/api/search/keywords"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry6 = expressionInterceptUrlRegistry5.mvcMatchers(HttpMethod.GET, stringArray).authenticated();
        stringArray = new String[]{"/api/search/skills"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry7 = expressionInterceptUrlRegistry6.mvcMatchers(HttpMethod.POST, stringArray).permitAll();
        stringArray = new String[]{"/api/search/collections"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry8 = expressionInterceptUrlRegistry7.mvcMatchers(HttpMethod.POST, stringArray).permitAll();
        stringArray = new String[]{"/api/skills/{uuid}"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry9 = expressionInterceptUrlRegistry8.mvcMatchers(HttpMethod.GET, stringArray).permitAll();
        stringArray = new String[]{"/api/collections/{uuid}"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry10 = expressionInterceptUrlRegistry9.mvcMatchers(HttpMethod.GET, stringArray).permitAll();
        stringArray = new String[]{"/api/collections/{uuid}/skills"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry11 = expressionInterceptUrlRegistry10.mvcMatchers(HttpMethod.POST, stringArray).permitAll();
        stringArray = new String[]{"/api/collections/{uuid}/csv"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry12 = expressionInterceptUrlRegistry11.mvcMatchers(HttpMethod.GET, stringArray).permitAll();
        stringArray = new String[]{"/api/results/text/{uuid}"};
        ((HttpSecurity)((OAuth2LoginConfigurer)((HttpSecurity)((HttpSecurity)expressionInterceptUrlRegistry12.mvcMatchers(HttpMethod.GET, stringArray).permitAll().and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.getReturnUnauthorized()).and()).oauth2Login().successHandler((AuthenticationSuccessHandler)this.getRedirectToFrontend())).and()).oauth2ResourceServer().jwt();
        if (this.getAppConfig().getEnableRoles()) {
            this.configureForRoles(http);
        } else {
            this.configureForNoRoles(http);
        }
    }

    public void configureForRoles(@NotNull HttpSecurity http) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        String ADMIN = this.getAppConfig().getRoleAdmin();
        String CURATOR = this.getAppConfig().getRoleCurator();
        String VIEW = this.getAppConfig().getRoleView();
        String READ = this.getAppConfig().getScopeRead();
        if (this.getAppConfig().getAllowPublicLists()) {
            stringArray = new String[]{"/api/skills"};
            ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = http.authorizeRequests().mvcMatchers(HttpMethod.GET, stringArray).permitAll();
            stringArray = new String[]{"/api/collections"};
            expressionInterceptUrlRegistry.mvcMatchers(HttpMethod.GET, stringArray).permitAll();
        } else {
            stringArray = new String[]{"/api/skills"};
            ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl = http.authorizeRequests().mvcMatchers(HttpMethod.GET, stringArray);
            stringArray = new String[]{ADMIN, CURATOR, VIEW, READ};
            ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = mvcMatchersAuthorizedUrl.hasAnyAuthority(stringArray);
            stringArray = new String[]{"/api/collections"};
            ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl2 = expressionInterceptUrlRegistry.mvcMatchers(HttpMethod.GET, stringArray);
            stringArray = new String[]{ADMIN, CURATOR, VIEW, READ};
            mvcMatchersAuthorizedUrl2.hasAnyAuthority(stringArray);
        }
        stringArray = new String[]{"/api/skills/{uuid}/update"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl = http.authorizeRequests().mvcMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{ADMIN, CURATOR};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = mvcMatchersAuthorizedUrl.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/skills"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl3 = expressionInterceptUrlRegistry.mvcMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{ADMIN, CURATOR};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry2 = mvcMatchersAuthorizedUrl3.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/skills/publish"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl4 = expressionInterceptUrlRegistry2.mvcMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{ADMIN};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry3 = mvcMatchersAuthorizedUrl4.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/collections"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl5 = expressionInterceptUrlRegistry3.mvcMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{ADMIN, CURATOR};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry4 = mvcMatchersAuthorizedUrl5.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/collections/publish"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl6 = expressionInterceptUrlRegistry4.mvcMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{ADMIN};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry5 = mvcMatchersAuthorizedUrl6.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/collections/{uuid}/update"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl7 = expressionInterceptUrlRegistry5.mvcMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{ADMIN, CURATOR};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry6 = mvcMatchersAuthorizedUrl7.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/collections/{uuid}/updateSkills"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl8 = expressionInterceptUrlRegistry6.mvcMatchers(HttpMethod.POST, stringArray);
        stringArray = new String[]{ADMIN};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry7 = mvcMatchersAuthorizedUrl8.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/collections/{uuid}/remove"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl9 = expressionInterceptUrlRegistry7.mvcMatchers(HttpMethod.DELETE, stringArray);
        stringArray = new String[]{ADMIN};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry8 = mvcMatchersAuthorizedUrl9.hasAnyAuthority(stringArray);
        stringArray = new String[]{"/api/**"};
        ExpressionUrlAuthorizationConfigurer.MvcMatchersAuthorizedUrl mvcMatchersAuthorizedUrl10 = expressionInterceptUrlRegistry8.mvcMatchers(stringArray);
        stringArray = new String[]{ADMIN, CURATOR, VIEW, READ};
        mvcMatchersAuthorizedUrl10.hasAnyAuthority(stringArray);
    }

    public void configureForNoRoles(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        String[] stringArray = new String[]{"/api/skills"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = http.authorizeRequests().mvcMatchers(HttpMethod.GET, stringArray).permitAll();
        stringArray = new String[]{"/api/collections"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry2 = expressionInterceptUrlRegistry.mvcMatchers(HttpMethod.GET, stringArray).permitAll();
        stringArray = new String[]{"/api/skills/{uuid}/update"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry3 = expressionInterceptUrlRegistry2.mvcMatchers(HttpMethod.POST, stringArray).authenticated();
        stringArray = new String[]{"/api/skills"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry4 = expressionInterceptUrlRegistry3.mvcMatchers(HttpMethod.POST, stringArray).authenticated();
        stringArray = new String[]{"/api/skills/publish"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry5 = expressionInterceptUrlRegistry4.mvcMatchers(HttpMethod.POST, stringArray).authenticated();
        stringArray = new String[]{"/api/collections"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry6 = expressionInterceptUrlRegistry5.mvcMatchers(HttpMethod.POST, stringArray).authenticated();
        stringArray = new String[]{"/api/collections/publish"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry7 = expressionInterceptUrlRegistry6.mvcMatchers(HttpMethod.POST, stringArray).authenticated();
        stringArray = new String[]{"/api/collections/{uuid}/update"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry8 = expressionInterceptUrlRegistry7.mvcMatchers(HttpMethod.POST, stringArray).authenticated();
        stringArray = new String[]{"/api/collections/{uuid}/updateSkills"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry9 = expressionInterceptUrlRegistry8.mvcMatchers(HttpMethod.POST, stringArray).authenticated();
        stringArray = new String[]{"/api/collections/{uuid}/remove"};
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry10 = expressionInterceptUrlRegistry9.mvcMatchers(HttpMethod.DELETE, stringArray).denyAll();
        stringArray = new String[]{"/api/**"};
        expressionInterceptUrlRegistry10.mvcMatchers(stringArray).permitAll();
    }

    @Bean
    @Nullable
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        Object[] objectArray = new String[]{","};
        configuration.setAllowedOrigins(StringsKt.split$default((CharSequence)this.getAppConfig().getCorsAllowedOrigins(), (String[])objectArray, (boolean)false, (int)0, (int)6, null));
        objectArray = new String[]{"HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"};
        configuration.setAllowedMethods(CollectionsKt.listOf((Object[])objectArray));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        objectArray = new String[]{"Authorization", "Cache-Control", "Content-Type"};
        configuration.setAllowedHeaders(CollectionsKt.listOf((Object[])objectArray));
        configuration.setExposedHeaders(CollectionsKt.listOf((Object)"X-Total-Count"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return (CorsConfigurationSource)source;
    }
}

