/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.elasticsearch;

import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.elasticsearch.ElasticSearchReindexer;
import edu.wgu.osmt.security.OAuthHelper;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@Controller
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0017J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Ledu/wgu/osmt/elasticsearch/ElasticSearchAdminController;", "", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "oAuthHelper", "Ledu/wgu/osmt/security/OAuthHelper;", "esReindexer", "Ledu/wgu/osmt/elasticsearch/ElasticSearchReindexer;", "(Ledu/wgu/osmt/config/AppConfig;Ledu/wgu/osmt/security/OAuthHelper;Ledu/wgu/osmt/elasticsearch/ElasticSearchReindexer;)V", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getEsReindexer", "()Ledu/wgu/osmt/elasticsearch/ElasticSearchReindexer;", "getOAuthHelper", "()Ledu/wgu/osmt/security/OAuthHelper;", "deleteElasticSearchIndices", "Lorg/springframework/http/ResponseEntity;", "", "reindexElasticSearch", "osmt-api"})
public class ElasticSearchAdminController {
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final OAuthHelper oAuthHelper;
    @NotNull
    private final ElasticSearchReindexer esReindexer;

    @Autowired
    public ElasticSearchAdminController(@NotNull AppConfig appConfig, @NotNull OAuthHelper oAuthHelper, @NotNull ElasticSearchReindexer esReindexer) {
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)oAuthHelper, (String)"oAuthHelper");
        Intrinsics.checkNotNullParameter((Object)esReindexer, (String)"esReindexer");
        this.appConfig = appConfig;
        this.oAuthHelper = oAuthHelper;
        this.esReindexer = esReindexer;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public OAuthHelper getOAuthHelper() {
        return this.oAuthHelper;
    }

    @NotNull
    public ElasticSearchReindexer getEsReindexer() {
        return this.esReindexer;
    }

    @RequestMapping(value={"/api/es-admin/delete-indices"})
    @PostMapping
    @NotNull
    public ResponseEntity<String> deleteElasticSearchIndices() {
        if (!this.getOAuthHelper().hasRole(this.getAppConfig().getRoleAdmin())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        ForkJoinPool.commonPool().submit(this.getEsReindexer()::deleteAllIndices);
        return new ResponseEntity((Object)"Deleting ElasticSearch indices in the background. Please refer to the logs.", HttpStatus.ACCEPTED);
    }

    @RequestMapping(value={"/api/es-admin/reindex"})
    @PostMapping
    @NotNull
    public ResponseEntity<String> reindexElasticSearch() {
        if (!this.getOAuthHelper().hasRole(this.getAppConfig().getRoleAdmin())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        ForkJoinPool.commonPool().submit(this.getEsReindexer()::reindexAll);
        return new ResponseEntity((Object)"Reindexing ElasticSearch in the background. Please refer to the logs.", HttpStatus.ACCEPTED);
    }
}

