/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.richskill;

import edu.wgu.osmt.api.FormValidationException;
import edu.wgu.osmt.api.model.ApiAlignment;
import edu.wgu.osmt.api.model.ApiAlignmentListUpdate;
import edu.wgu.osmt.api.model.ApiBatchResult;
import edu.wgu.osmt.api.model.ApiFieldError;
import edu.wgu.osmt.api.model.ApiNamedReference;
import edu.wgu.osmt.api.model.ApiReferenceListUpdate;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.api.model.ApiSkillUpdate;
import edu.wgu.osmt.api.model.ApiStringListUpdate;
import edu.wgu.osmt.auditlog.AuditLog;
import edu.wgu.osmt.auditlog.AuditLogRepository;
import edu.wgu.osmt.auditlog.AuditOperationType;
import edu.wgu.osmt.auditlog.Change;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.collection.CollectionEsRepo;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.ListFieldUpdate;
import edu.wgu.osmt.db.NullableFieldUpdate;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.db.PublishStatusDetails;
import edu.wgu.osmt.jobcode.JobCodeRepository;
import edu.wgu.osmt.jobcode.JobCodeTable;
import edu.wgu.osmt.keyword.KeywordDao;
import edu.wgu.osmt.keyword.KeywordRepository;
import edu.wgu.osmt.keyword.KeywordTypeEnum;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillDescriptorKt;
import edu.wgu.osmt.richskill.RichSkillDescriptorTable;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import edu.wgu.osmt.richskill.RichSkillJobCodes;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.richskill.RsdUpdateObject;
import edu.wgu.osmt.task.PublishTask;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.util.Streamable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H\u0016J\u001a\u00104\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000203H\u0016J$\u00108\u001a\b\u0012\u0004\u0012\u000201092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;092\u0006\u00107\u001a\u000203H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0012\u0010=\u001a\u0004\u0018\u0001012\u0006\u0010>\u001a\u00020?H\u0016J\u0012\u0010@\u001a\u0004\u0018\u0001012\u0006\u0010A\u001a\u000203H\u0016J\u001e\u0010B\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001092\f\u0010C\u001a\b\u0012\u0004\u0012\u00020309H\u0016J\u0018\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020;2\u0006\u00107\u001a\u000203H\u0016J\u001a\u0010F\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000203H\u0016J\"\u0010G\u001a\u0004\u0018\u0001012\u0006\u0010H\u001a\u00020?2\u0006\u0010E\u001a\u00020;2\u0006\u00107\u001a\u000203H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u001a8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020 8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006I"}, d2={"Ledu/wgu/osmt/richskill/RichSkillRepositoryImpl;", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "auditLogRepository", "Ledu/wgu/osmt/auditlog/AuditLogRepository;", "collectionRepository", "Ledu/wgu/osmt/collection/CollectionRepository;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "collectionEsRepo", "Ledu/wgu/osmt/collection/CollectionEsRepo;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/auditlog/AuditLogRepository;Ledu/wgu/osmt/collection/CollectionRepository;Ledu/wgu/osmt/richskill/RichSkillEsRepo;Ledu/wgu/osmt/collection/CollectionEsRepo;Ledu/wgu/osmt/config/AppConfig;)V", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getAuditLogRepository", "()Ledu/wgu/osmt/auditlog/AuditLogRepository;", "getCollectionEsRepo", "()Ledu/wgu/osmt/collection/CollectionEsRepo;", "getCollectionRepository", "()Ledu/wgu/osmt/collection/CollectionRepository;", "dao", "Ledu/wgu/osmt/richskill/RichSkillDescriptorDao$Companion;", "getDao", "()Ledu/wgu/osmt/richskill/RichSkillDescriptorDao$Companion;", "jobCodeRepository", "Ledu/wgu/osmt/jobcode/JobCodeRepository;", "getJobCodeRepository", "()Ledu/wgu/osmt/jobcode/JobCodeRepository;", "setJobCodeRepository", "(Ledu/wgu/osmt/jobcode/JobCodeRepository;)V", "keywordRepository", "Ledu/wgu/osmt/keyword/KeywordRepository;", "getKeywordRepository", "()Ledu/wgu/osmt/keyword/KeywordRepository;", "setKeywordRepository", "(Ledu/wgu/osmt/keyword/KeywordRepository;)V", "getRichSkillEsRepo", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "table", "Ledu/wgu/osmt/richskill/RichSkillDescriptorTable;", "getTable", "()Ledu/wgu/osmt/richskill/RichSkillDescriptorTable;", "changeStatusesForTask", "Ledu/wgu/osmt/api/model/ApiBatchResult;", "publishTask", "Ledu/wgu/osmt/task/PublishTask;", "containingJobCode", "Lorg/jetbrains/exposed/sql/SizedIterable;", "Ledu/wgu/osmt/richskill/RichSkillDescriptorDao;", "jobCode", "", "create", "updateObject", "Ledu/wgu/osmt/richskill/RsdUpdateObject;", "user", "createFromApi", "", "skillUpdates", "Ledu/wgu/osmt/api/model/ApiSkillUpdate;", "findAll", "findById", "id", "", "findByUUID", "uuid", "findManyByUUIDs", "uuids", "rsdUpdateFromApi", "skillUpdate", "update", "updateFromApi", "existingSkillId", "osmt-api"})
public class RichSkillRepositoryImpl
implements RichSkillRepository {
    @NotNull
    private final AuditLogRepository auditLogRepository;
    @NotNull
    private final CollectionRepository collectionRepository;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final CollectionEsRepo collectionEsRepo;
    @NotNull
    private final AppConfig appConfig;
    @Autowired
    @Lazy
    public JobCodeRepository jobCodeRepository;
    @Autowired
    @Lazy
    public KeywordRepository keywordRepository;
    @NotNull
    private final RichSkillDescriptorDao.Companion dao;
    @NotNull
    private final RichSkillDescriptorTable table;

    @Autowired
    public RichSkillRepositoryImpl(@NotNull AuditLogRepository auditLogRepository, @NotNull CollectionRepository collectionRepository, @NotNull RichSkillEsRepo richSkillEsRepo, @NotNull CollectionEsRepo collectionEsRepo, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)auditLogRepository, (String)"auditLogRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        Intrinsics.checkNotNullParameter((Object)collectionEsRepo, (String)"collectionEsRepo");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.auditLogRepository = auditLogRepository;
        this.collectionRepository = collectionRepository;
        this.richSkillEsRepo = richSkillEsRepo;
        this.collectionEsRepo = collectionEsRepo;
        this.appConfig = appConfig;
        this.dao = RichSkillDescriptorDao.Companion;
        this.table = RichSkillDescriptorTable.INSTANCE;
    }

    @NotNull
    public AuditLogRepository getAuditLogRepository() {
        return this.auditLogRepository;
    }

    @NotNull
    public CollectionRepository getCollectionRepository() {
        return this.collectionRepository;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public CollectionEsRepo getCollectionEsRepo() {
        return this.collectionEsRepo;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public JobCodeRepository getJobCodeRepository() {
        JobCodeRepository jobCodeRepository = this.jobCodeRepository;
        if (jobCodeRepository != null) {
            return jobCodeRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jobCodeRepository");
        return null;
    }

    public void setJobCodeRepository(@NotNull JobCodeRepository jobCodeRepository) {
        Intrinsics.checkNotNullParameter((Object)jobCodeRepository, (String)"<set-?>");
        this.jobCodeRepository = jobCodeRepository;
    }

    @NotNull
    public KeywordRepository getKeywordRepository() {
        KeywordRepository keywordRepository = this.keywordRepository;
        if (keywordRepository != null) {
            return keywordRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keywordRepository");
        return null;
    }

    public void setKeywordRepository(@NotNull KeywordRepository keywordRepository) {
        Intrinsics.checkNotNullParameter((Object)keywordRepository, (String)"<set-?>");
        this.keywordRepository = keywordRepository;
    }

    @Override
    @NotNull
    public RichSkillDescriptorDao.Companion getDao() {
        return this.dao;
    }

    @Override
    @NotNull
    public RichSkillDescriptorTable getTable() {
        return this.table;
    }

    @Override
    @NotNull
    public SizedIterable<RichSkillDescriptorDao> findAll() {
        return this.getDao().all();
    }

    @Override
    @Nullable
    public RichSkillDescriptorDao findById(long id) {
        return (RichSkillDescriptorDao)this.getDao().findById(Long.valueOf(id));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao update(@NotNull RsdUpdateObject updateObject, @NotNull String user) {
        RichSkillDescriptorDao daoObject;
        block10: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            List otherChanges;
            Pair pair;
            Object element$iv2;
            Iterable first$iv;
            List<Change> list2;
            PublishStatusDetails it2;
            Intrinsics.checkNotNullParameter((Object)updateObject, (String)"updateObject");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            RichSkillDescriptorDao.Companion companion = this.getDao();
            Long l = updateObject.getId();
            Intrinsics.checkNotNull((Object)l);
            RichSkillDescriptorDao richSkillDescriptorDao = daoObject = (RichSkillDescriptorDao)companion.findById(l);
            RichSkillDescriptor old = richSkillDescriptorDao != null ? richSkillDescriptorDao.toModel() : null;
            RichSkillDescriptorDao richSkillDescriptorDao2 = daoObject;
            if (richSkillDescriptorDao2 != null) {
                it2 = richSkillDescriptorDao2;
                boolean list2 = false;
                updateObject.applyToDao((RichSkillDescriptorDao)it2);
            }
            if (daoObject != null && (it2 = daoObject.toModel()) != null && (list2 = RichSkillDescriptorKt.diff((RichSkillDescriptor)it2, old)) != null) {
                void $this$partition$iv;
                Iterable iterable = list2;
                boolean $i$f$partition = false;
                first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv2 : $this$partition$iv) {
                    Change it3 = (Change)element$iv2;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it3.getFieldName(), (Object)"publishStatus")) {
                        ((ArrayList)first$iv).add(element$iv2);
                        continue;
                    }
                    second$iv.add(element$iv2);
                }
                pair = new Pair(first$iv, second$iv);
            } else {
                pair = TuplesKt.to(null, null);
            }
            Pair pair2 = pair;
            List publishStatusChanges = (List)pair2.component1();
            List list3 = otherChanges = (List)pair2.component2();
            if (list3 != null) {
                it = list3;
                boolean bl = false;
                if (!((Collection)it).isEmpty()) {
                    this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), (long)updateObject.getId(), (List<Change>)it, user, AuditOperationType.Update));
                }
            }
            List list4 = publishStatusChanges;
            if (list4 != null) {
                it = list4;
                boolean bl = false;
                if (!((Collection)it).isEmpty()) {
                    this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), (long)updateObject.getId(), (List<Change>)it, user, AuditOperationType.PublishStatusChange));
                }
            }
            RichSkillDescriptorDao richSkillDescriptorDao3 = daoObject;
            if (richSkillDescriptorDao3 == null) break block10;
            it = richSkillDescriptorDao3;
            boolean bl = false;
            first$iv = (Iterable)((RichSkillDescriptorDao)it).getCollections();
            CollectionEsRepo collectionEsRepo = this.getCollectionEsRepo();
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                CollectionDao collectionDao = (CollectionDao)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(CollectionDao.toDoc$default((CollectionDao)it4, false, 1, null));
            }
            collectionEsRepo.saveAll((List)destination$iv$iv);
            RichSkillDoc cfr_ignored_0 = (RichSkillDoc)this.getRichSkillEsRepo().save(RichSkillDoc.Companion.fromDao((RichSkillDescriptorDao)it, this.getAppConfig()));
        }
        return daoObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao findByUUID(@NotNull String uuid) {
        RichSkillDescriptorDao richSkillDescriptorDao;
        void $this$findByUUID_u24lambda_u246;
        ResultRow query;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        ResultRow resultRow = query = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.select((FieldSet)fieldSet, (Op)$this$findByUUID_u24lambda_u246.eq((ExpressionWithColumnType)this.getTable().getUuid(), (Object)uuid))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl2 = false;
            richSkillDescriptorDao = (RichSkillDescriptorDao)this.getDao().wrapRow(it);
        } else {
            richSkillDescriptorDao = null;
        }
        return richSkillDescriptorDao;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<RichSkillDescriptorDao> findManyByUUIDs(@NotNull List<String> uuids) {
        void $this$mapTo$iv$iv;
        Iterable $this$findManyByUUIDs_u24lambda_u248;
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        Object object = $this$select$iv;
        boolean bl = false;
        Query query = QueriesKt.select((FieldSet)object, (Op)((Op)$this$findManyByUUIDs_u24lambda_u248.inList((ExpressionWithColumnType)this.getTable().getUuid(), uuids)));
        Iterable $this$map$iv = (Iterable)query;
        boolean $i$f$map = false;
        $this$findManyByUUIDs_u24lambda_u248 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultRow resultRow = (ResultRow)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add((RichSkillDescriptorDao)this.getDao().wrapRow((ResultRow)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao create(@NotNull RsdUpdateObject updateObject, @NotNull String user) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)updateObject, (String)"updateObject");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        CharSequence charSequence = updateObject.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)updateObject.getStatement()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        RichSkillDescriptorDao newRsd2 = (RichSkillDescriptorDao)this.getDao().new((Function1)new Function1<RichSkillDescriptorDao, Unit>(updateObject){
            final /* synthetic */ RsdUpdateObject $updateObject;
            {
                this.$updateObject = $updateObject;
                super(1);
            }

            public final void invoke(@NotNull RichSkillDescriptorDao $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setName(this.$updateObject.getName());
                $this$new.setStatement(this.$updateObject.getStatement());
                LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(ZoneOffset.UTC)");
                $this$new.setUpdateDate(localDateTime);
                LocalDateTime localDateTime2 = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"now(ZoneOffset.UTC)");
                $this$new.setCreationDate(localDateTime2);
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
                $this$new.setUuid(string);
                NullableFieldUpdate<KeywordDao> nullableFieldUpdate = this.$updateObject.getAuthor();
                $this$new.setAuthor(nullableFieldUpdate != null ? nullableFieldUpdate.getT() : null);
                NullableFieldUpdate<KeywordDao> nullableFieldUpdate2 = this.$updateObject.getCategory();
                $this$new.setCategory(nullableFieldUpdate2 != null ? nullableFieldUpdate2.getT() : null);
            }
        });
        RsdUpdateObject.copy$default(updateObject, (Long)newRsd2.getId().getValue(), null, null, null, null, null, null, null, null, 510, null).applyToDao(newRsd2);
        RichSkillDescriptorDao it = newRsd2;
        boolean bl = false;
        Iterable iterable = (Iterable)it.getCollections();
        CollectionEsRepo collectionEsRepo = this.getCollectionEsRepo();
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            CollectionDao collectionDao = (CollectionDao)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(CollectionDao.toDoc$default((CollectionDao)it2, false, 1, null));
        }
        collectionEsRepo.saveAll((List)destination$iv$iv);
        RichSkillDoc cfr_ignored_0 = (RichSkillDoc)this.getRichSkillEsRepo().save(RichSkillDoc.Companion.fromDao(it, this.getAppConfig()));
        this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), ((Number)((Object)newRsd2.getId().getValue())).longValue(), RichSkillDescriptorKt.diff(newRsd2.toModel(), null), user, AuditOperationType.Insert));
        return newRsd2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RichSkillDescriptorDao> createFromApi(@NotNull List<ApiSkillUpdate> skillUpdates, @NotNull String user) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(skillUpdates, (String)"skillUpdates");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Iterable $this$mapIndexed$iv = skillUpdates;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void updateDto;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ApiSkillUpdate apiSkillUpdate = (ApiSkillUpdate)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(updateDto.validateForCreation((int)i));
        }
        List allErrors = CollectionsKt.flatten((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        if (!((Collection)allErrors).isEmpty()) {
            throw new FormValidationException("Invalid SkillUpdateDescriptor", allErrors);
        }
        Iterable $this$map$iv = skillUpdates;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void update;
            ApiSkillUpdate apiSkillUpdate = (ApiSkillUpdate)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            RsdUpdateObject rsdUpdateObject = this.rsdUpdateFromApi((ApiSkillUpdate)update, user);
            collection.add(this.create(rsdUpdateObject, user));
        }
        List newSkills = (List)destination$iv$iv2;
        return CollectionsKt.filterNotNull((Iterable)newSkills);
    }

    @Override
    @Nullable
    public RichSkillDescriptorDao updateFromApi(long existingSkillId, @NotNull ApiSkillUpdate skillUpdate, @NotNull String user) {
        List<ApiFieldError> errors;
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        List<ApiFieldError> list = errors = skillUpdate.validate(0);
        boolean bl = list != null ? !((Collection)list).isEmpty() : false;
        if (bl) {
            throw new FormValidationException("Invalid SkillUpdateDescriptor", errors);
        }
        RsdUpdateObject rsdUpdateObject = this.rsdUpdateFromApi(skillUpdate, user);
        RsdUpdateObject updateObjectWithId = RsdUpdateObject.copy$default(rsdUpdateObject, existingSkillId, null, null, null, null, null, null, null, null, 510, null);
        return this.update(updateObjectWithId, user);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public RsdUpdateObject rsdUpdateFromApi(@NotNull ApiSkillUpdate skillUpdate, @NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        v0 = skillUpdate.getAuthor();
        if (v0 != null) {
            it = v0;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$authorKeyword$1 = false;
            v1 = KeywordRepository.DefaultImpls.findOrCreate$default(this.getKeywordRepository(), KeywordTypeEnum.Author, it, null, null, 12, null);
        } else {
            v1 = null;
        }
        authorKeyword = v1;
        v2 = skillUpdate.getCategory();
        if (v2 != null) {
            it = v2;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$categoryKeyword$1 = false;
            v3 = KeywordRepository.DefaultImpls.findOrCreate$default(this.getKeywordRepository(), KeywordTypeEnum.Category, it, null, null, 12, null);
        } else {
            v3 = null;
        }
        categoryKeyword = v3;
        addingCollections = new ArrayList<E>();
        removingCollections = new ArrayList<E>();
        addingKeywords = new ArrayList<E>();
        removingKeywords = new ArrayList<E>();
        jobsToAdd = new ArrayList<E>();
        jobsToRemove = new ArrayList<E>();
        v4 = skillUpdate.getCollections();
        if (v4 != null) {
            slu = v4;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$1 = false;
            v5 = slu.getAdd();
            if (v5 != null) {
                $this$mapNotNull$iv = v5;
                $i$f$mapNotNull = false;
                var18_23 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var23_52 = $this$forEach$iv$iv$iv.iterator();
                while (var23_52.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var23_52.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (String)element$iv$iv;
                    $i$a$-mapNotNull-RichSkillRepositoryImpl$rsdUpdateFromApi$1$1 = false;
                    v6 = this.getCollectionRepository().findByName(it);
                    if (v6 == null) {
                        v6 = this.getCollectionRepository().create(it, user);
                    }
                    if (v6 == null) continue;
                    it$iv$iv = v6;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add((CollectionDao)it$iv$iv);
                }
                it = (List)destination$iv$iv;
                $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$1$2 = false;
                addingCollections.addAll(it);
            }
            v7 = slu.getRemove();
            if (v7 != null) {
                $this$mapNotNull$iv = v7;
                $i$f$mapNotNull = false;
                $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$1$2 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var23_52 = $this$forEach$iv$iv$iv.iterator();
                while (var23_52.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var23_52.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (String)element$iv$iv;
                    $i$a$-mapNotNull-RichSkillRepositoryImpl$rsdUpdateFromApi$1$3 = false;
                    v8 = this.getCollectionRepository().findByName(it);
                    if (v8 == null) {
                        v8 = this.getCollectionRepository().create(it, user);
                    }
                    if (v8 == null) continue;
                    it$iv$iv = v8;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add((CollectionDao)it$iv$iv);
                }
                it = (List)destination$iv$iv;
                $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$1$4 = false;
                removingCollections.addAll(it);
            }
        }
        v9 = skillUpdate.getOccupations();
        if (v9 != null) {
            it = v9;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$2 = false;
            v10 = it.getAdd();
            if (v10 != null) {
                $this$filter$iv = v10;
                $i$f$filter = false;
                $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$1$4 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-filter-RichSkillRepositoryImpl$rsdUpdateFromApi$2$1 = false;
                    v11 = !StringsKt.isBlank((CharSequence)it);
                    if (!v11) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    $i$a$-filter-RichSkillRepositoryImpl$rsdUpdateFromApi$2$1 = (String)item$iv$iv;
                    var26_60 = destination$iv$iv;
                    $i$a$-map-RichSkillRepositoryImpl$rsdUpdateFromApi$2$2 = false;
                    var26_60.add(JobCodeRepository.DefaultImpls.findByCodeOrCreate$default(this.getJobCodeRepository(), (String)it, null, 2, null));
                }
                it = (List)destination$iv$iv;
                $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$2$3 = false;
                jobsToAdd.addAll(it);
            }
            v12 = it.getRemove();
            if (v12 != null) {
                $this$filter$iv = v12;
                $i$f$filter = false;
                it = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-filter-RichSkillRepositoryImpl$rsdUpdateFromApi$2$4 = false;
                    v13 = !StringsKt.isBlank((CharSequence)it);
                    if (!v13) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    $i$a$-filter-RichSkillRepositoryImpl$rsdUpdateFromApi$2$4 = (String)item$iv$iv;
                    var26_61 = destination$iv$iv;
                    $i$a$-map-RichSkillRepositoryImpl$rsdUpdateFromApi$2$5 = false;
                    var26_61.add(this.getJobCodeRepository().findByCode((String)it));
                }
                it = (List)destination$iv$iv;
                $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$2$6 = false;
                jobsToRemove.addAll(CollectionsKt.filterNotNull((Iterable)it));
            }
        }
        v14 = skillUpdate.getKeywords();
        if (v14 != null) {
            it = v14;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$3 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupKeywords(this, addingKeywords, removingKeywords, (ApiStringListUpdate)it, KeywordTypeEnum.Keyword);
        }
        v15 = skillUpdate.getCertifications();
        if (v15 != null) {
            it = v15;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$4 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupReferences(this, addingKeywords, removingKeywords, (ApiReferenceListUpdate)it, KeywordTypeEnum.Certification);
        }
        v16 = skillUpdate.getStandards();
        if (v16 != null) {
            it = v16;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$5 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupAlignments(this, addingKeywords, removingKeywords, (ApiAlignmentListUpdate)it, KeywordTypeEnum.Standard);
        }
        v17 = skillUpdate.getAlignments();
        if (v17 != null) {
            it = v17;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$6 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupAlignments(this, addingKeywords, removingKeywords, (ApiAlignmentListUpdate)it, KeywordTypeEnum.Alignment);
        }
        v18 = skillUpdate.getEmployers();
        if (v18 != null) {
            it = v18;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$7 = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupReferences(this, addingKeywords, removingKeywords, (ApiReferenceListUpdate)it, KeywordTypeEnum.Employer);
        }
        v19 = addingKeywords.size() > 0 || removingKeywords.size() > 0 ? new ListFieldUpdate<T>(addingKeywords.size() > 0 ? addingKeywords : CollectionsKt.emptyList(), removingKeywords.size() > 0 ? removingKeywords : CollectionsKt.emptyList()) : (allKeywordsUpdate = null);
        jobCodesUpdate = jobsToAdd.size() > 0 || jobsToRemove.size() > 0 ? new ListFieldUpdate<T>(jobsToAdd.size() > 0 ? jobsToAdd : CollectionsKt.emptyList(), jobsToRemove.size() > 0 ? jobsToRemove : CollectionsKt.emptyList()) : null;
        var13_14 = skillUpdate.getSkillName();
        var14_16 = skillUpdate.getSkillStatement();
        var15_70 = skillUpdate.getPublishStatus();
        v20 = authorKeyword;
        if (v20 != null) {
            it = v20;
            $i$a$-let-RichSkillRepositoryImpl$rsdUpdateFromApi$8 = false;
            v21 = new NullableFieldUpdate<KeywordDao>(it);
        } else {
            v21 = var16_17 = null;
        }
        if (skillUpdate.getCategory() != null) ** GOTO lbl-1000
        v22 = skillUpdate.getCategory();
        v23 = v22 != null ? StringsKt.isBlank((CharSequence)v22) : false;
        if (v23) lbl-1000:
        // 2 sources

        {
            v24 = new NullableFieldUpdate<KeywordDao>(categoryKeyword);
        } else {
            v24 = null;
        }
        var17_19 = v24;
        var18_33 = addingCollections.size() + removingCollections.size() > 0 ? new ListFieldUpdate<T>(addingCollections, removingCollections) : null;
        return new RsdUpdateObject(null, var13_14, var14_16, var16_17, var17_19, allKeywordsUpdate, jobCodesUpdate, var18_33, var15_70, 1, null);
    }

    @Override
    @NotNull
    public ApiBatchResult changeStatusesForTask(@NotNull PublishTask publishTask) {
        Intrinsics.checkNotNullParameter((Object)publishTask, (String)"publishTask");
        Ref.IntRef modifiedCount = new Ref.IntRef();
        int totalCount = 0;
        Function2 publishSkill2 = (Function2)new Function2<RichSkillDescriptorDao, PublishTask, Boolean>(this){
            final /* synthetic */ RichSkillRepositoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull RichSkillDescriptorDao skillDao, @NotNull PublishTask task) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)skillDao, (String)"skillDao");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                PublishStatus oldStatus = skillDao.publishStatus();
                if (oldStatus != task.getPublishStatus()) {
                    PublishStatus newStatus;
                    RichSkillDescriptorDao updatedDao;
                    RsdUpdateObject updateObj = new RsdUpdateObject((Long)skillDao.getId().getValue(), null, null, null, null, null, null, null, task.getPublishStatus(), 254, null);
                    RichSkillDescriptorDao richSkillDescriptorDao = updatedDao = this.this$0.update(updateObj, task.getUserString());
                    PublishStatus publishStatus = newStatus = richSkillDescriptorDao != null ? richSkillDescriptorDao.publishStatus() : null;
                    bl = newStatus != oldStatus;
                } else {
                    bl = false;
                }
                return bl;
            }
        };
        Function1 handleSkillDao2 = (Function1)new Function1<RichSkillDescriptorDao, Unit>((Function2<? super RichSkillDescriptorDao, ? super PublishTask, Boolean>)publishSkill2, publishTask, modifiedCount){
            final /* synthetic */ Function2<RichSkillDescriptorDao, PublishTask, Boolean> $publishSkill;
            final /* synthetic */ PublishTask $publishTask;
            final /* synthetic */ Ref.IntRef $modifiedCount;
            {
                this.$publishSkill = $publishSkill;
                this.$publishTask = $publishTask;
                this.$modifiedCount = $modifiedCount;
                super(1);
            }

            @Nullable
            public final Unit invoke(@Nullable RichSkillDescriptorDao skillDao) {
                Unit unit;
                RichSkillDescriptorDao richSkillDescriptorDao = skillDao;
                if (richSkillDescriptorDao != null) {
                    RichSkillDescriptorDao richSkillDescriptorDao2 = richSkillDescriptorDao;
                    Function2<RichSkillDescriptorDao, PublishTask, Boolean> function2 = this.$publishSkill;
                    PublishTask publishTask = this.$publishTask;
                    Ref.IntRef intRef = this.$modifiedCount;
                    RichSkillDescriptorDao it = richSkillDescriptorDao2;
                    boolean bl = false;
                    if (((Boolean)function2.invoke((Object)it, (Object)publishTask)).booleanValue()) {
                        ++intRef.element;
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        };
        Collection collection = publishTask.getSearch().getUuids();
        if (!(collection == null || collection.isEmpty())) {
            totalCount = publishTask.getSearch().getUuids().size();
            Iterable $this$forEach$iv = publishTask.getSearch().getUuids();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String uuid = (String)element$iv;
                boolean bl = false;
                handleSkillDao2.invoke((Object)this.findByUUID(uuid));
            }
        } else {
            RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
            ApiSearch apiSearch = publishTask.getSearch();
            Set<PublishStatus> set = publishTask.getFilterByStatus();
            Pageable pageable = Pageable.unpaged();
            Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged()");
            SearchHits searchHits = richSkillEsRepo.byApiSearch(apiSearch, set, pageable, publishTask.getCollectionUuid());
            totalCount = (int)searchHits.getTotalHits();
            Iterable $this$forEach$iv = (Iterable)searchHits;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SearchHit hit = (SearchHit)element$iv;
                boolean bl = false;
                handleSkillDao2.invoke((Object)this.findById(((RichSkillDoc)hit.getContent()).getId()));
            }
        }
        return new ApiBatchResult(true, null, modifiedCount.element, totalCount, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SizedIterable<RichSkillDescriptorDao> containingJobCode(@NotNull String jobCode) {
        void $this$containingJobCode_u24lambda_u2448;
        Intrinsics.checkNotNullParameter((Object)jobCode, (String)"jobCode");
        FieldSet $this$select$iv = RichSkillDescriptorTable.INSTANCE.innerJoin((ColumnSet)RichSkillJobCodes.INSTANCE).innerJoin((ColumnSet)JobCodeTable.INSTANCE).slice(RichSkillDescriptorTable.INSTANCE.getColumns());
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        Query query = QueriesKt.select((FieldSet)fieldSet, (Op)$this$containingJobCode_u24lambda_u2448.eq((ExpressionWithColumnType)JobCodeTable.INSTANCE.getCode(), (Object)jobCode));
        return RichSkillDescriptorDao.Companion.wrapRows((SizedIterable)query);
    }

    @Override
    @NotNull
    public Query publishStatusSetToQuery(@NotNull Set<? extends PublishStatus> publishStatusSet) {
        return RichSkillRepository.DefaultImpls.publishStatusSetToQuery(this, publishStatusSet);
    }

    @Override
    @NotNull
    public Streamable<Pair<Column<?>, SortOrder>> sortToQueryOrder(@NotNull Sort sort, @NotNull Query query) {
        return RichSkillRepository.DefaultImpls.sortToQueryOrder(this, sort, query);
    }

    /*
     * WARNING - void declaration
     */
    private static final void rsdUpdateFromApi$lookupReferences(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiReferenceListUpdate lud, KeywordTypeEnum keywordType) {
        block4: {
            Iterable it;
            ApiNamedReference it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            boolean $i$f$map;
            Iterable $this$map$iv;
            List list = lud.getAdd();
            if (list != null) {
                $this$map$iv = list;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ApiNamedReference apiNamedReference = (ApiNamedReference)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(KeywordRepository.DefaultImpls.findOrCreate$default(this$0.getKeywordRepository(), keywordType, it2.getName(), it2.getId(), null, 8, null));
                }
                list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    addingKeywords.addAll((Collection)it);
                }
            }
            List<ApiNamedReference> list2 = lud.getRemove();
            if (list2 == null) break block4;
            $this$map$iv = list2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (ApiNamedReference)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KeywordRepository.DefaultImpls.findByValueOrUri$default(this$0.getKeywordRepository(), keywordType, it2.getName(), it2.getId(), null, 8, null));
            }
            List it3 = (List)destination$iv$iv;
            boolean bl = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void rsdUpdateFromApi$lookupAlignments(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiAlignmentListUpdate lud, KeywordTypeEnum keywordType) {
        block4: {
            Iterable it;
            ApiAlignment it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            boolean $i$f$map;
            Iterable $this$map$iv;
            List list = lud.getAdd();
            if (list != null) {
                $this$map$iv = list;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ApiAlignment apiAlignment = (ApiAlignment)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    ApiNamedReference apiNamedReference = it2.isPartOf();
                    collection.add(this$0.getKeywordRepository().findOrCreate(keywordType, it2.getSkillName(), it2.getId(), apiNamedReference != null ? apiNamedReference.getName() : null));
                }
                list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    addingKeywords.addAll((Collection)it);
                }
            }
            List<ApiAlignment> list2 = lud.getRemove();
            if (list2 == null) break block4;
            $this$map$iv = list2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (ApiAlignment)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ApiNamedReference apiNamedReference = it2.isPartOf();
                collection.add(this$0.getKeywordRepository().findByValueOrUri(keywordType, it2.getSkillName(), it2.getId(), apiNamedReference != null ? apiNamedReference.getName() : null));
            }
            List it3 = (List)destination$iv$iv;
            boolean bl = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void rsdUpdateFromApi$lookupKeywords(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiStringListUpdate slud, KeywordTypeEnum keywordType) {
        block4: {
            Iterable it;
            String it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            boolean $i$f$map;
            Iterable $this$map$iv;
            List list = slud.getAdd();
            if (list != null) {
                $this$map$iv = list;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(KeywordRepository.DefaultImpls.findOrCreate$default(this$0.getKeywordRepository(), keywordType, it2, null, null, 12, null));
                }
                list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    addingKeywords.addAll((Collection)it);
                }
            }
            List<String> list2 = slud.getRemove();
            if (list2 == null) break block4;
            $this$map$iv = list2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KeywordRepository.DefaultImpls.findByValueOrUri$default(this$0.getKeywordRepository(), keywordType, it2, null, null, 12, null));
            }
            List it3 = (List)destination$iv$iv;
            boolean bl = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it3));
        }
    }
}

