/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.collection;

import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.collection.CollectionDoc;
import edu.wgu.osmt.collection.CustomCollectionQueries;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Ledu/wgu/osmt/collection/CustomCollectionQueriesImpl;", "Ledu/wgu/osmt/collection/CustomCollectionQueries;", "elasticSearchTemplate", "Lorg/springframework/data/elasticsearch/core/ElasticsearchRestTemplate;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "(Lorg/springframework/data/elasticsearch/core/ElasticsearchRestTemplate;Ledu/wgu/osmt/richskill/RichSkillEsRepo;)V", "getElasticSearchTemplate", "()Lorg/springframework/data/elasticsearch/core/ElasticsearchRestTemplate;", "javaClass", "Ljava/lang/Class;", "Ledu/wgu/osmt/collection/CollectionDoc;", "getJavaClass", "()Ljava/lang/Class;", "getRichSkillEsRepo", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "byApiSearch", "Lorg/springframework/data/elasticsearch/core/SearchHits;", "apiSearch", "Ledu/wgu/osmt/api/model/ApiSearch;", "publishStatus", "", "Ledu/wgu/osmt/db/PublishStatus;", "pageable", "Lorg/springframework/data/domain/Pageable;", "collectionPropertiesMultiMatch", "Lorg/elasticsearch/index/query/AbstractQueryBuilder;", "query", "", "osmt-api"})
public final class CustomCollectionQueriesImpl
implements CustomCollectionQueries {
    @NotNull
    private final ElasticsearchRestTemplate elasticSearchTemplate;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final Class<CollectionDoc> javaClass;

    @Autowired
    public CustomCollectionQueriesImpl(@NotNull ElasticsearchRestTemplate elasticSearchTemplate, @NotNull RichSkillEsRepo richSkillEsRepo) {
        Intrinsics.checkNotNullParameter((Object)elasticSearchTemplate, (String)"elasticSearchTemplate");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        this.elasticSearchTemplate = elasticSearchTemplate;
        this.richSkillEsRepo = richSkillEsRepo;
        this.javaClass = CollectionDoc.class;
    }

    @NotNull
    public ElasticsearchRestTemplate getElasticSearchTemplate() {
        return this.elasticSearchTemplate;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public Class<CollectionDoc> getJavaClass() {
        return this.javaClass;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AbstractQueryBuilder<?> collectionPropertiesMultiMatch(@NotNull String query) {
        AbstractQueryBuilder abstractQueryBuilder;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        boolean isComplex = StringsKt.contains$default((CharSequence)query, (CharSequence)"\"", (boolean)false, (int)2, null);
        String[] stringArray = new String[]{"name.raw", "name._2gram", "name._3gram", "author"};
        String[] complexFields = stringArray;
        String[] stringArray2 = new String[]{"name", "name._2gram", "name._3gram", "author"};
        String[] fields = stringArray2;
        if (isComplex) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String[] stringArray3 = complexFields;
            SimpleQueryStringBuilder simpleQueryStringBuilder = QueryBuilders.simpleQueryStringQuery((String)query);
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var14_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it, (Object)Float.valueOf(1.0f)));
            }
            SimpleQueryStringBuilder simpleQueryStringBuilder2 = simpleQueryStringBuilder.fields(MapsKt.toMap((Iterable)((List)destination$iv$iv))).defaultOperator(Operator.AND);
            Intrinsics.checkNotNullExpressionValue((Object)simpleQueryStringBuilder2, (String)"{\n            QueryBuild\u2026r(Operator.AND)\n        }");
            abstractQueryBuilder = (AbstractQueryBuilder)simpleQueryStringBuilder2;
        } else {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)query, (String[])Arrays.copyOf(fields, fields.length)).type(MultiMatchQueryBuilder.Type.BOOL_PREFIX);
            Intrinsics.checkNotNullExpressionValue((Object)multiMatchQueryBuilder, (String)"{\n            QueryBuild\u2026pe.BOOL_PREFIX)\n        }");
            abstractQueryBuilder = (AbstractQueryBuilder)multiMatchQueryBuilder;
        }
        return abstractQueryBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SearchHits<CollectionDoc> byApiSearch(@NotNull ApiSearch apiSearch, @NotNull Set<? extends PublishStatus> publishStatus, @NotNull Pageable pageable) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv2;
        Object $this$map$iv;
        Collection<String> collection;
        Object item$iv$iv22;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        Intrinsics.checkNotNullParameter(publishStatus, (String)"publishStatus");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        BaseQueryBuilder baseQueryBuilder = new NativeSearchQueryBuilder().withPageable(Pageable.unpaged());
        Intrinsics.checkNotNullExpressionValue((Object)baseQueryBuilder, (String)"NativeSearchQueryBuilder\u2026eable(Pageable.unpaged())");
        NativeSearchQueryBuilder nsq = (NativeSearchQueryBuilder)baseQueryBuilder;
        BoolQueryBuilder bq = QueryBuilders.boolQuery();
        Iterable iterable = publishStatus;
        String string = "publishStatus";
        Object object = new BoolQueryBuilder();
        boolean $i$f$map22 = false;
        void var9_11 = $this$map$iv2;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv22 : $this$mapTo$iv$iv3) {
            void ps;
            PublishStatus publishStatus2 = (PublishStatus)item$iv$iv22;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ps.toString());
        }
        collection = (List)destination$iv$iv;
        BoolQueryBuilder filter = object.must((QueryBuilder)QueryBuilders.termsQuery((String)string, (Collection)collection));
        nsq.withFilter((QueryBuilder)filter);
        nsq.withQuery((QueryBuilder)bq);
        List collectionMultiPropertyResults = CollectionsKt.emptyList();
        CharSequence $i$f$map22 = apiSearch.getQuery();
        if (!($i$f$map22 == null || StringsKt.isBlank((CharSequence)$i$f$map22))) {
            bq.should((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)this.getRichSkillEsRepo().richSkillPropertiesMultiMatch(apiSearch.getQuery())).must((QueryBuilder)QueryBuilders.nestedQuery((String)"collections", (QueryBuilder)((QueryBuilder)QueryBuilders.matchAllQuery()), (ScoreMode)ScoreMode.Avg).innerHit(new InnerHitBuilder())));
            bq.should((QueryBuilder)this.getRichSkillEsRepo().occupationQueries(apiSearch.getQuery()));
            List list = this.getElasticSearchTemplate().search((Query)((NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withQuery((QueryBuilder)this.collectionPropertiesMultiMatch(apiSearch.getQuery())).withPageable(Pageable.unpaged())).withFilter((QueryBuilder)filter).build(), CollectionDoc.class).getSearchHits();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"elasticSearchTemplate.se\u2026\n            ).searchHits");
            $this$map$iv = list;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            item$iv$iv22 = $this$mapTo$iv$iv2.iterator();
            while (item$iv$iv22.hasNext()) {
                void it;
                item$iv$iv = item$iv$iv22.next();
                SearchHit bl = (SearchHit)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(((CollectionDoc)it.getContent()).getUuid());
            }
            collectionMultiPropertyResults = (List)destination$iv$iv2;
        } else if (apiSearch.getAdvanced() != null) {
            RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
            Intrinsics.checkNotNullExpressionValue((Object)bq, (String)"bq");
            richSkillEsRepo.generateBoolQueriesFromApiSearch(bq, apiSearch.getAdvanced());
            $this$map$iv = apiSearch.getAdvanced().getCollectionName();
            if (!($this$map$iv == null || StringsKt.isBlank((CharSequence)$this$map$iv))) {
                if (StringsKt.contains$default((CharSequence)apiSearch.getAdvanced().getCollectionName(), (CharSequence)"\"", (boolean)false, (int)2, null)) {
                    List list = this.getElasticSearchTemplate().search((Query)((NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.simpleQueryStringQuery((String)apiSearch.getAdvanced().getCollectionName()).field("name.raw").defaultOperator(Operator.AND)).withPageable(Pageable.unpaged())).withFilter((QueryBuilder)filter).build(), CollectionDoc.class).getSearchHits();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"elasticSearchTemplate.se\u2026             ).searchHits");
                    $this$map$iv = list;
                    boolean $i$f$map = false;
                    $this$mapTo$iv$iv2 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo3 = false;
                    item$iv$iv22 = $this$mapTo$iv$iv2.iterator();
                    while (item$iv$iv22.hasNext()) {
                        item$iv$iv = item$iv$iv22.next();
                        SearchHit it = (SearchHit)item$iv$iv;
                        object = destination$iv$iv3;
                        boolean bl = false;
                        object.add(((CollectionDoc)it.getContent()).getUuid());
                    }
                    collectionMultiPropertyResults = (List)destination$iv$iv3;
                } else {
                    List list = this.getElasticSearchTemplate().search((Query)((NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"name", (Object)apiSearch.getAdvanced().getCollectionName())).withPageable(Pageable.unpaged())).withFilter((QueryBuilder)filter).build(), CollectionDoc.class).getSearchHits();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"elasticSearchTemplate.se\u2026             ).searchHits");
                    $this$map$iv = list;
                    boolean $i$f$map = false;
                    $this$mapTo$iv$iv2 = $this$map$iv;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo4 = false;
                    item$iv$iv22 = $this$mapTo$iv$iv2.iterator();
                    while (item$iv$iv22.hasNext()) {
                        item$iv$iv = item$iv$iv22.next();
                        SearchHit it = (SearchHit)item$iv$iv;
                        object = destination$iv$iv4;
                        boolean bl = false;
                        object.add(((CollectionDoc)it.getContent()).getUuid());
                    }
                    collectionMultiPropertyResults = (List)destination$iv$iv4;
                }
            } else {
                bq.must((QueryBuilder)QueryBuilders.nestedQuery((String)"collections", (QueryBuilder)((QueryBuilder)QueryBuilders.matchAllQuery()), (ScoreMode)ScoreMode.Avg).innerHit(new InnerHitBuilder()));
            }
        } else {
            bq.must((QueryBuilder)QueryBuilders.nestedQuery((String)"collections", (QueryBuilder)((QueryBuilder)QueryBuilders.matchAllQuery()), (ScoreMode)ScoreMode.Avg).innerHit(new InnerHitBuilder()));
        }
        SearchHits searchHits = this.getElasticSearchTemplate().search((Query)nsq.build(), RichSkillDoc.class);
        Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"elasticSearchTemplate.se\u2026RichSkillDoc::class.java)");
        SearchHits results = searchHits;
        List list = results.getSearchHits();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"results.searchHits");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$mapTo4 = $this$mapNotNull$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        CollectionDoc collectionDoc = $this$forEach$iv$iv$iv.iterator();
        while (collectionDoc.hasNext()) {
            List list2;
            List list3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = collectionDoc.next();
            boolean bl = false;
            SearchHit it = (SearchHit)element$iv$iv;
            boolean bl3 = false;
            Object object2 = it.getInnerHits("collections");
            if (object2 != null && (object2 = (list3 = object2.getSearchHits())) != null) {
                void $this$mapNotNullTo$iv$iv2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"searchHits");
                Iterable $this$mapNotNull$iv2 = list3;
                boolean $i$f$mapNotNull2 = false;
                Iterable iterable2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv6 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    CollectionDoc it$iv$iv;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    SearchHit it2 = (SearchHit)element$iv$iv2;
                    boolean bl4 = false;
                    Object object3 = it2.getContent();
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type edu.wgu.osmt.collection.CollectionDoc");
                    if ((CollectionDoc)object3 == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv6.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv6;
            } else {
                list2 = null;
            }
            if (list2 == null) continue;
            List it$iv$iv = list2;
            boolean bl6 = false;
            destination$iv$iv5.add(it$iv$iv);
        }
        Iterable $this$map$iv3 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv5));
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv3;
        destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            collectionDoc = (CollectionDoc)item$iv$iv3;
            object = destination$iv$iv5;
            boolean bl = false;
            object.add(it.getUuid());
        }
        List innerHitCollectionUuids = CollectionsKt.distinct((Iterable)((List)destination$iv$iv5));
        SearchHits searchHits2 = this.getElasticSearchTemplate().search((Query)((NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)innerHitCollectionUuids, (Iterable)collectionMultiPropertyResults)))).withFilter((QueryBuilder)filter).withPageable(pageable)).build(), CollectionDoc.class);
        Intrinsics.checkNotNullExpressionValue((Object)searchHits2, (String)"elasticSearchTemplate.se\u2026Doc::class.java\n        )");
        return searchHits2;
    }

    public void deleteIndex() {
        CustomCollectionQueries.DefaultImpls.deleteIndex((CustomCollectionQueries)this);
    }

    @NotNull
    public SearchHits<CollectionDoc> findAllFilteredByPublishStatus(@NotNull Set<? extends PublishStatus> publishStatus, @NotNull Pageable pageable) {
        return CustomCollectionQueries.DefaultImpls.findAllFilteredByPublishStatus((CustomCollectionQueries)this, publishStatus, (Pageable)pageable);
    }

    public long countAllFilteredByPublishStatus(@NotNull Set<? extends PublishStatus> publishStatus, @NotNull Pageable pageable) {
        return CustomCollectionQueries.DefaultImpls.countAllFilteredByPublishStatus((CustomCollectionQueries)this, publishStatus, (Pageable)pageable);
    }

    @NotNull
    public NativeSearchQueryBuilder buildQuery(@NotNull Pageable pageable, @NotNull Set<? extends PublishStatus> publishStatus) {
        return CustomCollectionQueries.DefaultImpls.buildQuery((CustomCollectionQueries)this, (Pageable)pageable, publishStatus);
    }
}

