/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.elasticsearch;

import edu.wgu.osmt.elasticsearch.ElasticsearchClientManager;
import edu.wgu.osmt.elasticsearch.EsConfig;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;

@Configuration
@EnableElasticsearchRepositories(value={"edu.wgu.osmt.elasticsearch"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Ledu/wgu/osmt/elasticsearch/ElasticsearchClientManager;", "", "()V", "esConfig", "Ledu/wgu/osmt/elasticsearch/EsConfig;", "getEsConfig", "()Ledu/wgu/osmt/elasticsearch/EsConfig;", "setEsConfig", "(Ledu/wgu/osmt/elasticsearch/EsConfig;)V", "elasticSearchClient", "Lorg/elasticsearch/client/RestHighLevelClient;", "elasticSearchCustomConversions", "Lorg/springframework/data/elasticsearch/core/convert/ElasticsearchCustomConversions;", "elasticsearchTemplate", "Lorg/springframework/data/elasticsearch/core/ElasticsearchRestTemplate;", "LocalDateTimeToString", "StringToLocalDatetime", "StringToUuid", "UuidToString", "osmt-api"})
public class ElasticsearchClientManager {
    @Autowired
    public EsConfig esConfig;

    @NotNull
    public EsConfig getEsConfig() {
        EsConfig esConfig = this.esConfig;
        if (esConfig != null) {
            return esConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"esConfig");
        return null;
    }

    public void setEsConfig(@NotNull EsConfig esConfig) {
        Intrinsics.checkNotNullParameter((Object)esConfig, (String)"<set-?>");
        this.esConfig = esConfig;
    }

    @Bean
    @NotNull
    public RestHighLevelClient elasticSearchClient() {
        HttpHost[] httpHostArray = new HttpHost[]{HttpHost.create((String)this.getEsConfig().getUri())};
        return new RestHighLevelClient(RestClient.builder((HttpHost[])httpHostArray));
    }

    @Bean
    @NotNull
    public ElasticsearchRestTemplate elasticsearchTemplate() {
        return new ElasticsearchRestTemplate(this.elasticSearchClient());
    }

    @Bean
    @NotNull
    public ElasticsearchCustomConversions elasticSearchCustomConversions() {
        Object[] objectArray = new Converter[]{(Converter)new LocalDateTimeToString(), (Converter)new StringToLocalDatetime(), (Converter)new UuidToString(), (Converter)new StringToUuid()};
        return new ElasticsearchCustomConversions((Collection)CollectionsKt.listOf((Object[])objectArray));
    }
}

