/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.security;

import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.PublishStatus;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0011H\u0016J\u001c\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u0016\u001a\u00020\u0011H\u0016J\u001c\u0010\u0017\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0011H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Ledu/wgu/osmt/security/OAuthHelper;", "", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "setAppConfig", "(Ledu/wgu/osmt/config/AppConfig;)V", "hasPublishStatus", "", "status", "Ledu/wgu/osmt/db/PublishStatus;", "statuses", "", "hasRole", "role", "", "isArchiveRelated", "readableUserIdentifier", "jwt", "Lorg/springframework/security/oauth2/jwt/Jwt;", "default", "readableUserName", "user", "Lorg/springframework/security/oauth2/core/user/OAuth2User;", "osmt-api"})
public class OAuthHelper {
    @Autowired
    public AppConfig appConfig;

    @NotNull
    public AppConfig getAppConfig() {
        AppConfig appConfig = this.appConfig;
        if (appConfig != null) {
            return appConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appConfig");
        return null;
    }

    public void setAppConfig(@NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"<set-?>");
        this.appConfig = appConfig;
    }

    @NotNull
    public String readableUserName(@Nullable OAuth2User user, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"default");
        OAuth2User oAuth2User = user;
        String string2 = oAuth2User != null ? oAuth2User.getName() : null;
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static /* synthetic */ String readableUserName$default(OAuthHelper oAuthHelper, OAuth2User oAuth2User, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readableUserName");
        }
        if ((n & 2) != 0) {
            string = "unauthenticated";
        }
        return oAuthHelper.readableUserName(oAuth2User, string);
    }

    @NotNull
    public String readableUserName(@Nullable Jwt jwt, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"default");
        Object object = jwt;
        String string2 = object != null && (object = object.getClaims()) != null ? object.get(this.getAppConfig().getUserName()) : null;
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static /* synthetic */ String readableUserName$default(OAuthHelper oAuthHelper, Jwt jwt, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readableUserName");
        }
        if ((n & 2) != 0) {
            string = "unauthenticated";
        }
        return oAuthHelper.readableUserName(jwt, string);
    }

    @NotNull
    public String readableUserIdentifier(@Nullable Jwt jwt, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"default");
        Object object = jwt;
        String string2 = object != null && (object = object.getClaims()) != null ? object.get(this.getAppConfig().getUserIdentifier()) : null;
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static /* synthetic */ String readableUserIdentifier$default(OAuthHelper oAuthHelper, Jwt jwt, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readableUserIdentifier");
        }
        if ((n & 2) != 0) {
            string = "unauthenticated";
        }
        return oAuthHelper.readableUserIdentifier(jwt, string);
    }

    public boolean hasRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        String roles = SecurityContextHolder.getContext().getAuthentication().getAuthorities().toString();
        return StringsKt.contains$default((CharSequence)roles, (CharSequence)role, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasPublishStatus(@Nullable PublishStatus status2, @NotNull List<? extends PublishStatus> statuses) {
        boolean bl;
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        if (status2 == null) return true;
        Iterable $this$any$iv = statuses;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            PublishStatus it = (PublishStatus)element$iv;
            boolean bl2 = false;
            if (it == status2) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public boolean isArchiveRelated(@Nullable PublishStatus status2) {
        Object[] objectArray = new PublishStatus[]{PublishStatus.Archived, PublishStatus.Unarchived};
        return this.hasPublishStatus(status2, CollectionsKt.listOf((Object[])objectArray));
    }
}

