/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.auditlog;

import edu.wgu.osmt.auditlog.AuditLog;
import edu.wgu.osmt.auditlog.AuditLogRepository;
import edu.wgu.osmt.auditlog.AuditOperationType;
import edu.wgu.osmt.auditlog.Change;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.collection.CollectionKt;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.collection.CollectionTable;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillDescriptorKt;
import edu.wgu.osmt.richskill.RichSkillDescriptorTable;
import edu.wgu.osmt.richskill.RichSkillRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000e8\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ledu/wgu/osmt/auditlog/AuditLogUtils;", "", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "auditLogRepository", "Ledu/wgu/osmt/auditlog/AuditLogRepository;", "collectionRepository", "Ledu/wgu/osmt/collection/CollectionRepository;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "baseLineIfEmpty", "", "generateCollectionLogs", "generateSkillLogs", "osmt-api"})
public class AuditLogUtils {
    @NotNull
    private final Logger logger;
    @Autowired
    private AuditLogRepository auditLogRepository;
    @Autowired
    private CollectionRepository collectionRepository;
    @Autowired
    private RichSkillRepository richSkillRepository;
    @Autowired
    private AppConfig appConfig;

    public AuditLogUtils() {
        Logger logger = LoggerFactory.getLogger(AuditLogUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(AuditLogUtils::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public void generateSkillLogs() {
        void $this$mapTo$iv$iv;
        RichSkillRepository richSkillRepository = this.richSkillRepository;
        if (richSkillRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"richSkillRepository");
            richSkillRepository = null;
        }
        SizedIterable skills = richSkillRepository.getDao().all();
        Iterable $this$map$iv = (Iterable)skills;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void skill;
            RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RichSkillDescriptor it = skill.toModel();
            boolean bl2 = false;
            List<Change> changes = RichSkillDescriptorKt.diff(it, null);
            AuditLogRepository auditLogRepository = this.auditLogRepository;
            if (auditLogRepository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"auditLogRepository");
                auditLogRepository = null;
            }
            collection.add(auditLogRepository.create(AuditLog.Companion.fromAtomicOp((Table)RichSkillDescriptorTable.INSTANCE, ((Number)((Object)skill.getId().getValue())).longValue(), changes, "Batch Import", AuditOperationType.Insert)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public void generateCollectionLogs() {
        void $this$mapTo$iv$iv;
        CollectionRepository collectionRepository = this.collectionRepository;
        if (collectionRepository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"collectionRepository");
            collectionRepository = null;
        }
        SizedIterable collections = collectionRepository.getDao().all();
        Iterable $this$map$iv = (Iterable)collections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void collection;
            CollectionDao collectionDao = (CollectionDao)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            edu.wgu.osmt.collection.Collection it = collection.toModel();
            boolean bl2 = false;
            List<Change> changes = CollectionKt.diff(it, null);
            AuditLogRepository auditLogRepository = this.auditLogRepository;
            if (auditLogRepository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"auditLogRepository");
                auditLogRepository = null;
            }
            collection2.add(auditLogRepository.create(AuditLog.Companion.fromAtomicOp((Table)CollectionTable.INSTANCE, ((Number)((Object)collection.getId().getValue())).longValue(), changes, "Batch Import", AuditOperationType.Insert)));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    public void baseLineIfEmpty() {
        long entryCount2;
        AppConfig appConfig = this.appConfig;
        if (appConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appConfig");
            appConfig = null;
        }
        if (appConfig.getBaseLineAuditLogIfEmpty() && (entryCount2 = ((Number)ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new Function1<Transaction, Long>(this){
            final /* synthetic */ AuditLogUtils this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                AuditLogRepository auditLogRepository = AuditLogUtils.access$getAuditLogRepository$p(this.this$0);
                if (auditLogRepository == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"auditLogRepository");
                    auditLogRepository = null;
                }
                return auditLogRepository.getDao().all().count();
            }
        }), (int)1, null)).longValue()) == 0L) {
            this.getLogger().info("Audit log appears empty, generating baseline from current state...");
            ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new Function1<Transaction, Unit>(this){
                final /* synthetic */ AuditLogUtils this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Transaction $this$transaction) {
                    Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                    this.this$0.generateSkillLogs();
                }
            }), (int)1, null);
            ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new Function1<Transaction, Unit>(this){
                final /* synthetic */ AuditLogUtils this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Transaction $this$transaction) {
                    Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                    this.this$0.generateCollectionLogs();
                }
            }), (int)1, null);
            this.getLogger().info("Audit log baseline complete.");
        }
    }

    public static final /* synthetic */ AuditLogRepository access$getAuditLogRepository$p(AuditLogUtils $this) {
        return $this.auditLogRepository;
    }
}

