/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.wgu.osmt.api.model.ApiAlignment;
import edu.wgu.osmt.api.model.ApiJobCode;
import edu.wgu.osmt.api.model.ApiNamedReference;
import edu.wgu.osmt.api.model.ApiUuidReference;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.JobCodeLevel;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.jobcode.JobCode;
import edu.wgu.osmt.keyword.Keyword;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 @2\u00020\u0001:\u0001@B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000eR\u0016\u0010\u001f\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0011\u0010!\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0011\u0010#\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000eR\u0011\u0010'\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0016R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b8G\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000eR\u0013\u0010.\u001a\u0004\u0018\u00010\u00108G\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0016R\u0011\u00102\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0016R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8G\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000eR\u0011\u00106\u001a\u0002078G\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0016\u0010:\u001a\u00020\u00148\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0016R\u0011\u0010<\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0012R\u0011\u0010>\u001a\u00020\u00148G\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0016\u00a8\u0006A"}, d2={"Ledu/wgu/osmt/api/model/ApiSkill;", "", "rsd", "Ledu/wgu/osmt/richskill/RichSkillDescriptor;", "cs", "", "Ledu/wgu/osmt/collection/Collection;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/richskill/RichSkillDescriptor;Ljava/util/Set;Ledu/wgu/osmt/config/AppConfig;)V", "alignments", "", "Ledu/wgu/osmt/api/model/ApiAlignment;", "getAlignments", "()Ljava/util/List;", "archiveDate", "Ljava/time/ZonedDateTime;", "getArchiveDate", "()Ljava/time/ZonedDateTime;", "author", "", "getAuthor", "()Ljava/lang/String;", "category", "getCategory", "certifications", "Ledu/wgu/osmt/api/model/ApiNamedReference;", "getCertifications", "collections", "Ledu/wgu/osmt/api/model/ApiUuidReference;", "getCollections", "context", "getContext", "creationDate", "getCreationDate", "creator", "getCreator", "employers", "getEmployers", "id", "getId", "keywords", "getKeywords", "occupations", "Ledu/wgu/osmt/api/model/ApiJobCode;", "getOccupations", "publishDate", "getPublishDate", "skillName", "getSkillName", "skillStatement", "getSkillStatement", "standards", "getStandards", "status", "Ledu/wgu/osmt/db/PublishStatus;", "getStatus", "()Ledu/wgu/osmt/db/PublishStatus;", "type", "getType", "updateDate", "getUpdateDate", "uuid", "getUuid", "Companion", "osmt-api"})
public final class ApiSkill {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RichSkillDescriptor rsd;
    @NotNull
    private final Set<edu.wgu.osmt.collection.Collection> cs;
    @NotNull
    private final AppConfig appConfig;
    @JsonProperty(value="@context")
    @NotNull
    private final String context;
    @JsonProperty
    @NotNull
    private final String type;

    public ApiSkill(@NotNull RichSkillDescriptor rsd, @NotNull Set<edu.wgu.osmt.collection.Collection> cs, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)rsd, (String)"rsd");
        Intrinsics.checkNotNullParameter(cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.rsd = rsd;
        this.cs = cs;
        this.appConfig = appConfig;
        this.context = this.appConfig.getRsdContextUrl();
        this.type = "RichSkillDescriptor";
    }

    @NotNull
    public final String getContext() {
        return this.context;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @JsonProperty
    @NotNull
    public final String getCreator() {
        return this.appConfig.getDefaultCreatorUri();
    }

    @JsonProperty
    @Nullable
    public final String getAuthor() {
        String string;
        Keyword keyword = this.rsd.getAuthor();
        if (keyword != null) {
            Keyword it = keyword;
            boolean bl = false;
            string = it.getValue();
        } else {
            string = null;
        }
        return string;
    }

    @JsonProperty
    @NotNull
    public final PublishStatus getStatus() {
        return this.rsd.publishStatus();
    }

    @JsonProperty
    @NotNull
    public final ZonedDateTime getCreationDate() {
        ZonedDateTime zonedDateTime = this.rsd.getCreationDate().atZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"rsd.creationDate.atZone(ZoneId.of(\"UTC\"))");
        return zonedDateTime;
    }

    @JsonProperty
    @NotNull
    public final ZonedDateTime getUpdateDate() {
        ZonedDateTime zonedDateTime = this.rsd.getUpdateDate().atZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"rsd.updateDate.atZone(ZoneId.of(\"UTC\"))");
        return zonedDateTime;
    }

    @JsonProperty
    @Nullable
    public final ZonedDateTime getPublishDate() {
        LocalDateTime localDateTime = this.rsd.getPublishDate();
        return localDateTime != null ? localDateTime.atZone(ZoneId.of("UTC")) : null;
    }

    @JsonProperty
    @Nullable
    public final ZonedDateTime getArchiveDate() {
        LocalDateTime localDateTime = this.rsd.getArchiveDate();
        return localDateTime != null ? localDateTime.atZone(ZoneId.of("UTC")) : null;
    }

    @JsonProperty
    @NotNull
    public final String getSkillName() {
        return this.rsd.getName();
    }

    @JsonProperty
    @NotNull
    public final String getSkillStatement() {
        return this.rsd.getStatement();
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<String> getKeywords() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.rsd.getSearchingKeywords();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Keyword it = (Keyword)element$iv$iv;
            boolean bl2 = false;
            if (it.getValue() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JsonProperty
    @Nullable
    public final String getCategory() {
        Keyword keyword = this.rsd.getCategory();
        return keyword != null ? keyword.getValue() : null;
    }

    @JsonProperty
    @NotNull
    public final String getId() {
        return this.rsd.canonicalUrl(this.appConfig.getBaseUrl());
    }

    @JsonProperty
    @NotNull
    public final String getUuid() {
        return this.rsd.getUuid().toString();
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiNamedReference> getCertifications() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.rsd.getCertifications();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyword keyword = (Keyword)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiNamedReference.factory.fromKeyword((Keyword)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiAlignment> getStandards() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.rsd.getStandards();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyword keyword = (Keyword)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiAlignment.factory.fromKeyword((Keyword)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiAlignment> getAlignments() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.rsd.getAlignments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyword keyword = (Keyword)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiAlignment.factory.fromKeyword((Keyword)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiJobCode> getOccupations() {
        void $this$mapTo$iv$iv;
        JobCode it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.rsd.getJobCodes();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JobCode)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it.getCode());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ApiJobCode apiJobCode;
            ApiJobCode apiJobCode2;
            ApiJobCode apiJobCode3;
            ApiJobCode apiJobCode4;
            ApiJobCode apiJobCode5;
            String it2;
            void jobCode;
            it = (JobCode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new ApiJobCode[4];
            String string = jobCode.getMajor();
            int n = 0;
            Object[] objectArray2 = objectArray;
            boolean bl3 = false;
            if (jobCode.getMajorCode() != null) {
                boolean bl4 = false;
                apiJobCode5 = new ApiJobCode(it2, null, jobCode.getMajor(), null, JobCodeLevel.Major, null, 42, null);
            } else {
                apiJobCode5 = null;
            }
            objectArray2[n] = apiJobCode4 = apiJobCode5;
            String it3 = jobCode.getMinor();
            n = 1;
            objectArray2 = objectArray;
            boolean bl5 = false;
            if (jobCode.getMinorCode() != null) {
                boolean bl6 = false;
                apiJobCode3 = new ApiJobCode(it2, null, jobCode.getMinor(), null, JobCodeLevel.Minor, null, 42, null);
            } else {
                apiJobCode3 = null;
            }
            objectArray2[n] = apiJobCode4 = apiJobCode3;
            Object[] objectArray3 = objectArray;
            int n2 = 2;
            if (jobCode.getBroad() != null) {
                ApiJobCode apiJobCode6;
                n = n2;
                objectArray2 = objectArray3;
                boolean bl7 = false;
                if (jobCode.getBroadCode() != null) {
                    String it4;
                    boolean bl8 = false;
                    apiJobCode6 = new ApiJobCode(it4, null, jobCode.getBroad(), null, JobCodeLevel.Broad, null, 42, null);
                } else {
                    apiJobCode6 = null;
                }
                apiJobCode4 = apiJobCode6;
                objectArray3 = objectArray2;
                n2 = n;
                apiJobCode2 = apiJobCode4;
            } else {
                apiJobCode2 = null;
            }
            objectArray3[n2] = apiJobCode2;
            Object[] objectArray4 = objectArray;
            int n3 = 3;
            if (jobCode.getDetailed() != null) {
                ApiJobCode apiJobCode7;
                n = n3;
                objectArray2 = objectArray4;
                boolean bl9 = false;
                if (jobCode.getDetailedCode() != null) {
                    String it5;
                    boolean bl10 = false;
                    apiJobCode7 = new ApiJobCode(it5, null, jobCode.getDetailed(), null, JobCodeLevel.Detailed, null, 42, null);
                } else {
                    apiJobCode7 = null;
                }
                apiJobCode4 = apiJobCode7;
                objectArray4 = objectArray2;
                n3 = n;
                apiJobCode = apiJobCode4;
            } else {
                apiJobCode = null;
            }
            objectArray4[n3] = apiJobCode;
            List parents = CollectionsKt.distinct((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
            collection.add(ApiJobCode.factory.fromJobCode$default(ApiJobCode.factory, (JobCode)jobCode, null, parents, 2, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiNamedReference> getEmployers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.rsd.getEmployers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Keyword keyword = (Keyword)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiNamedReference.factory.fromKeyword((Keyword)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public final List<ApiUuidReference> getCollections() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.cs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            edu.wgu.osmt.collection.Collection collection = (edu.wgu.osmt.collection.Collection)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(ApiUuidReference.factory.fromCollection((edu.wgu.osmt.collection.Collection)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ledu/wgu/osmt/api/model/ApiSkill$Companion;", "", "()V", "fromDao", "Ledu/wgu/osmt/api/model/ApiSkill;", "rsdDao", "Ledu/wgu/osmt/richskill/RichSkillDescriptorDao;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "osmt-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ApiSkill fromDao(@NotNull RichSkillDescriptorDao rsdDao, @NotNull AppConfig appConfig) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            edu.wgu.osmt.collection.Collection it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)rsdDao, (String)"rsdDao");
            Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
            Iterable iterable = (Iterable)rsdDao.getCollections();
            RichSkillDescriptor richSkillDescriptor = rsdDao.toModel();
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CollectionDao collectionDao = (CollectionDao)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((CollectionDao)((Object)it)).toModel());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (edu.wgu.osmt.collection.Collection)element$iv$iv;
                boolean bl = false;
                if (!(!it.isWorkspace())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            AppConfig appConfig2 = appConfig;
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            RichSkillDescriptor richSkillDescriptor2 = richSkillDescriptor;
            return new ApiSkill(richSkillDescriptor2, set, appConfig2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

