/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.richskill;

import com.github.sonus21.rqueue.annotation.RqueueListener;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.richskill.RichSkillAndCollections;
import edu.wgu.osmt.richskill.RichSkillCsvExport;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.task.ExportSkillsToCsvTask;
import edu.wgu.osmt.task.TaskMessageService;
import edu.wgu.osmt.task.TaskStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Profile(value={"apiserver"})
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00148\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Ledu/wgu/osmt/richskill/ExportSkillToCsvTaskProcessor;", "", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "setAppConfig", "(Ledu/wgu/osmt/config/AppConfig;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "setRichSkillRepository", "(Ledu/wgu/osmt/richskill/RichSkillRepository;)V", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "setTaskMessageService", "(Ledu/wgu/osmt/task/TaskMessageService;)V", "csvSkillsInCustomRsdListProcessor", "", "task", "Ledu/wgu/osmt/task/ExportSkillsToCsvTask;", "osmt-api"})
public class ExportSkillToCsvTaskProcessor {
    @NotNull
    private final Logger logger;
    @Autowired
    public TaskMessageService taskMessageService;
    @Autowired
    public RichSkillRepository richSkillRepository;
    @Autowired
    public AppConfig appConfig;

    public ExportSkillToCsvTaskProcessor() {
        Logger logger = LoggerFactory.getLogger(ExportSkillToCsvTaskProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ExportSkillToC\u2026askProcessor::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        TaskMessageService taskMessageService = this.taskMessageService;
        if (taskMessageService != null) {
            return taskMessageService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"taskMessageService");
        return null;
    }

    public void setTaskMessageService(@NotNull TaskMessageService taskMessageService) {
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"<set-?>");
        this.taskMessageService = taskMessageService;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        RichSkillRepository richSkillRepository = this.richSkillRepository;
        if (richSkillRepository != null) {
            return richSkillRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"richSkillRepository");
        return null;
    }

    public void setRichSkillRepository(@NotNull RichSkillRepository richSkillRepository) {
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"<set-?>");
        this.richSkillRepository = richSkillRepository;
    }

    @NotNull
    public AppConfig getAppConfig() {
        AppConfig appConfig = this.appConfig;
        if (appConfig != null) {
            return appConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appConfig");
        return null;
    }

    public void setAppConfig(@NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"<set-?>");
        this.appConfig = appConfig;
    }

    /*
     * WARNING - void declaration
     */
    @RqueueListener(value={"custom-rsd-list-export"}, deadLetterQueue="dead-letters", deadLetterQueueListenerEnabled="true", concurrency="1")
    public void csvSkillsInCustomRsdListProcessor(@NotNull ExportSkillsToCsvTask task) {
        String string;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getLogger().info("Started processing task for Custom RSD List export");
        List<String> list = task.getUuids();
        if (list != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = list;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getRichSkillRepository().findByUUID((String)it));
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RichSkillDescriptorDao bl = (RichSkillDescriptorDao)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                void v1 = it;
                Intrinsics.checkNotNull((Object)v1);
                collection.add(RichSkillAndCollections.Companion.fromDao((RichSkillDescriptorDao)v1));
            }
            List it = (List)destination$iv$iv2;
            boolean bl = false;
            string = new RichSkillCsvExport(this.getAppConfig()).toCsv(it);
        } else {
            string = null;
        }
        String csv2 = string;
        this.getTaskMessageService().publishResult(ExportSkillsToCsvTask.copy$default(task, null, null, null, null, csv2, TaskStatus.Ready, 15, null));
        this.getLogger().info("Custom RSD List export task completed");
    }
}

