/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt;

import edu.wgu.osmt.auditlog.AuditLogTable;
import edu.wgu.osmt.auditlog.AuditLogUtils;
import edu.wgu.osmt.collection.CollectionSkills;
import edu.wgu.osmt.collection.CollectionTable;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.ExposedHelperKt;
import edu.wgu.osmt.jobcode.JobCodeTable;
import edu.wgu.osmt.keyword.KeywordTable;
import edu.wgu.osmt.richskill.RichSkillDescriptorTable;
import edu.wgu.osmt.richskill.RichSkillJobCodes;
import edu.wgu.osmt.richskill.RichSkillKeywords;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Component
@Profile(value={"apiserver"})
@EnableWebMvc
@EnableCaching
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ledu/wgu/osmt/ApiServer;", "", "()V", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "auditLogUtils", "Ledu/wgu/osmt/auditlog/AuditLogUtils;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "tableList", "", "Lorg/jetbrains/exposed/sql/Table;", "commandLineRunner", "Lorg/springframework/boot/CommandLineRunner;", "printMissingTableAndColumnStatements", "", "osmt-api"})
public class ApiServer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<Table> tableList;
    @Autowired
    private AppConfig appConfig;
    @Autowired
    private AuditLogUtils auditLogUtils;

    public ApiServer() {
        Logger logger = LoggerFactory.getLogger(ApiServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(ApiServer::class.java)");
        this.logger = logger;
        Object[] objectArray = new Table[]{(Table)AuditLogTable.INSTANCE, (Table)RichSkillDescriptorTable.INSTANCE, (Table)JobCodeTable.INSTANCE, RichSkillJobCodes.INSTANCE, (Table)KeywordTable.INSTANCE, RichSkillKeywords.INSTANCE, (Table)CollectionTable.INSTANCE, CollectionSkills.INSTANCE};
        this.tableList = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Bean
    @NotNull
    public CommandLineRunner commandLineRunner() {
        return arg_0 -> ApiServer.commandLineRunner$lambda$0(this, arg_0);
    }

    public void printMissingTableAndColumnStatements() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ApiServer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AppConfig appConfig = ApiServer.access$getAppConfig$p(this.this$0);
                        if (appConfig == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"appConfig");
                            appConfig = null;
                        }
                        if (appConfig.getDbConfig().getShowMissingCreateTableStatements()) {
                            Ref.ObjectRef missingStatements = new Ref.ObjectRef();
                            missingStatements.element = new ArrayList<E>();
                            Iterable $this$forEach$iv = ApiServer.access$getTableList$p(this.this$0);
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                Table table = (Table)element$iv;
                                boolean bl = false;
                                ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new Function1<Transaction, Unit>(table, (Ref.ObjectRef<List<String>>)missingStatements){
                                    final /* synthetic */ Table $table;
                                    final /* synthetic */ Ref.ObjectRef<List<String>> $missingStatements;
                                    {
                                        this.$table = $table;
                                        this.$missingStatements = $missingStatements;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Transaction $this$transaction) {
                                        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                                        Table[] tableArray = new Table[]{this.$table};
                                        List statements = SchemaUtils.INSTANCE.createStatements(tableArray);
                                        Table[] tableArray2 = new Table[]{this.$table};
                                        List<String> missingColumnStatements = ExposedHelperKt.addMissingColumnsStatementsPublic(SchemaUtils.INSTANCE, tableArray2);
                                        if (!((Collection)statements).isEmpty()) {
                                            ((List)this.$missingStatements.element).addAll(statements);
                                        }
                                        if (!((Collection)missingColumnStatements).isEmpty()) {
                                            ((List)this.$missingStatements.element).addAll((Collection)missingColumnStatements);
                                        }
                                    }
                                }), (int)1, null);
                            }
                            if (((List)missingStatements.element).size() > 0) {
                                this.this$0.getLogger().warn("Database out of sync with application!");
                                $this$forEach$iv = (Iterable)missingStatements.element;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    String it = (String)element$iv;
                                    boolean bl = false;
                                    System.out.println((Object)(it + ";"));
                                }
                            } else {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                $this$forEach$iv = ApiServer.access$getTableList$p(this.this$0);
                                Logger logger = this.this$0.getLogger();
                                boolean $i$f$map = false;
                                Iterator<T> iterator = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    Table table = (Table)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getTableName());
                                }
                                logger.info("Tables " + (List)destination$iv$iv + " are in sync with application!");
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final void commandLineRunner$lambda$0(ApiServer this$0, String[] it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.printMissingTableAndColumnStatements();
        AuditLogUtils auditLogUtils = this$0.auditLogUtils;
        if (auditLogUtils == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"auditLogUtils");
            auditLogUtils = null;
        }
        auditLogUtils.baseLineIfEmpty();
    }

    public static final /* synthetic */ AppConfig access$getAppConfig$p(ApiServer $this) {
        return $this.appConfig;
    }

    public static final /* synthetic */ List access$getTableList$p(ApiServer $this) {
        return $this.tableList;
    }
}

