/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.collection;

import edu.wgu.osmt.HasAllPaginated;
import edu.wgu.osmt.api.GeneralApiException;
import edu.wgu.osmt.api.model.ApiCollection;
import edu.wgu.osmt.api.model.ApiCollectionUpdate;
import edu.wgu.osmt.api.model.ApiCollectionV2;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.api.model.ApiSearchV2;
import edu.wgu.osmt.api.model.ApiSkillListUpdate;
import edu.wgu.osmt.api.model.ApiStringListUpdate;
import edu.wgu.osmt.api.model.CollectionSortEnum;
import edu.wgu.osmt.api.model.SortOrderCompanion;
import edu.wgu.osmt.auditlog.AuditLog;
import edu.wgu.osmt.auditlog.AuditLogDao;
import edu.wgu.osmt.auditlog.AuditLogRepository;
import edu.wgu.osmt.auditlog.AuditLogSortEnum;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.collection.CollectionDoc;
import edu.wgu.osmt.collection.CollectionEsRepo;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.collection.CollectionTable;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.elasticsearch.OffsetPageable;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.security.OAuthHelper;
import edu.wgu.osmt.task.AppliesToType;
import edu.wgu.osmt.task.CsvTask;
import edu.wgu.osmt.task.CsvTaskV2;
import edu.wgu.osmt.task.PublishTask;
import edu.wgu.osmt.task.PublishTaskV2;
import edu.wgu.osmt.task.RemoveCollectionSkillsTask;
import edu.wgu.osmt.task.Task;
import edu.wgu.osmt.task.TaskMessageService;
import edu.wgu.osmt.task.TaskResult;
import edu.wgu.osmt.task.UpdateCollectionSkillsTask;
import edu.wgu.osmt.task.XlsxTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.SizedIterable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011JU\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0013032\b\u00104\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u00107J\u0014\u00108\u001a\u0004\u0018\u0001092\b\b\u0001\u0010:\u001a\u00020\u0013H\u0017J\u0012\u0010;\u001a\u00020\u00132\b\b\u0001\u0010:\u001a\u00020\u0013H\u0017J\u0014\u0010<\u001a\u0004\u0018\u0001092\b\b\u0001\u0010:\u001a\u00020\u0013H\u0017J\u001e\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0,0+2\b\b\u0001\u0010:\u001a\u00020\u0013H\u0017J*\u0010?\u001a\b\u0012\u0004\u0012\u0002090,2\u000e\b\u0001\u0010@\u001a\b\u0012\u0004\u0012\u00020A0,2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J*\u0010B\u001a\b\u0012\u0004\u0012\u0002090,2\u000e\b\u0001\u0010@\u001a\b\u0012\u0004\u0012\u00020A0,2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u0016\u0010C\u001a\u0004\u0018\u0001092\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u0016\u0010D\u001a\u0004\u0018\u0001092\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J$\u0010E\u001a\b\u0012\u0004\u0012\u00020F0+2\n\b\u0001\u0010G\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010:\u001a\u00020\u0013H\u0017J\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00020F0+2\b\b\u0001\u0010:\u001a\u00020\u0013H\u0017J>\u0010I\u001a\b\u0012\u0004\u0012\u00020F0+2\b\b\u0001\u0010J\u001a\u00020K2\b\b\u0001\u0010L\u001a\u00020\u00132\u000e\b\u0001\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00130,2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J>\u0010N\u001a\b\u0012\u0004\u0012\u00020F0+2\b\b\u0001\u0010J\u001a\u00020O2\b\b\u0001\u0010L\u001a\u00020\u00132\u000e\b\u0001\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00130,2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u0018\u0010P\u001a\b\u0012\u0004\u0012\u00020F0+2\b\b\u0001\u0010:\u001a\u00020\u0013H\u0017J\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u00020F0+2\b\b\u0001\u0010:\u001a\u00020\u0013H\u0017J(\u0010R\u001a\u0002092\b\b\u0001\u0010:\u001a\u00020\u00132\b\b\u0001\u0010S\u001a\u00020A2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J(\u0010T\u001a\u0002092\b\b\u0001\u0010:\u001a\u00020\u00132\b\b\u0001\u0010S\u001a\u00020A2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017JJ\u0010U\u001a\b\u0012\u0004\u0012\u00020F0+2\n\b\u0001\u0010G\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010:\u001a\u00020\u00132\b\b\u0001\u0010V\u001a\u00020W2\u000e\b\u0001\u00102\u001a\b\u0012\u0004\u0012\u00020\u00130,2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006X"}, d2={"Ledu/wgu/osmt/collection/CollectionController;", "Ledu/wgu/osmt/HasAllPaginated;", "Ledu/wgu/osmt/collection/CollectionDoc;", "collectionRepository", "Ledu/wgu/osmt/collection/CollectionRepository;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "auditLogRepository", "Ledu/wgu/osmt/auditlog/AuditLogRepository;", "collectionEsRepo", "Ledu/wgu/osmt/collection/CollectionEsRepo;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "oAuthHelper", "Ledu/wgu/osmt/security/OAuthHelper;", "(Ledu/wgu/osmt/collection/CollectionRepository;Ledu/wgu/osmt/richskill/RichSkillRepository;Ledu/wgu/osmt/task/TaskMessageService;Ledu/wgu/osmt/auditlog/AuditLogRepository;Ledu/wgu/osmt/collection/CollectionEsRepo;Ledu/wgu/osmt/config/AppConfig;Ledu/wgu/osmt/security/OAuthHelper;)V", "allPaginatedPath", "", "getAllPaginatedPath", "()Ljava/lang/String;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getAuditLogRepository", "()Ledu/wgu/osmt/auditlog/AuditLogRepository;", "getCollectionEsRepo", "()Ledu/wgu/osmt/collection/CollectionEsRepo;", "getCollectionRepository", "()Ledu/wgu/osmt/collection/CollectionRepository;", "elasticRepository", "getElasticRepository", "getOAuthHelper", "()Ledu/wgu/osmt/security/OAuthHelper;", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "sortOrderCompanion", "Ledu/wgu/osmt/api/model/CollectionSortEnum$Companion;", "getSortOrderCompanion", "()Ledu/wgu/osmt/api/model/CollectionSortEnum$Companion;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "allPaginated", "Lorg/springframework/http/HttpEntity;", "", "uriComponentsBuilder", "Lorg/springframework/web/util/UriComponentsBuilder;", "size", "", "from", "status", "", "sort", "user", "Lorg/springframework/security/oauth2/jwt/Jwt;", "(Lorg/springframework/web/util/UriComponentsBuilder;II[Ljava/lang/String;Ljava/lang/String;Lorg/springframework/security/oauth2/jwt/Jwt;)Lorg/springframework/http/HttpEntity;", "byUUID", "Ledu/wgu/osmt/api/model/ApiCollection;", "uuid", "byUUIDHtmlView", "byUUIDV2", "collectionAuditLog", "Ledu/wgu/osmt/auditlog/AuditLog;", "createCollections", "apiCollectionUpdates", "Ledu/wgu/osmt/api/model/ApiCollectionUpdate;", "createCollectionsV2", "getOrCreateWorkspace", "getOrCreateWorkspaceV2", "getSkillsForCollectionCsv", "Ledu/wgu/osmt/task/TaskResult;", "apiVersion", "getSkillsForCollectionXlsx", "publishCollections", "search", "Ledu/wgu/osmt/api/model/ApiSearch;", "newStatus", "filterByStatus", "publishCollectionsV2", "Ledu/wgu/osmt/api/model/ApiSearchV2;", "removeCollection", "removeCollectionV2", "updateCollection", "apiUpdate", "updateCollectionV2", "updateSkills", "skillListUpdate", "Ledu/wgu/osmt/api/model/ApiSkillListUpdate;", "osmt-api"})
public class CollectionController
implements HasAllPaginated<CollectionDoc> {
    @NotNull
    private final CollectionRepository collectionRepository;
    @NotNull
    private final RichSkillRepository richSkillRepository;
    @NotNull
    private final TaskMessageService taskMessageService;
    @NotNull
    private final AuditLogRepository auditLogRepository;
    @NotNull
    private final CollectionEsRepo collectionEsRepo;
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final OAuthHelper oAuthHelper;
    @NotNull
    private final CollectionEsRepo elasticRepository;
    @NotNull
    private final String allPaginatedPath;
    @NotNull
    private final CollectionSortEnum.Companion sortOrderCompanion;

    @Autowired
    public CollectionController(@NotNull CollectionRepository collectionRepository, @NotNull RichSkillRepository richSkillRepository, @NotNull TaskMessageService taskMessageService, @NotNull AuditLogRepository auditLogRepository, @NotNull CollectionEsRepo collectionEsRepo, @NotNull AppConfig appConfig, @NotNull OAuthHelper oAuthHelper) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"richSkillRepository");
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"taskMessageService");
        Intrinsics.checkNotNullParameter((Object)auditLogRepository, (String)"auditLogRepository");
        Intrinsics.checkNotNullParameter((Object)collectionEsRepo, (String)"collectionEsRepo");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)oAuthHelper, (String)"oAuthHelper");
        this.collectionRepository = collectionRepository;
        this.richSkillRepository = richSkillRepository;
        this.taskMessageService = taskMessageService;
        this.auditLogRepository = auditLogRepository;
        this.collectionEsRepo = collectionEsRepo;
        this.appConfig = appConfig;
        this.oAuthHelper = oAuthHelper;
        this.elasticRepository = this.getCollectionEsRepo();
        this.allPaginatedPath = "/v3/collections";
        this.sortOrderCompanion = CollectionSortEnum.Companion;
    }

    @NotNull
    public CollectionRepository getCollectionRepository() {
        return this.collectionRepository;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        return this.richSkillRepository;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        return this.taskMessageService;
    }

    @NotNull
    public AuditLogRepository getAuditLogRepository() {
        return this.auditLogRepository;
    }

    @NotNull
    public CollectionEsRepo getCollectionEsRepo() {
        return this.collectionEsRepo;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public OAuthHelper getOAuthHelper() {
        return this.oAuthHelper;
    }

    @NotNull
    public CollectionEsRepo getElasticRepository() {
        return this.elasticRepository;
    }

    @Override
    @NotNull
    public String getAllPaginatedPath() {
        return this.allPaginatedPath;
    }

    @NotNull
    public CollectionSortEnum.Companion getSortOrderCompanion() {
        return this.sortOrderCompanion;
    }

    @Override
    @GetMapping(path={"/api/v2/collections", "/api/v3/collections", "/api/collections"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<CollectionDoc>> allPaginated(@NotNull UriComponentsBuilder uriComponentsBuilder, int size, int from, @NotNull String[] status2, @Nullable String sort, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (!this.getAppConfig().getAllowPublicLists() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        return HasAllPaginated.DefaultImpls.allPaginated(this, uriComponentsBuilder, size, from, status2, sort, user);
    }

    @GetMapping(value={"/api/v3/collections/{uuid}"}, produces={"application/json"})
    @ResponseBody
    @Nullable
    public ApiCollection byUUID(@PathVariable @NotNull String uuid) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                object = this.getCollectionRepository().findByUUID(uuid);
                if (object == null) break block2;
                CollectionDao it = object;
                boolean bl = false;
                ApiCollection apiCollection = ApiCollection.Companion.fromDao(it, this.getAppConfig());
                object = apiCollection;
                if (apiCollection != null) break block3;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return object;
    }

    @GetMapping(path={"/api/v2/collections/{uuid}", "/api/collections/{uuid}"}, produces={"application/json"})
    @ResponseBody
    @Nullable
    public ApiCollection byUUIDV2(@PathVariable @NotNull String uuid) {
        CollectionDao collectionDao;
        block6: {
            block5: {
                ApiCollectionV2 apiCollectionV2;
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                collectionDao = this.getCollectionRepository().findByUUID(uuid);
                if (collectionDao == null) break block5;
                CollectionDao it = collectionDao;
                boolean bl = false;
                ApiCollection apiCollection = this.byUUID(uuid);
                if (apiCollection != null) {
                    ApiCollection ac = apiCollection;
                    boolean bl2 = false;
                    apiCollectionV2 = ApiCollectionV2.Companion.fromLatest(ac, this.getAppConfig());
                } else {
                    apiCollectionV2 = null;
                }
                collectionDao = apiCollectionV2;
                if (apiCollectionV2 != null) break block6;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return (ApiCollection)((Object)collectionDao);
    }

    @RequestMapping(path={"/api/v2/collections/{uuid}", "/api/v3/collections/{uuid}", "/api/collections/{uuid}"}, produces={"text/html"})
    @NotNull
    public String byUUIDHtmlView(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return "forward:/v3/collections/" + uuid;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/api/v3/collections"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public List<ApiCollection> createCollections(@RequestBody @NotNull List<ApiCollectionUpdate> apiCollectionUpdates, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(apiCollectionUpdates, (String)"apiCollectionUpdates");
        Iterable $this$map$iv = this.getCollectionRepository().createFromApi(apiCollectionUpdates, this.getRichSkillRepository(), OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), OAuthHelper.readableUserIdentifier$default(this.getOAuthHelper(), user, null, 2, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CollectionDao collectionDao = (CollectionDao)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiCollection.Companion.fromDao((CollectionDao)it, this.getAppConfig()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(path={"/api/v2/collections", "/api/collections"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public List<ApiCollection> createCollectionsV2(@RequestBody @NotNull List<ApiCollectionUpdate> apiCollectionUpdates, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(apiCollectionUpdates, (String)"apiCollectionUpdates");
        Iterable $this$map$iv = this.createCollections(apiCollectionUpdates, user);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ApiCollection apiCollection = (ApiCollection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiCollectionV2.Companion.fromLatest((ApiCollection)it, this.getAppConfig()));
        }
        return (List)destination$iv$iv;
    }

    @PostMapping(value={"/api/v3/collections/{uuid}/update"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public ApiCollection updateCollection(@PathVariable @NotNull String uuid, @RequestBody @NotNull ApiCollectionUpdate apiUpdate, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)apiUpdate, (String)"apiUpdate");
        if (this.getOAuthHelper().hasRole(this.getAppConfig().getRoleCurator()) && !this.getOAuthHelper().isArchiveRelated(apiUpdate.getPublishStatus())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        CollectionDao collectionDao = this.getCollectionRepository().findByUUID(uuid);
        if (collectionDao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        CollectionDao existing = collectionDao;
        CollectionDao collectionDao2 = this.getCollectionRepository().updateFromApi(((Number)((Object)existing.getId().getValue())).longValue(), apiUpdate, this.getRichSkillRepository(), OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null));
        if (collectionDao2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        CollectionDao updated = collectionDao2;
        return ApiCollection.Companion.fromDao(updated, this.getAppConfig());
    }

    @PostMapping(path={"/api/v2/collections/{uuid}/update", "/api/collections/{uuid}/update"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public ApiCollection updateCollectionV2(@PathVariable @NotNull String uuid, @RequestBody @NotNull ApiCollectionUpdate apiUpdate, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)apiUpdate, (String)"apiUpdate");
        return ApiCollectionV2.Companion.fromLatest(this.updateCollection(uuid, apiUpdate, user), this.getAppConfig());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(path={"/api/{apiVersion}/collections/{uuid}/updateSkills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> updateSkills(@PathVariable(name="apiVersion", required=false) @Nullable String apiVersion, @PathVariable @NotNull String uuid, @RequestBody @NotNull ApiSkillListUpdate skillListUpdate, @RequestParam(required=false, defaultValue="draft,published") @NotNull List<String> status2, @AuthenticationPrincipal @Nullable Jwt user) {
        HttpEntity<TaskResult> httpEntity;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)skillListUpdate, (String)"skillListUpdate");
        Intrinsics.checkNotNullParameter(status2, (String)"status");
        Iterable $this$mapNotNull$iv = status2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PublishStatus it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PublishStatus.Companion.forApiValue(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set publishStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (Intrinsics.areEqual((Object)"/v3", (Object)("/" + apiVersion))) {
            task = new UpdateCollectionSkillsTask(uuid, skillListUpdate, publishStatuses, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), null, null, null, null, "/api/v3/results/batch/{uuid}", 240, null);
            this.getTaskMessageService().enqueueJob("update-collection-skills", task);
            httpEntity = Task.Companion.processingResponse(task);
        } else if (Intrinsics.areEqual((Object)"/v2", (Object)("/" + apiVersion)) || Intrinsics.areEqual((Object)"", (Object)apiVersion)) {
            task = new UpdateCollectionSkillsTask(uuid, skillListUpdate, publishStatuses, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), null, null, null, null, "/api/v2/results/batch/{uuid}", 240, null);
            this.getTaskMessageService().enqueueJob("update-collection-skills", task);
            httpEntity = Task.Companion.processingResponse(task);
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return httpEntity;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(path={"/api/v3/collections/publish"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> publishCollections(@RequestBody @NotNull ApiSearch search, @RequestParam(required=false, defaultValue="Published") @NotNull String newStatus, @RequestParam(required=false, defaultValue="draft,published") @NotNull List<String> filterByStatus, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        Intrinsics.checkNotNullParameter(filterByStatus, (String)"filterByStatus");
        Iterable $this$mapNotNull$iv = filterByStatus;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PublishStatus it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PublishStatus.Companion.forApiValue(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filterStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        PublishStatus publishStatus = PublishStatus.Companion.forApiValue(newStatus);
        if (publishStatus == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        PublishStatus publishStatus2 = publishStatus;
        PublishTask task = new PublishTask(AppliesToType.Collection, search, filterStatuses, publishStatus2, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), null, null, null, null, null, 992, null);
        this.getTaskMessageService().enqueueJob("batch-publish-skills", task);
        return Task.Companion.processingResponse(task);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(path={"/api/v2/collections/publish", "/api/collections/publish"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> publishCollectionsV2(@RequestBody @NotNull ApiSearchV2 search, @RequestParam(required=false, defaultValue="Published") @NotNull String newStatus, @RequestParam(required=false, defaultValue="draft,published") @NotNull List<String> filterByStatus, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        Intrinsics.checkNotNullParameter(filterByStatus, (String)"filterByStatus");
        Iterable $this$mapNotNull$iv = filterByStatus;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PublishStatus it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PublishStatus.Companion.forApiValue(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filterStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        PublishStatus publishStatus = PublishStatus.Companion.forApiValue(newStatus);
        if (publishStatus == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        PublishStatus publishStatus2 = publishStatus;
        PublishTaskV2 task = new PublishTaskV2(AppliesToType.Collection, search, filterStatuses, publishStatus2, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), null, null, null, null, null, 992, null);
        this.getTaskMessageService().enqueueJob("batch-publish-skills", task);
        return Task.Companion.processingResponse(task);
    }

    @GetMapping(path={"/api/{apiVersion}/collections/{uuid}/csv"}, produces={"application/json"})
    @NotNull
    public HttpEntity<TaskResult> getSkillsForCollectionCsv(@PathVariable(name="apiVersion", required=false) @Nullable String apiVersion, @PathVariable @NotNull String uuid) {
        HttpEntity<TaskResult> httpEntity;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CollectionDao collectionDao = this.getCollectionRepository().findByUUID(uuid);
        Intrinsics.checkNotNull((Object)collectionDao);
        if (collectionDao.getStatus() == PublishStatus.Draft && !this.getOAuthHelper().hasRole(this.getAppConfig().getRoleAdmin())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        if (Intrinsics.areEqual((Object)"/v3", (Object)("/" + apiVersion))) {
            CsvTask task = new CsvTask(uuid, null, null, null, null, 30, null);
            this.getTaskMessageService().enqueueJob("collection-skills-csv-process", task);
            httpEntity = Task.Companion.processingResponse(task);
        } else if (Intrinsics.areEqual((Object)"/v2", (Object)("/" + apiVersion)) || Intrinsics.areEqual((Object)"", (Object)apiVersion)) {
            CsvTaskV2 task = new CsvTaskV2(uuid, null, null, null, null, 30, null);
            this.getTaskMessageService().enqueueJob("collection-skills-csv-process-v2", task);
            httpEntity = Task.Companion.processingResponse(task);
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return httpEntity;
    }

    @GetMapping(value={"/api/v3/collections/{uuid}/xlsx"}, produces={"application/octet-stream"})
    @NotNull
    public HttpEntity<TaskResult> getSkillsForCollectionXlsx(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CollectionDao collectionDao = this.getCollectionRepository().findByUUID(uuid);
        Intrinsics.checkNotNull((Object)collectionDao);
        if (collectionDao.getStatus() == PublishStatus.Draft && !this.getOAuthHelper().hasRole(this.getAppConfig().getRoleAdmin())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        XlsxTask task = new XlsxTask(uuid, null, null, null, null, 30, null);
        this.getTaskMessageService().enqueueJob("collection-skills-xlsx-process", task);
        return Task.Companion.processingResponse(task);
    }

    @DeleteMapping(path={"/api/v3/collections/{uuid}/remove"}, produces={"application/json"})
    @NotNull
    public HttpEntity<TaskResult> removeCollection(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        RemoveCollectionSkillsTask task = new RemoveCollectionSkillsTask(uuid, null, null, null, null, "/api/v3/results/batch/{uuid}", 30, null);
        this.getTaskMessageService().enqueueJob("remove-collection", task);
        return Task.Companion.processingResponse(task);
    }

    @DeleteMapping(path={"/api/v2/collections/{uuid}/remove", "/api/collections/{uuid}/remove"}, produces={"application/json"})
    @NotNull
    public HttpEntity<TaskResult> removeCollectionV2(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        RemoveCollectionSkillsTask task = new RemoveCollectionSkillsTask(uuid, null, null, null, null, "/api/v2/results/batch/{uuid}", 30, null);
        this.getTaskMessageService().enqueueJob("remove-collection", task);
        return Task.Companion.processingResponse(task);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"/api/v2/collections/{uuid}/log", "/api/v3/collections/{uuid}/log", "/api/collections/{uuid}/log"}, produces={"application/json"})
    @NotNull
    public HttpEntity<List<AuditLog>> collectionAuditLog(@PathVariable @NotNull String uuid) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        OffsetPageable pageable = new OffsetPageable(0, Integer.MAX_VALUE, ((AuditLogSortEnum)SortOrderCompanion.DefaultImpls.forValueOrDefault$default(AuditLogSortEnum.Companion, AuditLogSortEnum.DateDesc.getApiValue(), null, 2, null)).getSort());
        CollectionDao collectionDao = this.getCollectionRepository().findByUUID(uuid);
        if (collectionDao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Collection with id " + uuid + " not ready or not found");
        }
        CollectionDao collection = collectionDao;
        SizedIterable<AuditLogDao> sizedIterable = this.getAuditLogRepository().findByTableAndId(CollectionTable.INSTANCE.getTableName(), ((Number)((Object)collection.getId().getValue())).longValue(), pageable);
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)sizedIterable));
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((int)200);
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AuditLogDao auditLogDao = (AuditLogDao)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.toModel());
        }
        ResponseEntity responseEntity = bodyBuilder.body((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).body(sizedIt\u2026t().map { it.toModel() })");
        return (HttpEntity)responseEntity;
    }

    /*
     * Enabled aggressive block sorting
     */
    @GetMapping(path={"/api/v3/workspace"}, produces={"application/json"})
    @ResponseBody
    @Nullable
    public ApiCollection getOrCreateWorkspace(@AuthenticationPrincipal @Nullable Jwt user) {
        ApiCollection apiCollection;
        CollectionDao collectionDao = this.getCollectionRepository().findByOwner(OAuthHelper.readableUserIdentifier$default(this.getOAuthHelper(), user, null, 2, null));
        if (collectionDao != null) {
            CollectionDao it = collectionDao;
            boolean bl = false;
            ApiCollection apiCollection2 = ApiCollection.Companion.fromDao(it, this.getAppConfig());
            if (apiCollection2 != null) {
                apiCollection = apiCollection2;
                return apiCollection;
            }
        }
        CollectionDao collectionDao2 = (CollectionDao)CollectionsKt.firstOrNull(this.getCollectionRepository().createFromApi(CollectionsKt.listOf((Object)new ApiCollectionUpdate("My Workspace", null, PublishStatus.Workspace, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), new ApiStringListUpdate(null, null, 3, null), 2, null)), this.getRichSkillRepository(), OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), OAuthHelper.readableUserIdentifier$default(this.getOAuthHelper(), user, null, 2, null)));
        if (collectionDao2 == null) return null;
        CollectionDao it = collectionDao2;
        boolean bl = false;
        apiCollection = ApiCollection.Companion.fromDao(it, this.getAppConfig());
        return apiCollection;
    }

    @GetMapping(path={"/api/v2/workspace", "/api/workspace"}, produces={"application/json"})
    @ResponseBody
    @Nullable
    public ApiCollection getOrCreateWorkspaceV2(@AuthenticationPrincipal @Nullable Jwt user) {
        ApiCollectionV2 apiCollectionV2;
        ApiCollection apiCollection = this.getOrCreateWorkspace(user);
        if (apiCollection != null) {
            ApiCollection it = apiCollection;
            boolean bl = false;
            apiCollectionV2 = ApiCollectionV2.Companion.fromLatest(it, this.getAppConfig());
        } else {
            apiCollectionV2 = null;
        }
        return apiCollectionV2;
    }
}

