/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.collection;

import edu.wgu.osmt.api.FormValidationException;
import edu.wgu.osmt.api.model.ApiBatchResult;
import edu.wgu.osmt.api.model.ApiCollectionUpdate;
import edu.wgu.osmt.api.model.ApiFieldError;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.api.model.ApiStringListUpdate;
import edu.wgu.osmt.auditlog.AuditLog;
import edu.wgu.osmt.auditlog.AuditLogRepository;
import edu.wgu.osmt.auditlog.AuditOperationType;
import edu.wgu.osmt.auditlog.Change;
import edu.wgu.osmt.collection.Collection;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.collection.CollectionDoc;
import edu.wgu.osmt.collection.CollectionEsRepo;
import edu.wgu.osmt.collection.CollectionKt;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.collection.CollectionSkills;
import edu.wgu.osmt.collection.CollectionTable;
import edu.wgu.osmt.collection.CollectionUpdateObject;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.ListFieldUpdate;
import edu.wgu.osmt.db.NullableFieldUpdate;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.keyword.KeywordDao;
import edu.wgu.osmt.keyword.KeywordRepository;
import edu.wgu.osmt.keyword.KeywordTypeEnum;
import edu.wgu.osmt.richskill.CustomRichSkillQueries;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillDescriptorKt;
import edu.wgu.osmt.richskill.RichSkillDescriptorTable;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.task.PublishTask;
import edu.wgu.osmt.task.UpdateCollectionSkillsTask;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\"\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020*2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0016J,\u0010/\u001a\u0004\u0018\u0001002\u0006\u00105\u001a\u0002032\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\b\u00106\u001a\u0004\u0018\u000103H\u0016J4\u00107\u001a\b\u0012\u0004\u0012\u000200082\f\u00109\u001a\b\u0012\u0004\u0012\u00020,082\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u0002000;H\u0016J\u0012\u0010<\u001a\u0004\u0018\u0001002\u0006\u0010=\u001a\u00020>H\u0016J\u0012\u0010?\u001a\u0004\u0018\u0001002\u0006\u00105\u001a\u000203H\u0016J\u0012\u0010@\u001a\u0004\u0018\u0001002\u0006\u0010A\u001a\u000203H\u0016J\u0012\u0010B\u001a\u0004\u0018\u0001002\u0006\u0010C\u001a\u000203H\u0016J\u0010\u0010D\u001a\u00020&2\u0006\u0010C\u001a\u000203H\u0016J\u001a\u0010E\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020*2\u0006\u00102\u001a\u000203H\u0016J*\u0010F\u001a\u0004\u0018\u0001002\u0006\u0010G\u001a\u00020>2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0016J \u0010H\u001a\u00020&2\u0006\u0010I\u001a\u0002032\u0006\u0010J\u001a\u00020K2\u0006\u0010-\u001a\u00020.H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u001a8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006L"}, d2={"Ledu/wgu/osmt/collection/CollectionRepositoryImpl;", "Ledu/wgu/osmt/collection/CollectionRepository;", "auditLogRepository", "Ledu/wgu/osmt/auditlog/AuditLogRepository;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "collectionEsRepo", "Ledu/wgu/osmt/collection/CollectionEsRepo;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/auditlog/AuditLogRepository;Ledu/wgu/osmt/richskill/RichSkillEsRepo;Ledu/wgu/osmt/collection/CollectionEsRepo;Ledu/wgu/osmt/config/AppConfig;)V", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getAuditLogRepository", "()Ledu/wgu/osmt/auditlog/AuditLogRepository;", "getCollectionEsRepo", "()Ledu/wgu/osmt/collection/CollectionEsRepo;", "collectionSkillsTable", "Ledu/wgu/osmt/collection/CollectionSkills;", "getCollectionSkillsTable", "()Ledu/wgu/osmt/collection/CollectionSkills;", "dao", "Ledu/wgu/osmt/collection/CollectionDao$Companion;", "getDao", "()Ledu/wgu/osmt/collection/CollectionDao$Companion;", "keywordRepository", "Ledu/wgu/osmt/keyword/KeywordRepository;", "getKeywordRepository", "()Ledu/wgu/osmt/keyword/KeywordRepository;", "setKeywordRepository", "(Ledu/wgu/osmt/keyword/KeywordRepository;)V", "getRichSkillEsRepo", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "table", "Ledu/wgu/osmt/collection/CollectionTable;", "getTable", "()Ledu/wgu/osmt/collection/CollectionTable;", "changeStatusesForTask", "Ledu/wgu/osmt/api/model/ApiBatchResult;", "publishTask", "Ledu/wgu/osmt/task/PublishTask;", "collectionUpdateObjectFromApi", "Ledu/wgu/osmt/collection/CollectionUpdateObject;", "collectionUpdate", "Ledu/wgu/osmt/api/model/ApiCollectionUpdate;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "create", "Ledu/wgu/osmt/collection/CollectionDao;", "updateObject", "user", "", "email", "name", "description", "createFromApi", "", "apiUpdates", "findAll", "Lorg/jetbrains/exposed/sql/SizedIterable;", "findById", "id", "", "findByName", "findByOwner", "owner", "findByUUID", "uuid", "remove", "update", "updateFromApi", "existingCollectionId", "updateSkillsForTask", "collectionUuid", "task", "Ledu/wgu/osmt/task/UpdateCollectionSkillsTask;", "osmt-api"})
public class CollectionRepositoryImpl
implements CollectionRepository {
    @NotNull
    private final AuditLogRepository auditLogRepository;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final CollectionEsRepo collectionEsRepo;
    @NotNull
    private final AppConfig appConfig;
    @Autowired
    @Lazy
    public KeywordRepository keywordRepository;
    @NotNull
    private final CollectionTable table;
    @NotNull
    private final CollectionDao.Companion dao;
    @NotNull
    private final CollectionSkills collectionSkillsTable;

    @Autowired
    public CollectionRepositoryImpl(@NotNull AuditLogRepository auditLogRepository, @NotNull RichSkillEsRepo richSkillEsRepo, @NotNull CollectionEsRepo collectionEsRepo, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)auditLogRepository, (String)"auditLogRepository");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        Intrinsics.checkNotNullParameter((Object)collectionEsRepo, (String)"collectionEsRepo");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.auditLogRepository = auditLogRepository;
        this.richSkillEsRepo = richSkillEsRepo;
        this.collectionEsRepo = collectionEsRepo;
        this.appConfig = appConfig;
        this.table = CollectionTable.INSTANCE;
        this.dao = CollectionDao.Companion;
        this.collectionSkillsTable = CollectionSkills.INSTANCE;
    }

    @NotNull
    public AuditLogRepository getAuditLogRepository() {
        return this.auditLogRepository;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public CollectionEsRepo getCollectionEsRepo() {
        return this.collectionEsRepo;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public KeywordRepository getKeywordRepository() {
        KeywordRepository keywordRepository = this.keywordRepository;
        if (keywordRepository != null) {
            return keywordRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keywordRepository");
        return null;
    }

    public void setKeywordRepository(@NotNull KeywordRepository keywordRepository) {
        Intrinsics.checkNotNullParameter((Object)keywordRepository, (String)"<set-?>");
        this.keywordRepository = keywordRepository;
    }

    @Override
    @NotNull
    public CollectionTable getTable() {
        return this.table;
    }

    @Override
    @NotNull
    public CollectionDao.Companion getDao() {
        return this.dao;
    }

    @NotNull
    public CollectionSkills getCollectionSkillsTable() {
        return this.collectionSkillsTable;
    }

    @Override
    @NotNull
    public SizedIterable<CollectionDao> findAll() {
        return this.getDao().all();
    }

    @Override
    @Nullable
    public CollectionDao findById(long id) {
        return (CollectionDao)this.getDao().findById(Long.valueOf(id));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CollectionDao findByUUID(@NotNull String uuid) {
        CollectionDao collectionDao;
        void $this$findByUUID_u24lambda_u240;
        ResultRow query;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        ResultRow resultRow = query = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.select((FieldSet)fieldSet, (Op)$this$findByUUID_u24lambda_u240.eq((ExpressionWithColumnType)this.getTable().getUuid(), (Object)uuid))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl2 = false;
            collectionDao = (CollectionDao)this.getDao().wrapRow(it);
        } else {
            collectionDao = null;
        }
        return collectionDao;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CollectionDao findByName(@NotNull String name) {
        CollectionDao collectionDao;
        void $this$findByName_u24lambda_u242;
        ResultRow query;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        ResultRow resultRow = query = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.select((FieldSet)fieldSet, (Op)$this$findByName_u24lambda_u242.eq((ExpressionWithColumnType)this.getTable().getName(), (Object)name))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl2 = false;
            collectionDao = (CollectionDao)this.getDao().wrapRow(it);
        } else {
            collectionDao = null;
        }
        return collectionDao;
    }

    @Override
    @Nullable
    public CollectionDao create(@NotNull String name, @NotNull String user, @NotNull String email, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        return this.create(new CollectionUpdateObject(null, name, new NullableFieldUpdate<String>(description), null, null, null, 57, null), user, email);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CollectionDao create(@NotNull CollectionUpdateObject updateObject, @NotNull String user, @NotNull String email) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)updateObject, (String)"updateObject");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        CharSequence charSequence = updateObject.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        CollectionDao newCollection2 = (CollectionDao)this.getDao().new((Function1)new Function1<CollectionDao, Unit>(updateObject){
            final /* synthetic */ CollectionUpdateObject $updateObject;
            {
                this.$updateObject = $updateObject;
                super(1);
            }

            public final void invoke(@NotNull CollectionDao $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(ZoneOffset.UTC)");
                $this$new.setCreationDate(localDateTime);
                $this$new.setUpdateDate($this$new.getCreationDate());
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
                $this$new.setUuid(string);
                $this$new.setName(this.$updateObject.getName());
                NullableFieldUpdate<String> nullableFieldUpdate = this.$updateObject.getDescription();
                $this$new.setDescription(nullableFieldUpdate != null ? nullableFieldUpdate.getT() : null);
                NullableFieldUpdate<KeywordDao> nullableFieldUpdate2 = this.$updateObject.getAuthor();
                $this$new.setAuthor(nullableFieldUpdate2 != null ? nullableFieldUpdate2.getT() : null);
            }
        });
        CollectionUpdateObject.copy$default(updateObject, (Long)newCollection2.getId().getValue(), null, null, null, null, null, 62, null).applyToDao(newCollection2);
        if (PublishStatus.Workspace == updateObject.getPublishStatus()) {
            newCollection2.setWorkspaceOwner(email);
        }
        CollectionDao it = newCollection2;
        boolean bl = false;
        this.getCollectionEsRepo().save(CollectionDao.toDoc$default(it, false, 1, null));
        Iterable iterable = (Iterable)it.getSkills();
        RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        java.util.Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void skill;
            RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
            java.util.Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(RichSkillDoc.Companion.fromDao((RichSkillDescriptorDao)skill, this.getAppConfig()));
        }
        richSkillEsRepo.saveAll((List)destination$iv$iv);
        this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), ((Number)((Object)newCollection2.getId().getValue())).longValue(), CollectionKt.diff(newCollection2.toModel(), null), user, AuditOperationType.Insert));
        return newCollection2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CollectionDao update(@NotNull CollectionUpdateObject updateObject, @NotNull String user) {
        SizedIterable<RichSkillDescriptorDao> daoObject;
        block15: {
            void $this$mapTo$iv$iv;
            Pair pair;
            Object it;
            List<Change> list5;
            Collection it22;
            Iterable $this$map$iv;
            java.util.Collection collection;
            void $this$mapTo$iv$iv2;
            List list2;
            Intrinsics.checkNotNullParameter((Object)updateObject, (String)"updateObject");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            CollectionDao.Companion companion = this.getDao();
            Long l = updateObject.getId();
            Intrinsics.checkNotNull((Object)l);
            SizedIterable<RichSkillDescriptorDao> sizedIterable = daoObject = (SizedIterable<RichSkillDescriptorDao>)companion.findById(l);
            Collection oldObject = sizedIterable != null ? sizedIterable.toModel() : null;
            SizedIterable<RichSkillDescriptorDao> sizedIterable2 = daoObject;
            if ((sizedIterable2 != null && (sizedIterable2 = sizedIterable2.getSkills()) != null ? CollectionsKt.toList((Iterable)((Iterable)sizedIterable2)) : (list2 = null)) == null) {
                list2 = CollectionsKt.emptyList();
            }
            List currentSkillDaos = list2;
            ListFieldUpdate<RichSkillDescriptorDao> listFieldUpdate = updateObject.getSkills();
            List list3 = listFieldUpdate != null ? listFieldUpdate.getAdd() : null;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            java.util.Collection collection2 = list3;
            ListFieldUpdate<RichSkillDescriptorDao> listFieldUpdate2 = updateObject.getSkills();
            List list4 = listFieldUpdate2 != null ? listFieldUpdate2.getRemove() : null;
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            List skillDaosToTrack = CollectionsKt.distinct((Iterable)CollectionsKt.plus((java.util.Collection)CollectionsKt.plus((java.util.Collection)collection2, (Iterable)list4), (Iterable)currentSkillDaos));
            Iterable $this$map$iv2 = skillDaosToTrack;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it3.getUuid(), (Object)it3.toModel()));
            }
            Map oldSkills = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            SizedIterable<RichSkillDescriptorDao> sizedIterable3 = daoObject;
            if (sizedIterable3 != null) {
                void $this$mapTo$iv$iv3;
                Object item$iv$iv;
                SizedIterable<RichSkillDescriptorDao> it22 = sizedIterable3;
                boolean list5 = false;
                updateObject.applyToDao((CollectionDao)it22);
                this.getCollectionEsRepo().save(CollectionDao.toDoc$default(it22, false, 1, null));
                destination$iv$iv = (Iterable)it22.getSkills();
                RichSkillEsRepo $i$f$mapTo2 = this.getRichSkillEsRepo();
                boolean $i$f$map2 = false;
                item$iv$iv = $this$map$iv;
                java.util.Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    void skill;
                    RichSkillDescriptorDao richSkillDescriptorDao = (RichSkillDescriptorDao)item$iv$iv2;
                    java.util.Collection collection3 = destination$iv$iv2;
                    boolean bl = false;
                    collection3.add(RichSkillDoc.Companion.fromDao((RichSkillDescriptorDao)skill, this.getAppConfig()));
                }
                $i$f$mapTo2.saveAll((List)destination$iv$iv2);
            }
            if (daoObject != null && (it22 = daoObject.toModel()) != null && (list5 = CollectionKt.diff(it22, oldObject)) != null) {
                void $this$partition$iv;
                Iterable $i$f$mapTo2 = list5;
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    it = (Change)element$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)((Change)it).getFieldName(), (Object)"publishStatus")) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                pair = new Pair(first$iv, second$iv);
            } else {
                pair = TuplesKt.to(null, null);
            }
            Pair pair2 = pair;
            List publishStatusChanges = (List)pair2.component1();
            List otherChanges = (List)pair2.component2();
            $this$map$iv = skillDaosToTrack;
            boolean $i$f$map3 = false;
            Iterable $i$f$partition = $this$map$iv;
            java.util.Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void skillDao;
                it = (RichSkillDescriptorDao)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                RichSkillDescriptor oldSkill = (RichSkillDescriptor)oldSkills.get(skillDao.getUuid());
                List<Change> skillChange = RichSkillDescriptorKt.diff(skillDao.toModel(), oldSkill);
                if (!((java.util.Collection)skillChange).isEmpty()) {
                    this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)RichSkillDescriptorTable.INSTANCE, ((Number)((Object)skillDao.getId().getValue())).longValue(), skillChange, user, AuditOperationType.Update));
                }
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv3;
            List list6 = otherChanges;
            if (list6 != null) {
                List it4 = list6;
                boolean bl = false;
                if (!((java.util.Collection)it4).isEmpty()) {
                    this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), (long)updateObject.getId(), (List<Change>)it4, user, AuditOperationType.Update));
                }
            }
            List list7 = publishStatusChanges;
            if (list7 == null) break block15;
            List it5 = list7;
            boolean bl = false;
            if (!((java.util.Collection)it5).isEmpty()) {
                this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), (long)updateObject.getId(), (List<Change>)it5, user, AuditOperationType.PublishStatusChange));
            }
        }
        return daoObject;
    }

    @Override
    @NotNull
    public ApiBatchResult remove(@NotNull String uuid) {
        Page<CollectionDoc> esCollectionFound;
        CollectionDao collectionFound;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        CollectionDao collectionDao = collectionFound = this.findByUUID(uuid);
        if (collectionDao != null) {
            CollectionDao it = collectionDao;
            boolean bl = false;
            CollectionEsRepo collectionEsRepo = this.getCollectionEsRepo();
            String string = it.getUuid();
            PageRequest pageRequest = PageRequest.of((int)0, (int)50);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(0, PaginationDefaults.size)");
            v4 = collectionEsRepo.findByUuid(string, (Pageable)pageRequest);
        } else {
            v4 = esCollectionFound = null;
        }
        if (esCollectionFound != null) {
            List list = esCollectionFound.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"esCollectionFound.content");
            if (!((java.util.Collection)list).isEmpty()) {
                ThreadLocalTransactionManagerKt.transaction$default(null, (Function1)((Function1)new Function1<Transaction, Unit>(this, collectionFound){
                    final /* synthetic */ CollectionRepositoryImpl this$0;
                    final /* synthetic */ CollectionDao $collectionFound;
                    {
                        this.this$0 = $receiver;
                        this.$collectionFound = $collectionFound;
                        super(1);
                    }

                    public final void invoke(@NotNull Transaction $this$transaction) {
                        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
                        QueriesKt.deleteWhere$default((Table)((Table)this.this$0.getTable()), null, null, (Function1)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(this.this$0, this.$collectionFound){
                            final /* synthetic */ CollectionRepositoryImpl this$0;
                            final /* synthetic */ CollectionDao $collectionFound;
                            {
                                this.this$0 = $receiver;
                                this.$collectionFound = $collectionFound;
                                super(1);
                            }

                            @NotNull
                            public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$deleteWhere) {
                                Intrinsics.checkNotNullParameter((Object)$this$deleteWhere, (String)"$this$deleteWhere");
                                return $this$deleteWhere.eq((ExpressionWithColumnType)this.this$0.getTable().getId(), (Object)this.$collectionFound.getId());
                            }
                        }), (int)3, null);
                        this.this$0.getCollectionEsRepo().delete(CollectionDao.toDoc$default(this.$collectionFound, false, 1, null));
                    }
                }), (int)1, null);
                return new ApiBatchResult(true, null, 1, 1, 2, null);
            }
        }
        return new ApiBatchResult(false, null, 0, 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public CollectionDao findByOwner(@NotNull String owner) {
        CollectionDao collectionDao;
        void $this$findByOwner_u24lambda_u2414;
        ResultRow query;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        ResultRow resultRow = query = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.select((FieldSet)fieldSet, (Op)$this$findByOwner_u24lambda_u2414.eq((ExpressionWithColumnType)this.getTable().getWorkspaceOwner(), (Object)owner))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl2 = false;
            collectionDao = (CollectionDao)this.getDao().wrapRow(it);
        } else {
            collectionDao = null;
        }
        return collectionDao;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CollectionDao> createFromApi(@NotNull List<ApiCollectionUpdate> apiUpdates, @NotNull RichSkillRepository richSkillRepository, @NotNull String user, @NotNull String email) {
        void $this$mapTo$iv$iv;
        java.util.Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(apiUpdates, (String)"apiUpdates");
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"richSkillRepository");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Iterable $this$mapIndexed$iv = apiUpdates;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void updateDto;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ApiCollectionUpdate apiCollectionUpdate = (ApiCollectionUpdate)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(updateDto.validateForCreation((int)i));
        }
        List allErrors = CollectionsKt.flatten((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        if (!((java.util.Collection)allErrors).isEmpty()) {
            throw new FormValidationException("Invalid SkillUpdateDescriptor", allErrors);
        }
        Iterable $this$map$iv = apiUpdates;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        java.util.Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void update;
            ApiCollectionUpdate apiCollectionUpdate = (ApiCollectionUpdate)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            CollectionUpdateObject updateObject = this.collectionUpdateObjectFromApi((ApiCollectionUpdate)update, richSkillRepository);
            collection.add(this.create(updateObject, user, email));
        }
        List newSkills = (List)destination$iv$iv2;
        return CollectionsKt.filterNotNull((Iterable)newSkills);
    }

    @Override
    @Nullable
    public CollectionDao updateFromApi(long existingCollectionId, @NotNull ApiCollectionUpdate collectionUpdate, @NotNull RichSkillRepository richSkillRepository, @NotNull String user) {
        List<ApiFieldError> errors;
        Intrinsics.checkNotNullParameter((Object)collectionUpdate, (String)"collectionUpdate");
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"richSkillRepository");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        List<ApiFieldError> list = errors = collectionUpdate.validate(0);
        boolean bl = list != null ? !((java.util.Collection)list).isEmpty() : false;
        if (bl) {
            throw new FormValidationException("Invalid SkillUpdateDescriptor", errors);
        }
        CollectionUpdateObject collectionUpdateObject = this.collectionUpdateObjectFromApi(collectionUpdate, richSkillRepository);
        CollectionUpdateObject updateObjectWithId = CollectionUpdateObject.copy$default(collectionUpdateObject, existingCollectionId, null, null, null, null, collectionUpdate.getPublishStatus(), 30, null);
        return this.update(updateObjectWithId, user);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ApiBatchResult updateSkillsForTask(@NotNull String collectionUuid, @NotNull UpdateCollectionSkillsTask task, @NotNull RichSkillRepository richSkillRepository) {
        int totalCount;
        Ref.IntRef modifiedCount;
        block14: {
            void $this$mapTo$iv$iv;
            SearchHit hit;
            Iterable $this$forEach$iv;
            java.util.Collection searchHits;
            RichSkillDescriptorDao skillDao;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv2;
            CollectionDao collectionDao;
            Intrinsics.checkNotNullParameter((Object)collectionUuid, (String)"collectionUuid");
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"richSkillRepository");
            modifiedCount = new Ref.IntRef();
            totalCount = 0;
            CollectionDao collectionDao2 = collectionDao = this.findByUUID(collectionUuid);
            Intrinsics.checkNotNull((Object)collectionDao2);
            long collectionId = ((Number)((Object)collectionDao2.getId().getValue())).longValue();
            List modifiedSkillDaos = new ArrayList();
            Map modifiedSkillOriginals = new LinkedHashMap();
            ApiSearch apiSearch = task.getSkillListUpdate().getAdd();
            java.util.Collection collection = apiSearch != null ? apiSearch.getUuids() : null;
            if (!(collection == null || collection.isEmpty())) {
                Object object;
                Object object2 = task.getSkillListUpdate().getAdd();
                if (object2 != null && (object2 = ((ApiSearch)object2).getUuids()) != null) {
                    $this$forEach$iv2 = (Iterable)object2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        String uuid = (String)element$iv;
                        boolean bl = false;
                        skillDao = richSkillRepository.findByUUID(uuid);
                        CollectionRepositoryImpl.updateSkillsForTask$addSkillDao(modifiedSkillDaos, collectionId, this, modifiedCount, modifiedSkillOriginals, skillDao);
                    }
                }
                totalCount += (object = task.getSkillListUpdate().getAdd()) != null && (object = ((ApiSearch)object).getUuids()) != null ? object.size() : 0;
            } else if (task.getSkillListUpdate().getAdd() != null) {
                CustomRichSkillQueries customRichSkillQueries = this.getRichSkillEsRepo();
                ApiSearch apiSearch2 = task.getSkillListUpdate().getAdd();
                Set<PublishStatus> set = task.getPublishStatuses();
                Pageable pageable = Pageable.unpaged();
                Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged()");
                searchHits = CustomRichSkillQueries.DefaultImpls.byApiSearch$default(customRichSkillQueries, apiSearch2, set, pageable, null, 8, null);
                $this$forEach$iv = searchHits;
                boolean $i$f$forEach2 = false;
                for (Iterator element$iv : $this$forEach$iv) {
                    hit = (SearchHit)element$iv;
                    boolean bl = false;
                    CollectionRepositoryImpl.updateSkillsForTask$addSkillDao(modifiedSkillDaos, collectionId, this, modifiedCount, modifiedSkillOriginals, richSkillRepository.findById(((RichSkillDoc)hit.getContent()).getId()));
                }
                totalCount += (int)searchHits.getTotalHits();
            }
            ApiSearch apiSearch3 = task.getSkillListUpdate().getRemove();
            searchHits = apiSearch3 != null ? apiSearch3.getUuids() : null;
            if (!(searchHits == null || searchHits.isEmpty())) {
                Object object = task.getSkillListUpdate().getRemove();
                if (object != null && (object = ((ApiSearch)object).getUuids()) != null) {
                    $this$forEach$iv2 = (Iterable)object;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        String skillUuid = (String)element$iv;
                        boolean bl = false;
                        skillDao = richSkillRepository.findByUUID(skillUuid);
                        CollectionRepositoryImpl.updateSkillsForTask$removeSkillDao(modifiedSkillDaos, collectionId, this, modifiedCount, modifiedSkillOriginals, skillDao);
                        ++totalCount;
                    }
                }
            } else if (task.getSkillListUpdate().getRemove() != null) {
                CustomRichSkillQueries customRichSkillQueries = this.getRichSkillEsRepo();
                ApiSearch apiSearch4 = task.getSkillListUpdate().getRemove();
                Set<PublishStatus> set = task.getPublishStatuses();
                Pageable pageable = Pageable.unpaged();
                Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged()");
                searchHits = CustomRichSkillQueries.DefaultImpls.byApiSearch$default(customRichSkillQueries, apiSearch4, set, pageable, null, 8, null);
                $this$forEach$iv = searchHits;
                boolean $i$f$forEach3 = false;
                for (Iterator element$iv : $this$forEach$iv) {
                    hit = (SearchHit)element$iv;
                    boolean bl = false;
                    CollectionRepositoryImpl.updateSkillsForTask$removeSkillDao(modifiedSkillDaos, collectionId, this, modifiedCount, modifiedSkillOriginals, richSkillRepository.findById(((RichSkillDoc)hit.getContent()).getId()));
                }
                totalCount += (int)searchHits.getTotalHits();
            }
            Iterable $this$map$iv = modifiedSkillDaos;
            boolean $i$f$map = false;
            Iterable $i$f$forEach3 = $this$map$iv;
            java.util.Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void skillDao2;
                RichSkillDescriptorDao bl = (RichSkillDescriptorDao)item$iv$iv;
                java.util.Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                List<Change> changes = RichSkillDescriptorKt.diff(skillDao2.toModel(), (RichSkillDescriptor)modifiedSkillOriginals.get(skillDao2.getUuid()));
                if (!((java.util.Collection)changes).isEmpty()) {
                    this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)RichSkillDescriptorTable.INSTANCE, ((Number)((Object)skillDao2.getId().getValue())).longValue(), changes, task.getUserString(), AuditOperationType.Update));
                }
                collection2.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            CollectionDao collectionDao3 = this.findByUUID(collectionUuid);
            if (collectionDao3 == null) break block14;
            CollectionDao it = collectionDao3;
            boolean bl = false;
            CollectionDoc cfr_ignored_1 = (CollectionDoc)this.getCollectionEsRepo().save(CollectionDao.toDoc$default(it, false, 1, null));
        }
        return new ApiBatchResult(true, null, modifiedCount.element, totalCount, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CollectionUpdateObject collectionUpdateObjectFromApi(@NotNull ApiCollectionUpdate collectionUpdate, @NotNull RichSkillRepository richSkillRepository) {
        NullableFieldUpdate<KeywordDao> nullableFieldUpdate;
        NullableFieldUpdate<String> nullableFieldUpdate2;
        KeywordDao keywordDao;
        Intrinsics.checkNotNullParameter((Object)collectionUpdate, (String)"collectionUpdate");
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"richSkillRepository");
        String string = collectionUpdate.getAuthor();
        if (string != null) {
            String it = string;
            boolean bl = false;
            keywordDao = KeywordRepository.DefaultImpls.findOrCreate$default(this.getKeywordRepository(), KeywordTypeEnum.Author, it, null, null, 12, null);
        } else {
            keywordDao = null;
        }
        KeywordDao authorKeyword = keywordDao;
        List adding = new ArrayList();
        List removing = new ArrayList();
        ApiStringListUpdate apiStringListUpdate = collectionUpdate.getSkills();
        if (apiStringListUpdate != null) {
            RichSkillDescriptorDao it$iv$iv;
            boolean bl;
            String it;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterator iterator;
            boolean $i$f$forEach;
            void $this$forEach$iv$iv$iv;
            boolean $i$f$mapNotNullTo;
            java.util.Collection destination$iv$iv;
            Iterable $this$mapNotNull$iv;
            ApiStringListUpdate slu = apiStringListUpdate;
            boolean bl3 = false;
            List<String> list = slu.getAdd();
            if (list != null) {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl2 = false;
                    it = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (richSkillRepository.findByUUID(it) == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List it2 = (List)destination$iv$iv;
                boolean bl5 = false;
                adding.addAll(it2);
            }
            List<String> list2 = slu.getRemove();
            if (list2 != null) {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable bl5 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl2 = false;
                    it = (String)element$iv$iv;
                    boolean bl6 = false;
                    if (richSkillRepository.findByUUID(it) == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List it3 = (List)destination$iv$iv;
                boolean bl7 = false;
                removing.addAll(it3);
            }
        }
        String string2 = collectionUpdate.getName();
        String string3 = collectionUpdate.getDescription();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            nullableFieldUpdate2 = new NullableFieldUpdate<String>(it);
        } else {
            nullableFieldUpdate2 = null;
        }
        NullableFieldUpdate<String> nullableFieldUpdate3 = nullableFieldUpdate2;
        PublishStatus publishStatus = collectionUpdate.getPublishStatus();
        KeywordDao keywordDao2 = authorKeyword;
        if (keywordDao2 != null) {
            KeywordDao it = keywordDao2;
            boolean bl = false;
            nullableFieldUpdate = new NullableFieldUpdate<KeywordDao>(it);
        } else {
            nullableFieldUpdate = null;
        }
        NullableFieldUpdate<KeywordDao> nullableFieldUpdate4 = nullableFieldUpdate;
        ListFieldUpdate listFieldUpdate = adding.size() + removing.size() > 0 ? new ListFieldUpdate(adding, removing) : null;
        return new CollectionUpdateObject(null, string2, nullableFieldUpdate3, nullableFieldUpdate4, listFieldUpdate, publishStatus, 1, null);
    }

    @Override
    @Nullable
    public ApiBatchResult changeStatusesForTask(@NotNull PublishTask publishTask) {
        Intrinsics.checkNotNullParameter((Object)publishTask, (String)"publishTask");
        Ref.IntRef modifiedCount = new Ref.IntRef();
        int totalCount = 0;
        java.util.Collection collection = publishTask.getSearch().getUuids();
        if (!(collection == null || collection.isEmpty())) {
            totalCount = publishTask.getSearch().getUuids().size();
            Iterable $this$forEach$iv = publishTask.getSearch().getUuids();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String uuid = (String)element$iv;
                boolean bl = false;
                CollectionRepositoryImpl.changeStatusesForTask$handleCollectionDao(publishTask, modifiedCount, this, this.findByUUID(uuid));
            }
        } else {
            CollectionEsRepo collectionEsRepo = this.getCollectionEsRepo();
            ApiSearch apiSearch = publishTask.getSearch();
            Set<PublishStatus> set = publishTask.getFilterByStatus();
            Pageable pageable = Pageable.unpaged();
            Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged()");
            SearchHits searchHits = collectionEsRepo.byApiSearch(apiSearch, set, pageable);
            totalCount = (int)searchHits.getTotalHits();
            Iterable $this$forEach$iv = (Iterable)searchHits;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SearchHit hit = (SearchHit)element$iv;
                boolean bl = false;
                CollectionRepositoryImpl.changeStatusesForTask$handleCollectionDao(publishTask, modifiedCount, this, this.findById(((CollectionDoc)hit.getContent()).getId()));
            }
        }
        return new ApiBatchResult(true, null, modifiedCount.element, totalCount, 2, null);
    }

    private static final void updateSkillsForTask$addSkillDao(List<RichSkillDescriptorDao> modifiedSkillDaos, long collectionId, CollectionRepositoryImpl this$0, Ref.IntRef modifiedCount, Map<String, RichSkillDescriptor> modifiedSkillOriginals, RichSkillDescriptorDao skillDao) {
        block0: {
            boolean bl;
            RichSkillDescriptorDao richSkillDescriptorDao = skillDao;
            if (richSkillDescriptorDao == null) break block0;
            RichSkillDescriptorDao dao = richSkillDescriptorDao;
            boolean bl2 = false;
            boolean it = bl = modifiedSkillDaos.add(dao);
            boolean bl3 = false;
            modifiedSkillOriginals.put(dao.getUuid(), dao.toModel());
            CollectionSkills.INSTANCE.create(collectionId, ((Number)((Object)dao.getId().getValue())).longValue());
            this$0.getRichSkillEsRepo().save(RichSkillDoc.Companion.fromDao(dao, this$0.getAppConfig()));
            ++modifiedCount.element;
        }
    }

    private static final void updateSkillsForTask$removeSkillDao(List<RichSkillDescriptorDao> modifiedSkillDaos, long collectionId, CollectionRepositoryImpl this$0, Ref.IntRef modifiedCount, Map<String, RichSkillDescriptor> modifiedSkillOriginals, RichSkillDescriptorDao skillDao) {
        block0: {
            boolean bl;
            RichSkillDescriptorDao richSkillDescriptorDao = skillDao;
            if (richSkillDescriptorDao == null) break block0;
            RichSkillDescriptorDao dao = richSkillDescriptorDao;
            boolean bl2 = false;
            boolean it = bl = modifiedSkillDaos.add(dao);
            boolean bl3 = false;
            modifiedSkillOriginals.put(dao.getUuid(), dao.toModel());
            CollectionSkills.INSTANCE.delete(collectionId, ((Number)((Object)dao.getId().getValue())).longValue());
            this$0.getRichSkillEsRepo().save(RichSkillDoc.Companion.fromDao(dao, this$0.getAppConfig()));
            ++modifiedCount.element;
        }
    }

    private static final boolean changeStatusesForTask$publishCollection(CollectionRepositoryImpl this$0, CollectionDao collectionDao, PublishTask task) {
        boolean bl;
        PublishStatus oldStatus = collectionDao.publishStatus();
        if (oldStatus != task.getPublishStatus()) {
            PublishStatus newStatus;
            CollectionDao updatedDao;
            CollectionUpdateObject updateObj = new CollectionUpdateObject((Long)collectionDao.getId().getValue(), null, null, null, null, task.getPublishStatus(), 30, null);
            CollectionDao collectionDao2 = updatedDao = this$0.update(updateObj, task.getUserString());
            PublishStatus publishStatus = newStatus = collectionDao2 != null ? collectionDao2.publishStatus() : null;
            bl = newStatus != oldStatus;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void changeStatusesForTask$handleCollectionDao(PublishTask $publishTask, Ref.IntRef modifiedCount, CollectionRepositoryImpl this$0, CollectionDao collectionDao) {
        block1: {
            CollectionDao collectionDao2 = collectionDao;
            if (collectionDao2 == null) break block1;
            CollectionDao it = collectionDao2;
            boolean bl = false;
            if (CollectionRepositoryImpl.changeStatusesForTask$publishCollection(this$0, it, $publishTask)) {
                ++modifiedCount.element;
            }
        }
    }
}

