/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.collection;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.collection.CollectionDoc;
import edu.wgu.osmt.collection.CustomCollectionQueries;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.elasticsearch.OsmtQueryHelper;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.erhlc.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.query.BaseQueryBuilder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0003J(\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020 H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Ledu/wgu/osmt/collection/CustomCollectionQueriesImpl;", "Ledu/wgu/osmt/collection/CustomCollectionQueries;", "elasticSearchTemplate", "Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "(Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;Ledu/wgu/osmt/richskill/RichSkillEsRepo;)V", "getElasticSearchTemplate", "()Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;", "javaClass", "Ljava/lang/Class;", "Ledu/wgu/osmt/collection/CollectionDoc;", "getJavaClass", "()Ljava/lang/Class;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "getRichSkillEsRepo", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "byApiSearch", "Lorg/springframework/data/elasticsearch/core/SearchHits;", "apiSearch", "Ledu/wgu/osmt/api/model/ApiSearch;", "publishStatus", "", "Ledu/wgu/osmt/db/PublishStatus;", "pageable", "Lorg/springframework/data/domain/Pageable;", "collectionPropertiesMultiMatch", "Lorg/elasticsearch/index/query/AbstractQueryBuilder;", "query", "", "createNestedQueryBuilder", "Lorg/elasticsearch/index/query/NestedQueryBuilder;", "getCollectionUuids", "", "filter", "Lco/elastic/clients/elasticsearch/_types/query_dsl/Query;", "collectionName", "osmt-api"})
public final class CustomCollectionQueriesImpl
implements CustomCollectionQueries {
    @NotNull
    private final ElasticsearchTemplate elasticSearchTemplate;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final Logger log;
    @NotNull
    private final Class<CollectionDoc> javaClass;

    @Autowired
    public CustomCollectionQueriesImpl(@NotNull ElasticsearchTemplate elasticSearchTemplate, @NotNull RichSkillEsRepo richSkillEsRepo) {
        Intrinsics.checkNotNullParameter((Object)elasticSearchTemplate, (String)"elasticSearchTemplate");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        this.elasticSearchTemplate = elasticSearchTemplate;
        this.richSkillEsRepo = richSkillEsRepo;
        Logger logger = LoggerFactory.getLogger(CustomCollectionQueriesImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CustomCollectionQueriesImpl::class.java)");
        this.log = logger;
        this.javaClass = CollectionDoc.class;
    }

    @Override
    @NotNull
    public ElasticsearchTemplate getElasticSearchTemplate() {
        return this.elasticSearchTemplate;
    }

    @Override
    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public Class<CollectionDoc> getJavaClass() {
        return this.javaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AbstractQueryBuilder<?> collectionPropertiesMultiMatch(@NotNull String query) {
        AbstractQueryBuilder abstractQueryBuilder;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        boolean isComplex = StringsKt.contains$default((CharSequence)query, (CharSequence)"\"", (boolean)false, (int)2, null);
        String[] stringArray = new String[]{"name.raw", "name._2gram", "name._3gram", "description.raw", "author"};
        String[] complexFields = stringArray;
        String[] stringArray2 = new String[]{"name", "name._2gram", "name._3gram", "description", "author"};
        String[] fields = stringArray2;
        if (isComplex) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String[] stringArray3 = complexFields;
            SimpleQueryStringBuilder simpleQueryStringBuilder = QueryBuilders.simpleQueryStringQuery((String)query);
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var14_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it, (Object)Float.valueOf(1.0f)));
            }
            SimpleQueryStringBuilder simpleQueryStringBuilder2 = simpleQueryStringBuilder.fields(MapsKt.toMap((Iterable)((List)destination$iv$iv))).defaultOperator(Operator.AND);
            Intrinsics.checkNotNullExpressionValue((Object)simpleQueryStringBuilder2, (String)"{\n            QueryBuild\u2026r(Operator.AND)\n        }");
            abstractQueryBuilder = (AbstractQueryBuilder)simpleQueryStringBuilder2;
        } else {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)query, (String[])Arrays.copyOf(fields, fields.length)).type(MultiMatchQueryBuilder.Type.BOOL_PREFIX);
            Intrinsics.checkNotNullExpressionValue((Object)multiMatchQueryBuilder, (String)"{\n            QueryBuild\u2026pe.BOOL_PREFIX)\n        }");
            abstractQueryBuilder = (AbstractQueryBuilder)multiMatchQueryBuilder;
        }
        return abstractQueryBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SearchHits<CollectionDoc> byApiSearch(@NotNull ApiSearch apiSearch, @NotNull Set<? extends PublishStatus> publishStatus, @NotNull Pageable pageable) {
        void $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        void $this$map$iv;
        boolean $i$f$map;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Collection<String> collection;
        void $this$mapTo$iv$iv3;
        void $this$map$iv3;
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        Intrinsics.checkNotNullParameter(publishStatus, (String)"publishStatus");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        BaseQueryBuilder baseQueryBuilder = new NativeSearchQueryBuilder().withPageable(Pageable.unpaged());
        Intrinsics.checkNotNullExpressionValue((Object)baseQueryBuilder, (String)"NativeSearchQueryBuilder\u2026eable(Pageable.unpaged())");
        NativeSearchQueryBuilder nsqb1 = (NativeSearchQueryBuilder)baseQueryBuilder;
        BoolQueryBuilder bq = QueryBuilders.boolQuery();
        Iterable iterable = publishStatus;
        String string = "publishStatus";
        Object object = OsmtQueryHelper.INSTANCE;
        boolean $i$f$map22 = false;
        void var9_11 = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void ps;
            PublishStatus publishStatus2 = (PublishStatus)((Object)item$iv$iv);
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(ps.toString());
        }
        collection = (List)destination$iv$iv2;
        Query filterDslQuery = OsmtQueryHelper.createTermsDslQuery$default((OsmtQueryHelper)object, string, (List)collection, false, 4, null);
        Iterable $i$f$map22 = publishStatus;
        string = "publishStatus";
        object = new BoolQueryBuilder();
        boolean $i$f$map32 = false;
        destination$iv$iv2 = $this$map$iv2;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void ps;
            PublishStatus bl = (PublishStatus)((Object)item$iv$iv);
            collection = destination$iv$iv3;
            boolean bl2 = false;
            collection.add(ps.toString());
        }
        collection = (List)destination$iv$iv3;
        BoolQueryBuilder filter = object.must((QueryBuilder)QueryBuilders.termsQuery((String)string, collection));
        nsqb1.withFilter((QueryBuilder)filter);
        nsqb1.withQuery((QueryBuilder)bq);
        List collectionMultiPropertyResults = CollectionsKt.emptyList();
        CharSequence $i$f$map32 = apiSearch.getQuery();
        if (!($i$f$map32 == null || StringsKt.isBlank((CharSequence)$i$f$map32))) {
            Object item$iv$iv;
            bq.should((QueryBuilder)new BoolQueryBuilder().must((QueryBuilder)this.getRichSkillEsRepo().richSkillPropertiesMultiMatch(apiSearch.getQuery())).must((QueryBuilder)this.createNestedQueryBuilder()));
            bq.should((QueryBuilder)this.getRichSkillEsRepo().occupationQueries(apiSearch.getQuery()));
            NativeSearchQueryBuilder nativeSearchQueryBuilder = ((NativeSearchQueryBuilder)new NativeSearchQueryBuilder().withQuery((QueryBuilder)this.collectionPropertiesMultiMatch(apiSearch.getQuery())).withPageable(Pageable.unpaged())).withFilter((QueryBuilder)filter);
            Intrinsics.checkNotNullExpressionValue((Object)nativeSearchQueryBuilder, (String)"NativeSearchQueryBuilder\u2026      .withFilter(filter)");
            nsqb2 = nativeSearchQueryBuilder;
            Pageable pageable2 = Pageable.unpaged();
            Intrinsics.checkNotNullExpressionValue((Object)pageable2, (String)"unpaged()");
            org.springframework.data.elasticsearch.core.query.Query query = OsmtQueryHelper.INSTANCE.convertToNativeQuery(pageable2, filterDslQuery, (NativeSearchQueryBuilder)nsqb2, "CustomCollectionQueriesImpl.byApiSearch()1", this.log);
            List list = this.getElasticSearchTemplate().search(query, CollectionDoc.class).getSearchHits();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"elasticSearchTemplate\n  \u2026              .searchHits");
            destination$iv$iv3 = list;
            $i$f$map = false;
            item$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                SearchHit searchHit = (SearchHit)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(((CollectionDoc)it.getContent()).getUuid());
            }
            collectionMultiPropertyResults = (List)destination$iv$iv;
        } else if (apiSearch.getAdvanced() != null) {
            RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
            Intrinsics.checkNotNullExpressionValue((Object)bq, (String)"bq");
            richSkillEsRepo.generateBoolQueriesFromApiSearch(bq, apiSearch.getAdvanced());
            nsqb2 = apiSearch.getAdvanced().getCollectionName();
            if (!(nsqb2 == null || StringsKt.isBlank((CharSequence)nsqb2))) {
                collectionMultiPropertyResults = this.getCollectionUuids(pageable, filterDslQuery, apiSearch.getAdvanced().getCollectionName());
            } else {
                bq.must((QueryBuilder)this.createNestedQueryBuilder());
            }
        } else {
            bq.must((QueryBuilder)this.createNestedQueryBuilder());
        }
        Pageable pageable3 = Pageable.unpaged();
        Intrinsics.checkNotNullExpressionValue((Object)pageable3, (String)"unpaged()");
        org.springframework.data.elasticsearch.core.query.Query query = OsmtQueryHelper.INSTANCE.convertToNativeQuery(pageable3, filterDslQuery, nsqb1, "CustomCollectionQueriesImpl.byApiSearch().innerHitCollectionUuids", this.log);
        List list = this.getElasticSearchTemplate().search(query, RichSkillDoc.class).getSearchHits();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"elasticSearchTemplate\n  \u2026              .searchHits");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            List list2;
            List list3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            SearchHit it2 = (SearchHit)element$iv$iv;
            boolean bl3 = false;
            Object object2 = it2.getInnerHits("collections");
            if (object2 != null && (object2 = (list3 = object2.getSearchHits())) != null) {
                void $this$mapNotNullTo$iv$iv2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"searchHits");
                Iterable $this$mapNotNull$iv2 = list3;
                boolean $i$f$mapNotNull2 = false;
                Iterable iterable2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    CollectionDoc it$iv$iv;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    SearchHit it3 = (SearchHit)element$iv$iv2;
                    boolean bl4 = false;
                    Object object3 = it3.getContent();
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type edu.wgu.osmt.collection.CollectionDoc");
                    if ((CollectionDoc)object3 == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv4;
            } else {
                list2 = null;
            }
            if (list2 == null) continue;
            List it$iv$iv = list2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CollectionDoc)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((CollectionDoc)it).getUuid());
        }
        List innerHitCollectionUuids = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return this.getCollectionFromUuids(pageable, filterDslQuery, CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)innerHitCollectionUuids, (Iterable)collectionMultiPropertyResults)), "CustomCollectionQueriesImpl.byApiSearch()2", this.log);
    }

    @Deprecated(message="Upgrade to ES v8.x queries", replaceWith=@ReplaceWith(expression="createNestQueryDslQuery", imports={}), level=DeprecationLevel.WARNING)
    private final NestedQueryBuilder createNestedQueryBuilder() {
        NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery((String)"collections", (QueryBuilder)((QueryBuilder)QueryBuilders.matchAllQuery()), (ScoreMode)ScoreMode.Avg).innerHit(new InnerHitBuilder());
        Intrinsics.checkNotNullExpressionValue((Object)nestedQueryBuilder, (String)"nestedQuery(\n           \u2026nerHit(InnerHitBuilder())");
        return nestedQueryBuilder;
    }

    private final List<String> getCollectionUuids(Pageable pageable, Query filter, String collectionName) {
        return StringsKt.contains$default((CharSequence)collectionName, (CharSequence)"\"", (boolean)false, (int)2, null) ? this.getCollectionUuidsFromComplexName(pageable, filter, collectionName, "getCollectionUuids", this.log) : this.getCollectionUuidsFromName(pageable, filter, collectionName, "getCollectionUuids", this.log);
    }

    @Override
    public void deleteIndex() {
        CustomCollectionQueries.DefaultImpls.deleteIndex(this);
    }

    @Override
    @NotNull
    public SearchHits<CollectionDoc> findAllFilteredByPublishStatus(@NotNull Set<? extends PublishStatus> publishStatus, @NotNull Pageable pageable) {
        return CustomCollectionQueries.DefaultImpls.findAllFilteredByPublishStatus(this, publishStatus, pageable);
    }

    @Override
    public long countAllFilteredByPublishStatus(@NotNull Set<? extends PublishStatus> publishStatus, @NotNull Pageable pageable) {
        return CustomCollectionQueries.DefaultImpls.countAllFilteredByPublishStatus(this, publishStatus, pageable);
    }

    @Override
    @NotNull
    public NativeQuery createMatchAllRichSkillNativeQuery(@NotNull Pageable pageable, @NotNull Set<? extends PublishStatus> publishStatus) {
        return CustomCollectionQueries.DefaultImpls.createMatchAllRichSkillNativeQuery(this, pageable, publishStatus);
    }

    @Override
    @NotNull
    public List<String> getCollectionUuidsFromComplexName(@NotNull Pageable pageable, @Nullable Query dslFilter, @NotNull String collectionName, @NotNull String msgPrefix, @NotNull Logger log) {
        return CustomCollectionQueries.DefaultImpls.getCollectionUuidsFromComplexName(this, pageable, dslFilter, collectionName, msgPrefix, log);
    }

    @Override
    @NotNull
    public List<String> getCollectionUuidsFromName(@NotNull Pageable pageable, @Nullable Query dslFilter, @NotNull String collectionName, @NotNull String msgPrefix, @NotNull Logger log) {
        return CustomCollectionQueries.DefaultImpls.getCollectionUuidsFromName(this, pageable, dslFilter, collectionName, msgPrefix, log);
    }

    @Override
    @NotNull
    public SearchHits<CollectionDoc> getCollectionFromUuids(@NotNull Pageable pageable, @Nullable Query dslFilter, @NotNull List<String> uuids, @NotNull String msgPrefix, @NotNull Logger log) {
        return CustomCollectionQueries.DefaultImpls.getCollectionFromUuids(this, pageable, dslFilter, uuids, msgPrefix, log);
    }
}

