/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.collection;

import com.github.sonus21.rqueue.annotation.RqueueListener;
import edu.wgu.osmt.api.model.ApiBatchResult;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.task.RemoveCollectionSkillsTask;
import edu.wgu.osmt.task.TaskMessageService;
import edu.wgu.osmt.task.TaskStatus;
import edu.wgu.osmt.task.UpdateCollectionSkillsTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Profile(value={"apiserver"})
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001eH\u0017R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u00148\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Ledu/wgu/osmt/collection/UpdateCollectionSkillsTaskProcessor;", "", "()V", "collectionRepository", "Ledu/wgu/osmt/collection/CollectionRepository;", "getCollectionRepository", "()Ledu/wgu/osmt/collection/CollectionRepository;", "setCollectionRepository", "(Ledu/wgu/osmt/collection/CollectionRepository;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "setRichSkillRepository", "(Ledu/wgu/osmt/richskill/RichSkillRepository;)V", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "setTaskMessageService", "(Ledu/wgu/osmt/task/TaskMessageService;)V", "removeCollectionSkills", "", "task", "Ledu/wgu/osmt/task/RemoveCollectionSkillsTask;", "updateCollectionSkills", "Ledu/wgu/osmt/task/UpdateCollectionSkillsTask;", "osmt-api"})
public class UpdateCollectionSkillsTaskProcessor {
    @NotNull
    private final Logger logger;
    @Autowired
    public TaskMessageService taskMessageService;
    @Autowired
    public RichSkillRepository richSkillRepository;
    @Autowired
    public CollectionRepository collectionRepository;

    public UpdateCollectionSkillsTaskProcessor() {
        Logger logger = LoggerFactory.getLogger(UpdateCollectionSkillsTaskProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(UpdateCollecti\u2026askProcessor::class.java)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        TaskMessageService taskMessageService = this.taskMessageService;
        if (taskMessageService != null) {
            return taskMessageService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"taskMessageService");
        return null;
    }

    public void setTaskMessageService(@NotNull TaskMessageService taskMessageService) {
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"<set-?>");
        this.taskMessageService = taskMessageService;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        RichSkillRepository richSkillRepository = this.richSkillRepository;
        if (richSkillRepository != null) {
            return richSkillRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"richSkillRepository");
        return null;
    }

    public void setRichSkillRepository(@NotNull RichSkillRepository richSkillRepository) {
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"<set-?>");
        this.richSkillRepository = richSkillRepository;
    }

    @NotNull
    public CollectionRepository getCollectionRepository() {
        CollectionRepository collectionRepository = this.collectionRepository;
        if (collectionRepository != null) {
            return collectionRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"collectionRepository");
        return null;
    }

    public void setCollectionRepository(@NotNull CollectionRepository collectionRepository) {
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"<set-?>");
        this.collectionRepository = collectionRepository;
    }

    @RqueueListener(value={"update-collection-skills"}, deadLetterQueue="dead-letters", deadLetterQueueListenerEnabled="true", concurrency="1")
    public void updateCollectionSkills(@NotNull UpdateCollectionSkillsTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getLogger().info("Started processing update collection skills task id: " + task.getUuid());
        ApiBatchResult batchResult = this.getCollectionRepository().updateSkillsForTask(task.getCollectionUuid(), task, this.getRichSkillRepository());
        this.getTaskMessageService().publishResult(UpdateCollectionSkillsTask.copy$default(task, null, null, null, null, null, null, batchResult, TaskStatus.Ready, null, 319, null));
        this.getLogger().info("Task " + task.getUuid() + " completed");
    }

    @RqueueListener(value={"remove-collection"}, deadLetterQueue="dead-letters", deadLetterQueueListenerEnabled="true", concurrency="1")
    public void removeCollectionSkills(@NotNull RemoveCollectionSkillsTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getLogger().info("Started processing to remove collection task id: " + task.getUuid());
        ApiBatchResult batchResult = this.getCollectionRepository().remove(task.getCollectionUuid());
        this.getTaskMessageService().publishResult(RemoveCollectionSkillsTask.copy$default(task, null, null, null, batchResult, TaskStatus.Ready, null, 39, null));
        this.getLogger().info("Task " + task.getUuid() + " completed");
    }
}

