/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import edu.wgu.osmt.elasticsearch.EsConfig;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchCustomConversions;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;

@Configuration
@EnableElasticsearchRepositories(value={"edu.wgu.osmt.elasticsearch"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0012J\b\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0012R\u001e\u0010\u0003\u001a\u00020\u00048\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Ledu/wgu/osmt/elasticsearch/ElasticsearchClientManager;", "", "()V", "esConfig", "Ledu/wgu/osmt/elasticsearch/EsConfig;", "getEsConfig", "()Ledu/wgu/osmt/elasticsearch/EsConfig;", "setEsConfig", "(Ledu/wgu/osmt/elasticsearch/EsConfig;)V", "createRestClient", "Lorg/elasticsearch/client/RestClient;", "elasticSearchClient", "Lco/elastic/clients/elasticsearch/ElasticsearchClient;", "elasticSearchCustomConversions", "Lorg/springframework/data/elasticsearch/core/convert/ElasticsearchCustomConversions;", "elasticsearchTemplate", "Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;", "getCredentialsProvider", "Lorg/apache/http/client/CredentialsProvider;", "LocalDateTimeToString", "StringToLocalDatetime", "StringToUuid", "UuidToString", "osmt-api"})
public class ElasticsearchClientManager {
    @Autowired
    public EsConfig esConfig;

    @NotNull
    public EsConfig getEsConfig() {
        EsConfig esConfig = this.esConfig;
        if (esConfig != null) {
            return esConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"esConfig");
        return null;
    }

    public void setEsConfig(@NotNull EsConfig esConfig) {
        Intrinsics.checkNotNullParameter((Object)esConfig, (String)"<set-?>");
        this.esConfig = esConfig;
    }

    @Bean
    @NotNull
    public ElasticsearchClient elasticSearchClient() {
        RestClientTransport transport = new RestClientTransport(this.createRestClient(), (JsonpMapper)new JacksonJsonpMapper());
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    @Bean
    @NotNull
    public ElasticsearchTemplate elasticsearchTemplate() {
        return new ElasticsearchTemplate(this.elasticSearchClient());
    }

    @Bean
    @NotNull
    public ElasticsearchCustomConversions elasticSearchCustomConversions() {
        Object[] objectArray = new Converter[]{new LocalDateTimeToString(), new StringToLocalDatetime(), new UuidToString(), new StringToUuid()};
        return new ElasticsearchCustomConversions((Collection)CollectionsKt.listOf((Object[])objectArray));
    }

    private RestClient createRestClient() {
        CredentialsProvider credentialsProvider;
        HttpHost host = HttpHost.create((String)this.getEsConfig().getUri());
        HttpHost[] httpHostArray = new HttpHost[]{host};
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHostArray);
        CredentialsProvider credentialsProvider2 = credentialsProvider = this.getCredentialsProvider();
        if (credentialsProvider2 != null) {
            CredentialsProvider it = credentialsProvider2;
            boolean bl = false;
            restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchClientManager.createRestClient$lambda$1$lambda$0(it, arg_0));
        }
        RestClient restClient = restClientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"restClientBuilder.build()");
        return restClient;
    }

    private CredentialsProvider getCredentialsProvider() {
        CharSequence charSequence = this.getEsConfig().getUsername();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)this.getEsConfig().getPassword()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials(this.getEsConfig().getUsername(), this.getEsConfig().getPassword());
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credential);
        return (CredentialsProvider)credentialsProvider;
    }

    private static final HttpAsyncClientBuilder createRestClient$lambda$1$lambda$0(CredentialsProvider $it, HttpAsyncClientBuilder b) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return b.setDefaultCredentialsProvider($it);
    }

    @WritingConverter
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Ledu/wgu/osmt/elasticsearch/ElasticsearchClientManager$LocalDateTimeToString;", "Lorg/springframework/core/convert/converter/Converter;", "Ljava/time/LocalDateTime;", "", "()V", "convert", "source", "osmt-api"})
    public static final class LocalDateTimeToString
    implements Converter<LocalDateTime, String> {
        @NotNull
        public String convert(@NotNull LocalDateTime source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String string = source.format(DateTimeFormatter.ISO_DATE_TIME);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.format(DateTimeFormatter.ISO_DATE_TIME)");
            return string;
        }
    }

    @ReadingConverter
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Ledu/wgu/osmt/elasticsearch/ElasticsearchClientManager$StringToLocalDatetime;", "Lorg/springframework/core/convert/converter/Converter;", "", "Ljava/time/LocalDateTime;", "()V", "convert", "source", "osmt-api"})
    public static final class StringToLocalDatetime
    implements Converter<String, LocalDateTime> {
        @NotNull
        public LocalDateTime convert(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            LocalDateTime localDateTime = LocalDateTime.parse(source, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(source, DateTimeFo\u2026tter.ISO_LOCAL_DATE_TIME)");
            return localDateTime;
        }
    }

    @WritingConverter
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Ledu/wgu/osmt/elasticsearch/ElasticsearchClientManager$UuidToString;", "Lorg/springframework/core/convert/converter/Converter;", "Ljava/util/UUID;", "", "()V", "convert", "source", "osmt-api"})
    public static final class UuidToString
    implements Converter<UUID, String> {
        @NotNull
        public String convert(@NotNull UUID source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String string = source.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.toString()");
            return string;
        }
    }

    @ReadingConverter
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Ledu/wgu/osmt/elasticsearch/ElasticsearchClientManager$StringToUuid;", "Lorg/springframework/core/convert/converter/Converter;", "", "Ljava/util/UUID;", "()V", "convert", "source", "osmt-api"})
    public static final class StringToUuid
    implements Converter<String, UUID> {
        @NotNull
        public UUID convert(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            UUID uUID = UUID.fromString(source);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(source)");
            return uUID;
        }
    }
}

