/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.jobcode;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ExistsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.util.ObjectBuilder;
import edu.wgu.osmt.elasticsearch.OffsetPageable;
import edu.wgu.osmt.elasticsearch.OsmtQueryHelper;
import edu.wgu.osmt.jobcode.CustomJobCodeRepository;
import edu.wgu.osmt.jobcode.JobCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.core.SearchHits;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Ledu/wgu/osmt/jobcode/CustomJobCodeRepositoryImpl;", "Ledu/wgu/osmt/jobcode/CustomJobCodeRepository;", "elasticSearchTemplate", "Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;", "(Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;)V", "getElasticSearchTemplate", "()Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "createComplexQueries", "", "Lco/elastic/clients/elasticsearch/_types/query_dsl/Query;", "searchStr", "", "createDisMaxQuery", "createPrefixQueries", "createSimpleQueries", "multiPropertySearch", "typeAheadSearch", "Lorg/springframework/data/elasticsearch/core/SearchHits;", "Ledu/wgu/osmt/jobcode/JobCode;", "osmt-api"})
public final class CustomJobCodeRepositoryImpl
implements CustomJobCodeRepository {
    @NotNull
    private final ElasticsearchTemplate elasticSearchTemplate;
    @NotNull
    private final Logger log;

    @Autowired
    public CustomJobCodeRepositoryImpl(@NotNull ElasticsearchTemplate elasticSearchTemplate) {
        Intrinsics.checkNotNullParameter((Object)elasticSearchTemplate, (String)"elasticSearchTemplate");
        this.elasticSearchTemplate = elasticSearchTemplate;
        Logger logger = LoggerFactory.getLogger(CustomJobCodeRepositoryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CustomJobCodeRepositoryImpl::class.java)");
        this.log = logger;
    }

    @Override
    @NotNull
    public ElasticsearchTemplate getElasticSearchTemplate() {
        return this.elasticSearchTemplate;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public SearchHits<JobCode> typeAheadSearch(@NotNull String searchStr) {
        Intrinsics.checkNotNullParameter((Object)searchStr, (String)"searchStr");
        int limit = ((CharSequence)searchStr).length() == 0 ? 10000 : 20;
        NativeQuery nativeQuery = OsmtQueryHelper.INSTANCE.createNativeQuery(new OffsetPageable(0, limit, null), null, this.multiPropertySearch(searchStr), "CustomJobCodeRepository.typeAheadSearch()", this.log, OsmtQueryHelper.createSort$default(OsmtQueryHelper.INSTANCE, "name.keyword", null, 2, null));
        SearchHits searchHits = this.getElasticSearchTemplate().search((org.springframework.data.elasticsearch.core.query.Query)nativeQuery, JobCode.class);
        Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"elasticSearchTemplate.se\u2026ery, JobCode::class.java)");
        return searchHits;
    }

    private final Query multiPropertySearch(String searchStr) {
        Query disMaxQuery = this.createDisMaxQuery(searchStr);
        Query nameMustExistQuery = QueryBuilders.exists(CustomJobCodeRepositoryImpl::multiPropertySearch$lambda$0);
        Query query = QueryBuilders.bool(arg_0 -> CustomJobCodeRepositoryImpl.multiPropertySearch$lambda$1(disMaxQuery, nameMustExistQuery, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"bool { builder: BoolQuer\u2026ExistQuery).boost(1.0f) }");
        return query;
    }

    private final Query createDisMaxQuery(String searchStr) {
        boolean isComplex = StringsKt.contains$default((CharSequence)searchStr, (CharSequence)"\"", (boolean)false, (int)2, null);
        List queries = new ArrayList();
        queries.addAll((Collection)this.createPrefixQueries(searchStr));
        if (isComplex) {
            queries.addAll((Collection)this.createComplexQueries(searchStr));
        } else {
            queries.addAll((Collection)this.createSimpleQueries(searchStr));
        }
        return OsmtQueryHelper.createDisMaxDslQuery$default(OsmtQueryHelper.INSTANCE, queries, null, null, 6, null);
    }

    private final List<Query> createPrefixQueries(String searchStr) {
        Object[] objectArray = new Query[]{OsmtQueryHelper.INSTANCE.createPrefixDslQuery("code.keyword", searchStr, Float.valueOf(2.0f)), OsmtQueryHelper.createPrefixDslQuery$default(OsmtQueryHelper.INSTANCE, "minorCode.keyword", searchStr, null, 4, null), OsmtQueryHelper.createPrefixDslQuery$default(OsmtQueryHelper.INSTANCE, "detailedCode.keyword", searchStr, null, 4, null), OsmtQueryHelper.createPrefixDslQuery$default(OsmtQueryHelper.INSTANCE, "majorCode.keyword", searchStr, null, 4, null), OsmtQueryHelper.createPrefixDslQuery$default(OsmtQueryHelper.INSTANCE, "broadCode.keyword", searchStr, null, 4, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<Query> createSimpleQueries(String searchStr) {
        Object[] objectArray = new Query[]{OsmtQueryHelper.INSTANCE.createMatchPhrasePrefixDslQuery("name", searchStr, Float.valueOf(2.0f)), OsmtQueryHelper.createMatchPhrasePrefixDslQuery$default(OsmtQueryHelper.INSTANCE, "minor", searchStr, null, 4, null), OsmtQueryHelper.createMatchPhrasePrefixDslQuery$default(OsmtQueryHelper.INSTANCE, "detailed", searchStr, null, 4, null), OsmtQueryHelper.createMatchPhrasePrefixDslQuery$default(OsmtQueryHelper.INSTANCE, "major", searchStr, null, 4, null), OsmtQueryHelper.createMatchPhrasePrefixDslQuery$default(OsmtQueryHelper.INSTANCE, "broad", searchStr, null, 4, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<Query> createComplexQueries(String searchStr) {
        Object[] objectArray = new Query[]{OsmtQueryHelper.createSimpleQueryDslQuery$default(OsmtQueryHelper.INSTANCE, "name.raw", searchStr, Float.valueOf(2.0f), null, null, 24, null), OsmtQueryHelper.INSTANCE.createSimpleQueryDslQuery("minor.raw", searchStr, Float.valueOf(1.0f), true, Operator.Or), OsmtQueryHelper.createSimpleQueryDslQuery$default(OsmtQueryHelper.INSTANCE, "detailed.raw", searchStr, Float.valueOf(1.0f), null, null, 24, null), OsmtQueryHelper.createSimpleQueryDslQuery$default(OsmtQueryHelper.INSTANCE, "major.raw", searchStr, Float.valueOf(1.0f), null, null, 24, null), OsmtQueryHelper.createSimpleQueryDslQuery$default(OsmtQueryHelper.INSTANCE, "broad.raw", searchStr, Float.valueOf(1.0f), null, null, 24, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void deleteIndex() {
        CustomJobCodeRepository.DefaultImpls.deleteIndex(this);
    }

    private static final ObjectBuilder multiPropertySearch$lambda$0(ExistsQuery.Builder qt) {
        Intrinsics.checkNotNullParameter((Object)qt, (String)"qt");
        return (ObjectBuilder)qt.field("name").boost(Float.valueOf(1.0f));
    }

    private static final ObjectBuilder multiPropertySearch$lambda$1(Query $disMaxQuery, Query $nameMustExistQuery, BoolQuery.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)$disMaxQuery, (String)"$disMaxQuery");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Query[] queryArray = new Query[]{$nameMustExistQuery};
        return (ObjectBuilder)builder.must($disMaxQuery, queryArray).boost(Float.valueOf(1.0f));
    }
}

