/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.keyword;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchAllQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchBoolPrefixQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchPhraseQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.util.ObjectBuilder;
import edu.wgu.osmt.elasticsearch.OffsetPageable;
import edu.wgu.osmt.elasticsearch.OsmtQueryHelper;
import edu.wgu.osmt.jobcode.CustomJobCodeRepositoryImpl;
import edu.wgu.osmt.keyword.CustomKeywordRepository;
import edu.wgu.osmt.keyword.Keyword;
import edu.wgu.osmt.keyword.KeywordTypeEnum;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.core.SearchHits;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ledu/wgu/osmt/keyword/CustomKeywordRepositoryImpl;", "Ledu/wgu/osmt/keyword/CustomKeywordRepository;", "elasticSearchTemplate", "Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;", "(Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;)V", "getElasticSearchTemplate", "()Lorg/springframework/data/elasticsearch/client/elc/ElasticsearchTemplate;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "searchAll", "Lco/elastic/clients/elasticsearch/_types/query_dsl/Query;", "type", "Ledu/wgu/osmt/keyword/KeywordTypeEnum;", "searchSpecific", "searchStr", "", "typeAheadSearch", "Lorg/springframework/data/elasticsearch/core/SearchHits;", "Ledu/wgu/osmt/keyword/Keyword;", "osmt-api"})
public final class CustomKeywordRepositoryImpl
implements CustomKeywordRepository {
    @NotNull
    private final ElasticsearchTemplate elasticSearchTemplate;
    @NotNull
    private final Logger log;

    @Autowired
    public CustomKeywordRepositoryImpl(@NotNull ElasticsearchTemplate elasticSearchTemplate) {
        Intrinsics.checkNotNullParameter((Object)elasticSearchTemplate, (String)"elasticSearchTemplate");
        this.elasticSearchTemplate = elasticSearchTemplate;
        Logger logger = LoggerFactory.getLogger(CustomJobCodeRepositoryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CustomJobCodeRepositoryImpl::class.java)");
        this.log = logger;
    }

    @Override
    @NotNull
    public ElasticsearchTemplate getElasticSearchTemplate() {
        return this.elasticSearchTemplate;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    public SearchHits<Keyword> typeAheadSearch(@NotNull String searchStr, @NotNull KeywordTypeEnum type) {
        Intrinsics.checkNotNullParameter((Object)searchStr, (String)"searchStr");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        OffsetPageable pageable = null;
        Query criteria = null;
        if (((CharSequence)searchStr).length() == 0) {
            pageable = new OffsetPageable(0, 10000, null);
            criteria = this.searchAll(type);
        } else {
            pageable = new OffsetPageable(0, 20, null);
            criteria = this.searchSpecific(searchStr, type);
        }
        NativeQuery nativeQuery = OsmtQueryHelper.INSTANCE.createNativeQuery(pageable, null, criteria, "CustomKeywordRepositoryImpl.typeAheadSearch()", this.log, OsmtQueryHelper.createSort$default(OsmtQueryHelper.INSTANCE, "value.sort_insensitive", null, 2, null));
        SearchHits searchHits = this.getElasticSearchTemplate().search((org.springframework.data.elasticsearch.core.query.Query)nativeQuery, Keyword.class);
        Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"elasticSearchTemplate.se\u2026ery, Keyword::class.java)");
        return searchHits;
    }

    @NotNull
    public final Query searchAll(@NotNull KeywordTypeEnum type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Query query = QueryBuilders.bool(arg_0 -> CustomKeywordRepositoryImpl.searchAll$lambda$2(type, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"bool { builder: BoolQuer\u2026lQuery.Builder -> q } ) }");
        return query;
    }

    @NotNull
    public final Query searchSpecific(@NotNull String searchStr, @NotNull KeywordTypeEnum type) {
        Intrinsics.checkNotNullParameter((Object)searchStr, (String)"searchStr");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Query query = QueryBuilders.bool(arg_0 -> CustomKeywordRepositoryImpl.searchSpecific$lambda$6(type, searchStr, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"bool { builder: BoolQuer\u2026minimumShouldMatch(\"1\") }");
        return query;
    }

    @Override
    public void deleteIndex() {
        CustomKeywordRepository.DefaultImpls.deleteIndex(this);
    }

    private static final ObjectBuilder searchAll$lambda$2$lambda$0(KeywordTypeEnum $type, TermQuery.Builder qt) {
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        Intrinsics.checkNotNullParameter((Object)qt, (String)"qt");
        return (ObjectBuilder)qt.field("type").value($type.name());
    }

    private static final ObjectBuilder searchAll$lambda$2$lambda$1(MatchAllQuery.Builder q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return (ObjectBuilder)q;
    }

    private static final ObjectBuilder searchAll$lambda$2(KeywordTypeEnum $type, BoolQuery.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return (ObjectBuilder)builder.must(QueryBuilders.term(arg_0 -> CustomKeywordRepositoryImpl.searchAll$lambda$2$lambda$0($type, arg_0)), new Query[0]).should(QueryBuilders.matchAll(CustomKeywordRepositoryImpl::searchAll$lambda$2$lambda$1), new Query[0]);
    }

    private static final ObjectBuilder searchSpecific$lambda$6$lambda$3(KeywordTypeEnum $type, TermQuery.Builder qt) {
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        Intrinsics.checkNotNullParameter((Object)qt, (String)"qt");
        return (ObjectBuilder)qt.field("type").value($type.name());
    }

    private static final ObjectBuilder searchSpecific$lambda$6$lambda$4(String $searchStr, MatchBoolPrefixQuery.Builder q) {
        Intrinsics.checkNotNullParameter((Object)$searchStr, (String)"$searchStr");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return (ObjectBuilder)q.field("value").query($searchStr);
    }

    private static final ObjectBuilder searchSpecific$lambda$6$lambda$5(String $searchStr, MatchPhraseQuery.Builder q) {
        Intrinsics.checkNotNullParameter((Object)$searchStr, (String)"$searchStr");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return (ObjectBuilder)q.field("value").query($searchStr);
    }

    private static final ObjectBuilder searchSpecific$lambda$6(KeywordTypeEnum $type, String $searchStr, BoolQuery.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)$type), (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$searchStr, (String)"$searchStr");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return (ObjectBuilder)builder.must(QueryBuilders.term(arg_0 -> CustomKeywordRepositoryImpl.searchSpecific$lambda$6$lambda$3($type, arg_0)), new Query[0]).should(QueryBuilders.matchBoolPrefix(arg_0 -> CustomKeywordRepositoryImpl.searchSpecific$lambda$6$lambda$4($searchStr, arg_0)), new Query[0]).should(QueryBuilders.matchPhrase(arg_0 -> CustomKeywordRepositoryImpl.searchSpecific$lambda$6$lambda$5($searchStr, arg_0)), new Query[0]).minimumShouldMatch("1");
    }
}

