/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.richskill;

import edu.wgu.osmt.HasAllPaginated;
import edu.wgu.osmt.api.GeneralApiException;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.api.model.ApiSearchV2;
import edu.wgu.osmt.api.model.ApiSkill;
import edu.wgu.osmt.api.model.ApiSkillUpdate;
import edu.wgu.osmt.api.model.ApiSkillUpdateMapper;
import edu.wgu.osmt.api.model.ApiSkillUpdateV2;
import edu.wgu.osmt.api.model.ApiSkillV2;
import edu.wgu.osmt.api.model.SkillSortEnum;
import edu.wgu.osmt.api.model.SortOrder;
import edu.wgu.osmt.api.model.SortOrderCompanion;
import edu.wgu.osmt.auditlog.AuditLog;
import edu.wgu.osmt.auditlog.AuditLogDao;
import edu.wgu.osmt.auditlog.AuditLogRepository;
import edu.wgu.osmt.auditlog.AuditLogSortEnum;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.elasticsearch.OffsetPageable;
import edu.wgu.osmt.elasticsearch.PaginatedLinks;
import edu.wgu.osmt.io.csv.RichSkillCsvExport;
import edu.wgu.osmt.io.csv.RichSkillCsvExportV2;
import edu.wgu.osmt.keyword.KeywordDao;
import edu.wgu.osmt.richskill.RichSkillAndCollections;
import edu.wgu.osmt.richskill.RichSkillController;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillDescriptorTable;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillDocV2;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.security.OAuthHelper;
import edu.wgu.osmt.task.AppliesToType;
import edu.wgu.osmt.task.CreateSkillsTask;
import edu.wgu.osmt.task.CreateSkillsTaskV2;
import edu.wgu.osmt.task.CsvTask;
import edu.wgu.osmt.task.CsvTaskV2;
import edu.wgu.osmt.task.ExportSkillsToCsvTask;
import edu.wgu.osmt.task.ExportSkillsToCsvTaskV2;
import edu.wgu.osmt.task.ExportSkillsToXlsxTask;
import edu.wgu.osmt.task.PublishTask;
import edu.wgu.osmt.task.PublishTaskV2;
import edu.wgu.osmt.task.Task;
import edu.wgu.osmt.task.TaskMessageService;
import edu.wgu.osmt.task.TaskResult;
import edu.wgu.osmt.task.XlsxTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.SizedIterable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJU\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011032\b\u00104\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u00107JU\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002090,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011032\b\u00104\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u00107J_\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011032\b\b\u0001\u0010;\u001a\u00020<2\b\u00104\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u0010=J \u0010>\u001a\u0004\u0018\u00010?2\b\b\u0001\u0010@\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J.\u0010A\u001a\u0006\u0012\u0002\b\u00030+2\n\b\u0001\u0010B\u001a\u0004\u0018\u00010\u00112\b\b\u0001\u0010@\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u001e\u0010C\u001a\u00020\u00112\b\b\u0001\u0010@\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u001e\u0010D\u001a\u00020\u00112\b\b\u0001\u0010@\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J \u0010E\u001a\u0004\u0018\u00010?2\b\b\u0001\u0010@\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J*\u0010F\u001a\b\u0012\u0004\u0012\u00020G0+2\u000e\b\u0001\u0010H\u001a\b\u0012\u0004\u0012\u00020I0,2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J*\u0010J\u001a\b\u0012\u0004\u0012\u00020G0+2\u000e\b\u0001\u0010H\u001a\b\u0012\u0004\u0012\u00020K0,2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J7\u0010L\u001a\b\u0012\u0004\u0012\u00020G0+2\b\b\u0001\u0010;\u001a\u00020<2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011032\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u0010MJ7\u0010N\u001a\b\u0012\u0004\u0012\u00020G0+2\b\b\u0001\u0010;\u001a\u00020<2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011032\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u0010MJ7\u0010O\u001a\b\u0012\u0004\u0012\u00020G0+2\b\b\u0001\u0010;\u001a\u00020<2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0011032\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017\u00a2\u0006\u0002\u0010MJ\u001a\u0010P\u001a\b\u0012\u0004\u0012\u00020G0+2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020G0+2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u001a\u0010R\u001a\b\u0012\u0004\u0012\u00020G0+2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017JH\u0010S\u001a\b\u0012\u0004\u0012\u00020G0+2\b\b\u0001\u0010T\u001a\u00020<2\b\b\u0001\u0010U\u001a\u00020\u00112\u000e\b\u0001\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00110,2\b\b\u0001\u0010W\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017JH\u0010X\u001a\b\u0012\u0004\u0012\u00020G0+2\b\b\u0001\u0010T\u001a\u00020Y2\b\b\u0001\u0010U\u001a\u00020\u00112\u000e\b\u0001\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00110,2\b\b\u0001\u0010W\u001a\u00020\u00112\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J\u001e\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020[0,0+2\b\b\u0001\u0010@\u001a\u00020\u0011H\u0017J(\u0010\\\u001a\u00020?2\b\b\u0001\u0010@\u001a\u00020\u00112\b\b\u0001\u0010]\u001a\u00020I2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017J(\u0010^\u001a\u00020?2\b\b\u0001\u0010@\u001a\u00020\u00112\b\b\u0001\u0010]\u001a\u00020K2\n\b\u0001\u00105\u001a\u0004\u0018\u000106H\u0017R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006_"}, d2={"Ledu/wgu/osmt/richskill/RichSkillController;", "Ledu/wgu/osmt/HasAllPaginated;", "Ledu/wgu/osmt/richskill/RichSkillDoc;", "richSkillRepository", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "taskMessageService", "Ledu/wgu/osmt/task/TaskMessageService;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "auditLogRepository", "Ledu/wgu/osmt/auditlog/AuditLogRepository;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "oAuthHelper", "Ledu/wgu/osmt/security/OAuthHelper;", "(Ledu/wgu/osmt/richskill/RichSkillRepository;Ledu/wgu/osmt/task/TaskMessageService;Ledu/wgu/osmt/richskill/RichSkillEsRepo;Ledu/wgu/osmt/auditlog/AuditLogRepository;Ledu/wgu/osmt/config/AppConfig;Ledu/wgu/osmt/security/OAuthHelper;)V", "allPaginatedPath", "", "getAllPaginatedPath", "()Ljava/lang/String;", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getAuditLogRepository", "()Ledu/wgu/osmt/auditlog/AuditLogRepository;", "elasticRepository", "getElasticRepository", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "keywordDao", "Ledu/wgu/osmt/keyword/KeywordDao$Companion;", "getKeywordDao", "()Ledu/wgu/osmt/keyword/KeywordDao$Companion;", "getOAuthHelper", "()Ledu/wgu/osmt/security/OAuthHelper;", "getRichSkillEsRepo", "getRichSkillRepository", "()Ledu/wgu/osmt/richskill/RichSkillRepository;", "sortOrderCompanion", "Ledu/wgu/osmt/api/model/SkillSortEnum$Companion;", "getSortOrderCompanion", "()Ledu/wgu/osmt/api/model/SkillSortEnum$Companion;", "getTaskMessageService", "()Ledu/wgu/osmt/task/TaskMessageService;", "allPaginated", "Lorg/springframework/http/HttpEntity;", "", "uriComponentsBuilder", "Lorg/springframework/web/util/UriComponentsBuilder;", "size", "", "from", "status", "", "sort", "user", "Lorg/springframework/security/oauth2/jwt/Jwt;", "(Lorg/springframework/web/util/UriComponentsBuilder;II[Ljava/lang/String;Ljava/lang/String;Lorg/springframework/security/oauth2/jwt/Jwt;)Lorg/springframework/http/HttpEntity;", "allPaginatedV2", "Ledu/wgu/osmt/richskill/RichSkillDocV2;", "allPaginatedWithFilters", "apiSearch", "Ledu/wgu/osmt/api/model/ApiSearch;", "(Lorg/springframework/web/util/UriComponentsBuilder;II[Ljava/lang/String;Ledu/wgu/osmt/api/model/ApiSearch;Ljava/lang/String;Lorg/springframework/security/oauth2/jwt/Jwt;)Lorg/springframework/http/HttpEntity;", "byUUID", "Ledu/wgu/osmt/api/model/ApiSkill;", "uuid", "byUUIDCsvView", "apiVersion", "byUUIDHtmlView", "byUUIDHtmlViewV2", "byUUIDV2", "createSkills", "Ledu/wgu/osmt/task/TaskResult;", "apiSkillUpdates", "Ledu/wgu/osmt/api/model/ApiSkillUpdate;", "createSkillsV2", "Ledu/wgu/osmt/api/model/ApiSkillUpdateV2;", "exportCustomListCsv", "(Ledu/wgu/osmt/api/model/ApiSearch;[Ljava/lang/String;Lorg/springframework/security/oauth2/jwt/Jwt;)Lorg/springframework/http/HttpEntity;", "exportCustomListCsvV2", "exportCustomListXlsx", "exportLibraryCsv", "exportLibraryV2", "exportLibraryXlsx", "publishSkills", "search", "newStatus", "filterByStatus", "collectionUuid", "publishSkillsV2", "Ledu/wgu/osmt/api/model/ApiSearchV2;", "skillAuditLog", "Ledu/wgu/osmt/auditlog/AuditLog;", "updateSkill", "skillUpdate", "updateSkillV2", "osmt-api"})
public class RichSkillController
implements HasAllPaginated<RichSkillDoc> {
    @NotNull
    private final RichSkillRepository richSkillRepository;
    @NotNull
    private final TaskMessageService taskMessageService;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final AuditLogRepository auditLogRepository;
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final OAuthHelper oAuthHelper;
    @NotNull
    private final RichSkillEsRepo elasticRepository;
    @NotNull
    private final KeywordDao.Companion keywordDao;
    @NotNull
    private final String allPaginatedPath;
    @NotNull
    private final SkillSortEnum.Companion sortOrderCompanion;

    @Autowired
    public RichSkillController(@NotNull RichSkillRepository richSkillRepository, @NotNull TaskMessageService taskMessageService, @NotNull RichSkillEsRepo richSkillEsRepo, @NotNull AuditLogRepository auditLogRepository, @NotNull AppConfig appConfig, @NotNull OAuthHelper oAuthHelper) {
        Intrinsics.checkNotNullParameter((Object)richSkillRepository, (String)"richSkillRepository");
        Intrinsics.checkNotNullParameter((Object)taskMessageService, (String)"taskMessageService");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        Intrinsics.checkNotNullParameter((Object)auditLogRepository, (String)"auditLogRepository");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)oAuthHelper, (String)"oAuthHelper");
        this.richSkillRepository = richSkillRepository;
        this.taskMessageService = taskMessageService;
        this.richSkillEsRepo = richSkillEsRepo;
        this.auditLogRepository = auditLogRepository;
        this.appConfig = appConfig;
        this.oAuthHelper = oAuthHelper;
        this.elasticRepository = this.getRichSkillEsRepo();
        this.keywordDao = KeywordDao.Companion;
        this.allPaginatedPath = "/v3/skills";
        this.sortOrderCompanion = SkillSortEnum.Companion;
    }

    @NotNull
    public RichSkillRepository getRichSkillRepository() {
        return this.richSkillRepository;
    }

    @NotNull
    public TaskMessageService getTaskMessageService() {
        return this.taskMessageService;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public AuditLogRepository getAuditLogRepository() {
        return this.auditLogRepository;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public OAuthHelper getOAuthHelper() {
        return this.oAuthHelper;
    }

    @NotNull
    public RichSkillEsRepo getElasticRepository() {
        return this.elasticRepository;
    }

    @NotNull
    public KeywordDao.Companion getKeywordDao() {
        return this.keywordDao;
    }

    @Override
    @NotNull
    public String getAllPaginatedPath() {
        return this.allPaginatedPath;
    }

    @NotNull
    public SkillSortEnum.Companion getSortOrderCompanion() {
        return this.sortOrderCompanion;
    }

    @Override
    @Deprecated(message="Replaced with allPaginatedWithFilters")
    @GetMapping(path={"/api/v3/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<RichSkillDoc>> allPaginated(@NotNull UriComponentsBuilder uriComponentsBuilder, int size, int from, @NotNull String[] status2, @Nullable String sort, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (!this.getAppConfig().getAllowPublicLists() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        return HasAllPaginated.DefaultImpls.allPaginated(this, uriComponentsBuilder, size, from, status2, sort, user);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"/api/v2/skills", "/api/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<RichSkillDocV2>> allPaginatedV2(@NotNull UriComponentsBuilder uriComponentsBuilder, int size, int from, @NotNull String[] status2, @Nullable String sort, @AuthenticationPrincipal @Nullable Jwt user) {
        List list;
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (!this.getAppConfig().getAllowPublicLists() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        HttpEntity<List<RichSkillDoc>> paginated = HasAllPaginated.DefaultImpls.allPaginated(this, uriComponentsBuilder, size, from, status2, sort, user);
        List list2 = (List)paginated.getBody();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RichSkillDoc richSkillDoc = (RichSkillDoc)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(RichSkillDocV2.Companion.fromLatest((RichSkillDoc)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List v2Body = list;
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)200).headers(paginated.getHeaders())).body(v2Body);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).headers(pagi\u2026ted.headers).body(v2Body)");
        return (HttpEntity)responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/api/v3/skills/filter"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<List<RichSkillDoc>> allPaginatedWithFilters(@NotNull UriComponentsBuilder uriComponentsBuilder, int size, int from, @NotNull String[] status2, @RequestBody @NotNull ApiSearch apiSearch, @Nullable String sort, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uriComponentsBuilder, (String)"uriComponentsBuilder");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        String[] $this$mapNotNull$iv = status2;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PublishStatus it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            PublishStatus status3 = PublishStatus.Companion.forApiValue((String)it);
            if ((user == null && (status3 == PublishStatus.Deleted || status3 == PublishStatus.Draft) ? null : status3) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set publishStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        SortOrder sortEnum = SortOrderCompanion.DefaultImpls.forValueOrDefault$default(this.getSortOrderCompanion(), sort, null, 2, null);
        OffsetPageable pageable = new OffsetPageable(from, size, sortEnum.getSort());
        SearchHits searchHits = this.getRichSkillEsRepo().byApiSearch(apiSearch, publishStatuses, pageable, "");
        long countAllFiltered = searchHits.getTotalHits();
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("X-Total-Count", String.valueOf(countAllFiltered));
        Object[] objectArray = new Object[]{from};
        UriComponentsBuilder uriComponentsBuilder2 = uriComponentsBuilder.path("/api/v3/skills/filter").queryParam("from", objectArray);
        objectArray = new Object[]{size};
        UriComponentsBuilder uriComponentsBuilder3 = uriComponentsBuilder2.queryParam("size", objectArray);
        objectArray = new Object[]{sort};
        UriComponentsBuilder uriComponentsBuilder4 = uriComponentsBuilder3.queryParam("sort", objectArray);
        objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ArraysKt.joinToString$default((Object[])status2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null).toLowerCase(), (String)"this as java.lang.String).toLowerCase()");
        uriComponentsBuilder4.queryParam("status", objectArray);
        new PaginatedLinks(pageable, (int)searchHits.getTotalHits(), uriComponentsBuilder).addToHeaders(responseHeaders);
        ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)200).headers(responseHeaders)).body((Object)searchHits.map(arg_0 -> RichSkillController.allPaginatedWithFilters$lambda$2(allPaginatedWithFilters.1.INSTANCE, arg_0)).toList());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).headers(resp\u2026 { it.content }.toList())");
        return (HttpEntity)responseEntity;
    }

    @PostMapping(path={"/api/v3/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> createSkills(@RequestBody @NotNull List<ApiSkillUpdate> apiSkillUpdates, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter(apiSkillUpdates, (String)"apiSkillUpdates");
        CreateSkillsTask task = new CreateSkillsTask(apiSkillUpdates, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), OAuthHelper.readableUserIdentifier$default(this.getOAuthHelper(), user, null, 2, null), null, null, null, null, 120, null);
        this.getTaskMessageService().enqueueJob("create-skills", task);
        return Task.Companion.processingResponse(task);
    }

    @PostMapping(path={"/api/v2/skills", "/api/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> createSkillsV2(@RequestBody @NotNull List<ApiSkillUpdateV2> apiSkillUpdates, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter(apiSkillUpdates, (String)"apiSkillUpdates");
        CreateSkillsTaskV2 task = new CreateSkillsTaskV2(apiSkillUpdates, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), OAuthHelper.readableUserIdentifier$default(this.getOAuthHelper(), user, null, 2, null), null, null, null, null, 120, null);
        this.getTaskMessageService().enqueueJob("create-skills", task);
        return Task.Companion.processingResponse(task);
    }

    @GetMapping(value={"/api/v3/skills/{uuid}"}, produces={"application/json"})
    @ResponseBody
    @Nullable
    public ApiSkill byUUID(@PathVariable @NotNull String uuid, @AuthenticationPrincipal @Nullable Jwt user) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                object = this.getRichSkillRepository().findByUUID(uuid);
                if (object == null) break block4;
                RichSkillDescriptorDao it = object;
                boolean bl = false;
                if (user == null && it.publishStatus() == PublishStatus.Unarchived) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                ApiSkill apiSkill = ApiSkill.Companion.fromDao(it, this.getAppConfig());
                object = apiSkill;
                if (apiSkill != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return object;
    }

    @GetMapping(path={"/api/v2/skills/{uuid}", "/api/skills/{uuid}"}, produces={"application/json"})
    @ResponseBody
    @Nullable
    public ApiSkill byUUIDV2(@PathVariable @NotNull String uuid, @AuthenticationPrincipal @Nullable Jwt user) {
        ApiSkillV2 apiSkillV2;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ApiSkill apiSkill = this.byUUID(uuid, user);
        if (apiSkill != null) {
            ApiSkill it = apiSkill;
            boolean bl = false;
            apiSkillV2 = ApiSkillV2.Companion.fromLatest(it, this.getAppConfig());
        } else {
            apiSkillV2 = null;
        }
        return apiSkillV2;
    }

    @RequestMapping(value={"/api/v3/skills/{uuid}"}, produces={"text/html"})
    @NotNull
    public String byUUIDHtmlView(@PathVariable @NotNull String uuid, @AuthenticationPrincipal @Nullable Jwt user) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                object = this.getRichSkillRepository().findByUUID(uuid);
                if (object == null) break block4;
                RichSkillDescriptorDao it = object;
                boolean bl = false;
                if (user == null && it.publishStatus() == PublishStatus.Unarchived) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                String string = "forward:/v3/skills/" + uuid;
                object = string;
                if (string != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return object;
    }

    @RequestMapping(path={"/api/v2/skills/{uuid}", "/api/skills/{uuid}"}, produces={"text/html"})
    @NotNull
    public String byUUIDHtmlViewV2(@PathVariable @NotNull String uuid, @AuthenticationPrincipal @Nullable Jwt user) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                object = this.getRichSkillRepository().findByUUID(uuid);
                if (object == null) break block4;
                RichSkillDescriptorDao it = object;
                boolean bl = false;
                if (user == null && it.publishStatus() == PublishStatus.Unarchived) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
                }
                String string = "forward:/v2/skills/" + uuid;
                object = string;
                if (string != null) break block5;
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(path={"/api/{apiVersion}/collections/{uuid}/updateSkills"}, produces={"text/csv"})
    @NotNull
    public HttpEntity<?> byUUIDCsvView(@PathVariable(name="apiVersion", required=false) @Nullable String apiVersion, @PathVariable @NotNull String uuid, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        RichSkillDescriptorDao richSkillDescriptorDao = this.getRichSkillRepository().findByUUID(uuid);
        if (richSkillDescriptorDao != null) {
            String string;
            void $this$mapTo$iv$iv;
            RichSkillDescriptorDao it = richSkillDescriptorDao;
            boolean bl = false;
            if (user == null && it.publishStatus() == PublishStatus.Unarchived) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            RichSkillDescriptor skill = it.toModel();
            Iterable $this$map$iv = (Iterable)it.getCollections();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                CollectionDao collectionDao = (CollectionDao)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.toModel());
            }
            Set collections = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (Intrinsics.areEqual((Object)"/v3", (Object)("/" + apiVersion))) {
                string = new RichSkillCsvExport(this.getAppConfig()).toCsv(CollectionsKt.listOf((Object)new RichSkillAndCollections(skill, collections)));
            } else if (Intrinsics.areEqual((Object)"/v2", (Object)("/" + apiVersion)) || Intrinsics.areEqual((Object)"", (Object)apiVersion)) {
                string = new RichSkillCsvExportV2(this.getAppConfig()).toCsv(CollectionsKt.listOf((Object)new RichSkillAndCollections(skill, collections)));
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            String result = string;
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.add("Content-Type", "text/csv");
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)result);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok().headers(responseHeaders).body(result)");
            return (HttpEntity)responseEntity;
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/v3/skills/{uuid}/update"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public ApiSkill updateSkill(@PathVariable @NotNull String uuid, @RequestBody @NotNull ApiSkillUpdate skillUpdate, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        if (this.getOAuthHelper().hasRole(this.getAppConfig().getRoleCurator()) && !this.getOAuthHelper().isArchiveRelated(skillUpdate.getPublishStatus())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        RichSkillDescriptorDao richSkillDescriptorDao = this.getRichSkillRepository().findByUUID(uuid);
        if (richSkillDescriptorDao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        RichSkillDescriptorDao existingSkill = richSkillDescriptorDao;
        RichSkillDescriptorDao richSkillDescriptorDao2 = this.getRichSkillRepository().updateFromApi(((Number)((Object)existingSkill.getId().getValue())).longValue(), skillUpdate, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), OAuthHelper.readableUserIdentifier$default(this.getOAuthHelper(), user, null, 2, null));
        if (richSkillDescriptorDao2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        RichSkillDescriptorDao updatedSkill = richSkillDescriptorDao2;
        return ApiSkill.Companion.fromDao(updatedSkill, this.getAppConfig());
    }

    @PostMapping(path={"/api/v2/skills/{uuid}/update", "/api/skills/{uuid}/update"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public ApiSkill updateSkillV2(@PathVariable @NotNull String uuid, @RequestBody @NotNull ApiSkillUpdateV2 skillUpdate, @AuthenticationPrincipal @Nullable Jwt user) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        return ApiSkillV2.Companion.fromLatest(this.updateSkill(uuid, ApiSkillUpdateMapper.Companion.mapApiSkillUpdateV2ToApiSkillUpdate(skillUpdate, uuid, this.getRichSkillRepository()), user), this.getAppConfig());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(path={"/api/v3/skills/publish"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> publishSkills(@RequestBody @NotNull ApiSearch search, @RequestParam(required=false, defaultValue="Published") @NotNull String newStatus, @RequestParam(required=false, defaultValue="draft,published") @NotNull List<String> filterByStatus, @RequestParam(required=false, defaultValue="") @NotNull String collectionUuid, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        Intrinsics.checkNotNullParameter(filterByStatus, (String)"filterByStatus");
        Intrinsics.checkNotNullParameter((Object)collectionUuid, (String)"collectionUuid");
        Iterable $this$mapNotNull$iv = filterByStatus;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PublishStatus it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PublishStatus.Companion.forApiValue(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filterStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        PublishStatus publishStatus = PublishStatus.Companion.forApiValue(newStatus);
        if (publishStatus == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        PublishStatus publishStatus2 = publishStatus;
        PublishTask task = new PublishTask(AppliesToType.Skill, search, filterStatuses, publishStatus2, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), StringsKt.isBlank((CharSequence)collectionUuid) ? null : collectionUuid, null, null, null, null, 960, null);
        this.getTaskMessageService().enqueueJob("batch-publish-skills", task);
        return Task.Companion.processingResponse(task);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(path={"/api/v2/skills/publish", "/api/skills/publish"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> publishSkillsV2(@RequestBody @NotNull ApiSearchV2 search, @RequestParam(required=false, defaultValue="Published") @NotNull String newStatus, @RequestParam(required=false, defaultValue="draft,published") @NotNull List<String> filterByStatus, @RequestParam(required=false, defaultValue="") @NotNull String collectionUuid, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)newStatus, (String)"newStatus");
        Intrinsics.checkNotNullParameter(filterByStatus, (String)"filterByStatus");
        Intrinsics.checkNotNullParameter((Object)collectionUuid, (String)"collectionUuid");
        Iterable $this$mapNotNull$iv = filterByStatus;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PublishStatus it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PublishStatus.Companion.forApiValue(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filterStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        PublishStatus publishStatus = PublishStatus.Companion.forApiValue(newStatus);
        if (publishStatus == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        PublishStatus publishStatus2 = publishStatus;
        PublishTaskV2 task = new PublishTaskV2(AppliesToType.Skill, search, filterStatuses, publishStatus2, OAuthHelper.readableUserName$default(this.getOAuthHelper(), user, null, 2, null), StringsKt.isBlank((CharSequence)collectionUuid) ? null : collectionUuid, null, null, null, null, 960, null);
        this.getTaskMessageService().enqueueJob("batch-publish-skills", task);
        return Task.Companion.processingResponse(task);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"/api/v2/skills/{uuid}/log", "/api/v3/skills/{uuid}/log", "/api/skills/{uuid}/log"}, produces={"application/json"})
    @NotNull
    public HttpEntity<List<AuditLog>> skillAuditLog(@PathVariable @NotNull String uuid) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        OffsetPageable pageable = new OffsetPageable(0, Integer.MAX_VALUE, ((AuditLogSortEnum)SortOrderCompanion.DefaultImpls.forValueOrDefault$default(AuditLogSortEnum.Companion, AuditLogSortEnum.DateDesc.getApiValue(), null, 2, null)).getSort());
        RichSkillDescriptorDao richSkillDescriptorDao = this.getRichSkillRepository().findByUUID(uuid);
        if (richSkillDescriptorDao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Skill with id " + uuid + " not ready or not found");
        }
        RichSkillDescriptorDao skill = richSkillDescriptorDao;
        SizedIterable<AuditLogDao> sizedIterable = this.getAuditLogRepository().findByTableAndId(RichSkillDescriptorTable.INSTANCE.getTableName(), ((Number)((Object)skill.getId().getValue())).longValue(), pageable);
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)sizedIterable));
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((int)200);
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AuditLogDao auditLogDao = (AuditLogDao)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toModel());
        }
        ResponseEntity responseEntity = bodyBuilder.body((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"status(200).body(sizedIt\u2026t().map { it.toModel() })");
        return (HttpEntity)responseEntity;
    }

    @Transactional(readOnly=true)
    @GetMapping(path={"/api/v3/export/library/csv"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> exportLibraryCsv(@AuthenticationPrincipal @Nullable Jwt user) {
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        if (!this.getOAuthHelper().hasRole(this.getAppConfig().getRoleAdmin())) {
            throw new GeneralApiException("OSMT user must have an Admin role.", HttpStatus.UNAUTHORIZED);
        }
        CsvTask task = new CsvTask("FullLibrary", null, null, null, null, 30, null);
        this.getTaskMessageService().enqueueJob("full-library-skills-csv-process", task);
        return Task.Companion.processingResponse(task);
    }

    @Transactional(readOnly=true)
    @GetMapping(path={"/api/v2/export/library", "/api/export/library"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> exportLibraryV2(@AuthenticationPrincipal @Nullable Jwt user) {
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        if (!this.getOAuthHelper().hasRole(this.getAppConfig().getRoleAdmin())) {
            throw new GeneralApiException("OSMT user must have an Admin role.", HttpStatus.UNAUTHORIZED);
        }
        CsvTaskV2 task = new CsvTaskV2("FullLibrary", null, null, null, null, 30, null);
        this.getTaskMessageService().enqueueJob("full-library-skills-csv-process", task);
        return Task.Companion.processingResponse(task);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/api/v3/export/library/xlsx"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> exportLibraryXlsx(@AuthenticationPrincipal @Nullable Jwt user) {
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        if (!this.getOAuthHelper().hasRole(this.getAppConfig().getRoleAdmin())) {
            throw new GeneralApiException("OSMT user must have an Admin role.", HttpStatus.UNAUTHORIZED);
        }
        XlsxTask task = new XlsxTask("FullLibrary", null, null, null, null, 30, null);
        this.getTaskMessageService().enqueueJob("full-library-skills-xlsx-process", task);
        return Task.Companion.processingResponse(task);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=true)
    @PostMapping(path={"/api/v3/export/skills/csv"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> exportCustomListCsv(@RequestBody @NotNull ApiSearch apiSearch, @NotNull String[] status2, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        String[] $this$mapNotNull$iv = status2;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PublishStatus it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            PublishStatus status3 = PublishStatus.Companion.forApiValue((String)it);
            if ((user == null && (status3 == PublishStatus.Deleted || status3 == PublishStatus.Draft) ? null : status3) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set publishStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
        Pageable pageable = Pageable.unpaged();
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged()");
        ExportSkillsToCsvTask task = new ExportSkillsToCsvTask("CustomList", richSkillEsRepo.getUuidsFromApiSearch(apiSearch, publishStatuses, pageable, user, ""), null, null, null, null, 60, null);
        this.getTaskMessageService().enqueueJob("custom-rsd-list-csv-export", task);
        return Task.Companion.processingResponse(task);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=true)
    @PostMapping(path={"/api/v2/export/skills", "/api/export/skills"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> exportCustomListCsvV2(@RequestBody @NotNull ApiSearch apiSearch, @NotNull String[] status2, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        String[] $this$mapNotNull$iv = status2;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PublishStatus it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            PublishStatus status3 = PublishStatus.Companion.forApiValue((String)it);
            if ((user == null && (status3 == PublishStatus.Deleted || status3 == PublishStatus.Draft) ? null : status3) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set publishStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
        Pageable pageable = Pageable.unpaged();
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged()");
        ExportSkillsToCsvTaskV2 task = new ExportSkillsToCsvTaskV2("CustomList", richSkillEsRepo.getUuidsFromApiSearch(apiSearch, publishStatuses, pageable, user, ""), null, null, null, null, 60, null);
        this.getTaskMessageService().enqueueJob("custom-rsd-list-csv-export-v2", task);
        return Task.Companion.processingResponse(task);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=true)
    @PostMapping(value={"/api/v3/export/skills/xlsx"}, produces={"application/json"})
    @ResponseBody
    @NotNull
    public HttpEntity<TaskResult> exportCustomListXlsx(@RequestBody @NotNull ApiSearch apiSearch, @NotNull String[] status2, @AuthenticationPrincipal @Nullable Jwt user) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)apiSearch, (String)"apiSearch");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (!this.getAppConfig().getAllowPublicSearching() && user == null) {
            throw new GeneralApiException("Unauthorized", HttpStatus.UNAUTHORIZED);
        }
        String[] $this$mapNotNull$iv = status2;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PublishStatus it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            PublishStatus status3 = PublishStatus.Companion.forApiValue((String)it);
            if ((user == null && (status3 == PublishStatus.Deleted || status3 == PublishStatus.Draft) ? null : status3) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set publishStatuses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
        Pageable pageable = Pageable.unpaged();
        Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged()");
        ExportSkillsToXlsxTask task = new ExportSkillsToXlsxTask("CustomList", richSkillEsRepo.getUuidsFromApiSearch(apiSearch, publishStatuses, pageable, user, ""), null, null, null, null, 60, null);
        this.getTaskMessageService().enqueueJob("custom-rsd-list-xlsx-export", task);
        return Task.Companion.processingResponse(task);
    }

    private static final RichSkillDoc allPaginatedWithFilters$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RichSkillDoc)$tmp0.invoke(p0);
    }
}

