/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.richskill;

import edu.wgu.osmt.api.FormValidationException;
import edu.wgu.osmt.api.model.ApiAlignment;
import edu.wgu.osmt.api.model.ApiAlignmentListUpdate;
import edu.wgu.osmt.api.model.ApiBatchResult;
import edu.wgu.osmt.api.model.ApiFieldError;
import edu.wgu.osmt.api.model.ApiNamedReference;
import edu.wgu.osmt.api.model.ApiReferenceListUpdate;
import edu.wgu.osmt.api.model.ApiSearch;
import edu.wgu.osmt.api.model.ApiSkillUpdate;
import edu.wgu.osmt.api.model.ApiStringListUpdate;
import edu.wgu.osmt.auditlog.AuditLog;
import edu.wgu.osmt.auditlog.AuditLogRepository;
import edu.wgu.osmt.auditlog.AuditOperationType;
import edu.wgu.osmt.auditlog.Change;
import edu.wgu.osmt.collection.CollectionDao;
import edu.wgu.osmt.collection.CollectionEsRepo;
import edu.wgu.osmt.collection.CollectionRepository;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.ListFieldUpdate;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.db.PublishStatusDetails;
import edu.wgu.osmt.jobcode.JobCodeRepository;
import edu.wgu.osmt.jobcode.JobCodeTable;
import edu.wgu.osmt.keyword.KeywordDao;
import edu.wgu.osmt.keyword.KeywordRepository;
import edu.wgu.osmt.keyword.KeywordTypeEnum;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import edu.wgu.osmt.richskill.RichSkillDescriptorDao;
import edu.wgu.osmt.richskill.RichSkillDescriptorKt;
import edu.wgu.osmt.richskill.RichSkillDescriptorTable;
import edu.wgu.osmt.richskill.RichSkillDoc;
import edu.wgu.osmt.richskill.RichSkillEsRepo;
import edu.wgu.osmt.richskill.RichSkillJobCodes;
import edu.wgu.osmt.richskill.RichSkillRepository;
import edu.wgu.osmt.richskill.RsdUpdateObject;
import edu.wgu.osmt.task.PublishTask;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.util.Streamable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H\u0016J\u001a\u00104\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000203H\u0016J,\u00108\u001a\b\u0012\u0004\u0012\u000201092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;092\u0006\u00107\u001a\u0002032\u0006\u0010<\u001a\u000203H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0012\u0010>\u001a\u0004\u0018\u0001012\u0006\u0010?\u001a\u00020@H\u0016J\u0012\u0010A\u001a\u0004\u0018\u0001012\u0006\u0010B\u001a\u000203H\u0016J\u001e\u0010C\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001092\f\u0010D\u001a\b\u0012\u0004\u0012\u00020309H\u0016J \u0010E\u001a\u0002062\u0006\u0010F\u001a\u00020;2\u0006\u00107\u001a\u0002032\u0006\u0010G\u001a\u000203H\u0016J\u001a\u0010H\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000203H\u0016J*\u0010I\u001a\u0004\u0018\u0001012\u0006\u0010J\u001a\u00020@2\u0006\u0010F\u001a\u00020;2\u0006\u00107\u001a\u0002032\u0006\u0010G\u001a\u000203H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u001a8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020 8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006K"}, d2={"Ledu/wgu/osmt/richskill/RichSkillRepositoryImpl;", "Ledu/wgu/osmt/richskill/RichSkillRepository;", "auditLogRepository", "Ledu/wgu/osmt/auditlog/AuditLogRepository;", "collectionRepository", "Ledu/wgu/osmt/collection/CollectionRepository;", "richSkillEsRepo", "Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "collectionEsRepo", "Ledu/wgu/osmt/collection/CollectionEsRepo;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/auditlog/AuditLogRepository;Ledu/wgu/osmt/collection/CollectionRepository;Ledu/wgu/osmt/richskill/RichSkillEsRepo;Ledu/wgu/osmt/collection/CollectionEsRepo;Ledu/wgu/osmt/config/AppConfig;)V", "getAppConfig", "()Ledu/wgu/osmt/config/AppConfig;", "getAuditLogRepository", "()Ledu/wgu/osmt/auditlog/AuditLogRepository;", "getCollectionEsRepo", "()Ledu/wgu/osmt/collection/CollectionEsRepo;", "getCollectionRepository", "()Ledu/wgu/osmt/collection/CollectionRepository;", "dao", "Ledu/wgu/osmt/richskill/RichSkillDescriptorDao$Companion;", "getDao", "()Ledu/wgu/osmt/richskill/RichSkillDescriptorDao$Companion;", "jobCodeRepository", "Ledu/wgu/osmt/jobcode/JobCodeRepository;", "getJobCodeRepository", "()Ledu/wgu/osmt/jobcode/JobCodeRepository;", "setJobCodeRepository", "(Ledu/wgu/osmt/jobcode/JobCodeRepository;)V", "keywordRepository", "Ledu/wgu/osmt/keyword/KeywordRepository;", "getKeywordRepository", "()Ledu/wgu/osmt/keyword/KeywordRepository;", "setKeywordRepository", "(Ledu/wgu/osmt/keyword/KeywordRepository;)V", "getRichSkillEsRepo", "()Ledu/wgu/osmt/richskill/RichSkillEsRepo;", "table", "Ledu/wgu/osmt/richskill/RichSkillDescriptorTable;", "getTable", "()Ledu/wgu/osmt/richskill/RichSkillDescriptorTable;", "changeStatusesForTask", "Ledu/wgu/osmt/api/model/ApiBatchResult;", "publishTask", "Ledu/wgu/osmt/task/PublishTask;", "containingJobCode", "Lorg/jetbrains/exposed/sql/SizedIterable;", "Ledu/wgu/osmt/richskill/RichSkillDescriptorDao;", "jobCode", "", "create", "updateObject", "Ledu/wgu/osmt/richskill/RsdUpdateObject;", "user", "createFromApi", "", "skillUpdates", "Ledu/wgu/osmt/api/model/ApiSkillUpdate;", "userEmail", "findAll", "findById", "id", "", "findByUUID", "uuid", "findManyByUUIDs", "uuids", "rsdUpdateFromApi", "skillUpdate", "email", "update", "updateFromApi", "existingSkillId", "osmt-api"})
public class RichSkillRepositoryImpl
implements RichSkillRepository {
    @NotNull
    private final AuditLogRepository auditLogRepository;
    @NotNull
    private final CollectionRepository collectionRepository;
    @NotNull
    private final RichSkillEsRepo richSkillEsRepo;
    @NotNull
    private final CollectionEsRepo collectionEsRepo;
    @NotNull
    private final AppConfig appConfig;
    @Autowired
    @Lazy
    public JobCodeRepository jobCodeRepository;
    @Autowired
    @Lazy
    public KeywordRepository keywordRepository;
    @NotNull
    private final RichSkillDescriptorDao.Companion dao;
    @NotNull
    private final RichSkillDescriptorTable table;

    @Autowired
    public RichSkillRepositoryImpl(@NotNull AuditLogRepository auditLogRepository, @NotNull CollectionRepository collectionRepository, @NotNull RichSkillEsRepo richSkillEsRepo, @NotNull CollectionEsRepo collectionEsRepo, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)auditLogRepository, (String)"auditLogRepository");
        Intrinsics.checkNotNullParameter((Object)collectionRepository, (String)"collectionRepository");
        Intrinsics.checkNotNullParameter((Object)richSkillEsRepo, (String)"richSkillEsRepo");
        Intrinsics.checkNotNullParameter((Object)collectionEsRepo, (String)"collectionEsRepo");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.auditLogRepository = auditLogRepository;
        this.collectionRepository = collectionRepository;
        this.richSkillEsRepo = richSkillEsRepo;
        this.collectionEsRepo = collectionEsRepo;
        this.appConfig = appConfig;
        this.dao = RichSkillDescriptorDao.Companion;
        this.table = RichSkillDescriptorTable.INSTANCE;
    }

    @NotNull
    public AuditLogRepository getAuditLogRepository() {
        return this.auditLogRepository;
    }

    @NotNull
    public CollectionRepository getCollectionRepository() {
        return this.collectionRepository;
    }

    @NotNull
    public RichSkillEsRepo getRichSkillEsRepo() {
        return this.richSkillEsRepo;
    }

    @NotNull
    public CollectionEsRepo getCollectionEsRepo() {
        return this.collectionEsRepo;
    }

    @NotNull
    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    @NotNull
    public JobCodeRepository getJobCodeRepository() {
        JobCodeRepository jobCodeRepository = this.jobCodeRepository;
        if (jobCodeRepository != null) {
            return jobCodeRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jobCodeRepository");
        return null;
    }

    public void setJobCodeRepository(@NotNull JobCodeRepository jobCodeRepository) {
        Intrinsics.checkNotNullParameter((Object)jobCodeRepository, (String)"<set-?>");
        this.jobCodeRepository = jobCodeRepository;
    }

    @NotNull
    public KeywordRepository getKeywordRepository() {
        KeywordRepository keywordRepository = this.keywordRepository;
        if (keywordRepository != null) {
            return keywordRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"keywordRepository");
        return null;
    }

    public void setKeywordRepository(@NotNull KeywordRepository keywordRepository) {
        Intrinsics.checkNotNullParameter((Object)keywordRepository, (String)"<set-?>");
        this.keywordRepository = keywordRepository;
    }

    @Override
    @NotNull
    public RichSkillDescriptorDao.Companion getDao() {
        return this.dao;
    }

    @Override
    @NotNull
    public RichSkillDescriptorTable getTable() {
        return this.table;
    }

    @Override
    @NotNull
    public SizedIterable<RichSkillDescriptorDao> findAll() {
        return this.getDao().all();
    }

    @Override
    @Nullable
    public RichSkillDescriptorDao findById(long id) {
        return (RichSkillDescriptorDao)this.getDao().findById(Long.valueOf(id));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao update(@NotNull RsdUpdateObject updateObject, @NotNull String user) {
        RichSkillDescriptorDao daoObject;
        block10: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            List otherChanges;
            Pair pair;
            Object element$iv2;
            Iterable first$iv;
            List<Change> list2;
            PublishStatusDetails it2;
            Intrinsics.checkNotNullParameter((Object)updateObject, (String)"updateObject");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            RichSkillDescriptorDao.Companion companion = this.getDao();
            Long l = updateObject.getId();
            Intrinsics.checkNotNull((Object)l);
            RichSkillDescriptorDao richSkillDescriptorDao = daoObject = (RichSkillDescriptorDao)companion.findById(l);
            RichSkillDescriptor old = richSkillDescriptorDao != null ? richSkillDescriptorDao.toModel() : null;
            RichSkillDescriptorDao richSkillDescriptorDao2 = daoObject;
            if (richSkillDescriptorDao2 != null) {
                it2 = richSkillDescriptorDao2;
                boolean list2 = false;
                updateObject.applyToDao((RichSkillDescriptorDao)it2);
            }
            if (daoObject != null && (it2 = daoObject.toModel()) != null && (list2 = RichSkillDescriptorKt.diff((RichSkillDescriptor)it2, old)) != null) {
                void $this$partition$iv;
                Iterable iterable = list2;
                boolean $i$f$partition = false;
                first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv2 : $this$partition$iv) {
                    Change it3 = (Change)element$iv2;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it3.getFieldName(), (Object)"publishStatus")) {
                        ((ArrayList)first$iv).add(element$iv2);
                        continue;
                    }
                    second$iv.add(element$iv2);
                }
                pair = new Pair(first$iv, second$iv);
            } else {
                pair = TuplesKt.to(null, null);
            }
            Pair pair2 = pair;
            List publishStatusChanges = (List)pair2.component1();
            List list3 = otherChanges = (List)pair2.component2();
            if (list3 != null) {
                it = list3;
                boolean bl = false;
                if (!((Collection)it).isEmpty()) {
                    this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), (long)updateObject.getId(), (List<Change>)it, user, AuditOperationType.Update));
                }
            }
            List list4 = publishStatusChanges;
            if (list4 != null) {
                it = list4;
                boolean bl = false;
                if (!((Collection)it).isEmpty()) {
                    this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), (long)updateObject.getId(), (List<Change>)it, user, AuditOperationType.PublishStatusChange));
                }
            }
            RichSkillDescriptorDao richSkillDescriptorDao3 = daoObject;
            if (richSkillDescriptorDao3 == null) break block10;
            it = richSkillDescriptorDao3;
            boolean bl = false;
            first$iv = (Iterable)((RichSkillDescriptorDao)it).getCollections();
            CollectionEsRepo collectionEsRepo = this.getCollectionEsRepo();
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it4;
                CollectionDao collectionDao = (CollectionDao)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(CollectionDao.toDoc$default((CollectionDao)it4, false, 1, null));
            }
            collectionEsRepo.saveAll((List)destination$iv$iv);
            RichSkillDoc cfr_ignored_0 = (RichSkillDoc)this.getRichSkillEsRepo().save(RichSkillDoc.Companion.fromDao((RichSkillDescriptorDao)it, this.getAppConfig()));
        }
        return daoObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao findByUUID(@NotNull String uuid) {
        RichSkillDescriptorDao richSkillDescriptorDao;
        void $this$findByUUID_u24lambda_u246;
        ResultRow query;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        ResultRow resultRow = query = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.select((FieldSet)fieldSet, (Op)$this$findByUUID_u24lambda_u246.eq((ExpressionWithColumnType)this.getTable().getUuid(), (Object)uuid))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl2 = false;
            richSkillDescriptorDao = (RichSkillDescriptorDao)this.getDao().wrapRow(it);
        } else {
            richSkillDescriptorDao = null;
        }
        return richSkillDescriptorDao;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<RichSkillDescriptorDao> findManyByUUIDs(@NotNull List<String> uuids) {
        void $this$mapTo$iv$iv;
        Iterable $this$findManyByUUIDs_u24lambda_u248;
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        FieldSet $this$select$iv = (FieldSet)this.getTable();
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        Object object = $this$select$iv;
        boolean bl = false;
        Query query = QueriesKt.select((FieldSet)object, (Op)((Op)$this$findManyByUUIDs_u24lambda_u248.inList((ExpressionWithColumnType)this.getTable().getUuid(), uuids)));
        Iterable $this$map$iv = (Iterable)query;
        boolean $i$f$map = false;
        $this$findManyByUUIDs_u24lambda_u248 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultRow resultRow = (ResultRow)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add((RichSkillDescriptorDao)this.getDao().wrapRow((ResultRow)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RichSkillDescriptorDao create(@NotNull RsdUpdateObject updateObject, @NotNull String user) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)updateObject, (String)"updateObject");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        CharSequence charSequence = updateObject.getName();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)updateObject.getStatement()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        RichSkillDescriptorDao newRsd2 = (RichSkillDescriptorDao)this.getDao().new((Function1)new Function1<RichSkillDescriptorDao, Unit>(updateObject){
            final /* synthetic */ RsdUpdateObject $updateObject;
            {
                this.$updateObject = $updateObject;
                super(1);
            }

            public final void invoke(@NotNull RichSkillDescriptorDao $this$new) {
                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                $this$new.setName(this.$updateObject.getName());
                $this$new.setStatement(this.$updateObject.getStatement());
                LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(ZoneOffset.UTC)");
                $this$new.setUpdateDate(localDateTime);
                LocalDateTime localDateTime2 = LocalDateTime.now(ZoneOffset.UTC);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"now(ZoneOffset.UTC)");
                $this$new.setCreationDate(localDateTime2);
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
                $this$new.setUuid(string);
            }
        });
        RsdUpdateObject.copy$default(updateObject, (Long)newRsd2.getId().getValue(), null, null, null, null, null, null, 126, null).applyToDao(newRsd2);
        RichSkillDescriptorDao it = newRsd2;
        boolean bl = false;
        Iterable iterable = (Iterable)it.getCollections();
        CollectionEsRepo collectionEsRepo = this.getCollectionEsRepo();
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            CollectionDao collectionDao = (CollectionDao)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(CollectionDao.toDoc$default((CollectionDao)it2, false, 1, null));
        }
        collectionEsRepo.saveAll((List)destination$iv$iv);
        RichSkillDoc cfr_ignored_0 = (RichSkillDoc)this.getRichSkillEsRepo().save(RichSkillDoc.Companion.fromDao(it, this.getAppConfig()));
        this.getAuditLogRepository().create(AuditLog.Companion.fromAtomicOp((Table)this.getTable(), ((Number)((Object)newRsd2.getId().getValue())).longValue(), RichSkillDescriptorKt.diff(newRsd2.toModel(), null), user, AuditOperationType.Insert));
        return newRsd2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RichSkillDescriptorDao> createFromApi(@NotNull List<ApiSkillUpdate> skillUpdates, @NotNull String user, @NotNull String userEmail) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(skillUpdates, (String)"skillUpdates");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        Iterable $this$mapIndexed$iv = skillUpdates;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void updateDto;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ApiSkillUpdate apiSkillUpdate = (ApiSkillUpdate)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(updateDto.validateForCreation((int)i));
        }
        List allErrors = CollectionsKt.flatten((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        if (!((Collection)allErrors).isEmpty()) {
            throw new FormValidationException("Invalid SkillUpdateDescriptor", allErrors);
        }
        Iterable $this$map$iv = skillUpdates;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void update;
            ApiSkillUpdate apiSkillUpdate = (ApiSkillUpdate)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            RsdUpdateObject rsdUpdateObject = this.rsdUpdateFromApi((ApiSkillUpdate)update, user, userEmail);
            collection.add(this.create(rsdUpdateObject, user));
        }
        List newSkills = (List)destination$iv$iv2;
        return CollectionsKt.filterNotNull((Iterable)newSkills);
    }

    @Override
    @Nullable
    public RichSkillDescriptorDao updateFromApi(long existingSkillId, @NotNull ApiSkillUpdate skillUpdate, @NotNull String user, @NotNull String email) {
        List<ApiFieldError> errors;
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        List<ApiFieldError> list = errors = skillUpdate.validate(0);
        boolean bl = list != null ? !((Collection)list).isEmpty() : false;
        if (bl) {
            throw new FormValidationException("Invalid SkillUpdateDescriptor", errors);
        }
        RsdUpdateObject rsdUpdateObject = this.rsdUpdateFromApi(skillUpdate, user, email);
        RsdUpdateObject updateObjectWithId = RsdUpdateObject.copy$default(rsdUpdateObject, existingSkillId, null, null, null, null, null, null, 126, null);
        return this.update(updateObjectWithId, user);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RsdUpdateObject rsdUpdateFromApi(@NotNull ApiSkillUpdate skillUpdate, @NotNull String user, @NotNull String email) {
        ListFieldUpdate allKeywordsUpdate;
        Object it;
        Iterable<CollectionDao> destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)skillUpdate, (String)"skillUpdate");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        List addingCollections = new ArrayList();
        List removingCollections = new ArrayList();
        List addingKeywords = new ArrayList();
        List removingKeywords = new ArrayList();
        List jobsToAdd = new ArrayList();
        List jobsToRemove = new ArrayList();
        ApiStringListUpdate apiStringListUpdate = skillUpdate.getCollections();
        if (apiStringListUpdate != null) {
            List it2;
            boolean bl;
            CollectionDao it$iv$iv;
            String it3;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterator iterator;
            boolean $i$f$forEach;
            Iterator $this$forEach$iv$iv$iv;
            boolean $i$f$mapNotNullTo;
            Iterable $this$mapNotNull$iv;
            ApiStringListUpdate slu = apiStringListUpdate;
            boolean bl3 = false;
            List<String> list = slu.getAdd();
            if (list != null) {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl2 = false;
                    it3 = (String)element$iv$iv;
                    boolean bl4 = false;
                    CollectionDao collectionDao = this.getCollectionRepository().findByName(it3);
                    if (collectionDao == null) {
                        collectionDao = CollectionRepository.DefaultImpls.create$default(this.getCollectionRepository(), it3, user, email, null, 8, null);
                    }
                    if (collectionDao == null) continue;
                    it$iv$iv = collectionDao;
                    bl = false;
                    destination$iv$iv.add((CollectionDao)it$iv$iv);
                }
                it2 = (List)destination$iv$iv;
                boolean bl5 = false;
                addingCollections.addAll(it2);
            }
            List<String> list2 = slu.getRemove();
            if (list2 != null) {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable bl5 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl2 = false;
                    it3 = (String)element$iv$iv;
                    boolean bl6 = false;
                    CollectionDao collectionDao = this.getCollectionRepository().findByName(it3);
                    if (collectionDao == null) {
                        collectionDao = CollectionRepository.DefaultImpls.create$default(this.getCollectionRepository(), it3, user, email, null, 8, null);
                    }
                    if (collectionDao == null) continue;
                    it$iv$iv = collectionDao;
                    bl = false;
                    destination$iv$iv.add((CollectionDao)it$iv$iv);
                }
                it2 = (List)destination$iv$iv;
                boolean bl7 = false;
                removingCollections.addAll(it2);
            }
        }
        ApiStringListUpdate apiStringListUpdate2 = skillUpdate.getOccupations();
        if (apiStringListUpdate2 != null) {
            String it4;
            Iterable $this$filter$iv;
            it = apiStringListUpdate2;
            boolean bl = false;
            List<String> list = ((ApiStringListUpdate)it).getAdd();
            if (list != null) {
                void $this$mapTo$iv$iv;
                void $this$filterTo$iv$iv;
                $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable bl7 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it4 = (String)element$iv$iv;
                    boolean bl8 = false;
                    boolean bl9 = !StringsKt.isBlank((CharSequence)it4);
                    if (!bl9) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it5;
                    String bl8 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl10 = false;
                    collection.add(JobCodeRepository.DefaultImpls.findByCodeOrCreate$default(this.getJobCodeRepository(), (String)it5, null, 2, null));
                }
                List it6 = (List)destination$iv$iv2;
                boolean bl11 = false;
                jobsToAdd.addAll(it6);
            }
            List<String> list3 = ((ApiStringListUpdate)it).getRemove();
            if (list3 != null) {
                void $this$mapTo$iv$iv;
                void $this$filterTo$iv$iv;
                $this$filter$iv = list3;
                boolean $i$f$filter = false;
                Iterable it6 = $this$filter$iv;
                Iterable destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it4 = (String)element$iv$iv;
                    boolean bl12 = false;
                    boolean bl13 = !StringsKt.isBlank((CharSequence)it4);
                    if (!bl13) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv3;
                boolean $i$f$map = false;
                destination$iv$iv3 = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it7;
                    String bl12 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl14 = false;
                    collection.add(this.getJobCodeRepository().findByCode((String)it7));
                }
                List it2 = (List)destination$iv$iv4;
                boolean bl15 = false;
                jobsToRemove.addAll(CollectionsKt.filterNotNull((Iterable)it2));
            }
        }
        ApiStringListUpdate apiStringListUpdate3 = skillUpdate.getAuthors();
        if (apiStringListUpdate3 != null) {
            it = apiStringListUpdate3;
            boolean bl = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupKeywords(this, addingKeywords, removingKeywords, (ApiStringListUpdate)it, KeywordTypeEnum.Author);
        }
        ApiStringListUpdate apiStringListUpdate4 = skillUpdate.getCategories();
        if (apiStringListUpdate4 != null) {
            it = apiStringListUpdate4;
            boolean bl = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupKeywords(this, addingKeywords, removingKeywords, (ApiStringListUpdate)it, KeywordTypeEnum.Category);
        }
        ApiStringListUpdate apiStringListUpdate5 = skillUpdate.getKeywords();
        if (apiStringListUpdate5 != null) {
            it = apiStringListUpdate5;
            boolean bl = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupKeywords(this, addingKeywords, removingKeywords, (ApiStringListUpdate)it, KeywordTypeEnum.Keyword);
        }
        ApiReferenceListUpdate apiReferenceListUpdate = skillUpdate.getCertifications();
        if (apiReferenceListUpdate != null) {
            it = apiReferenceListUpdate;
            boolean bl = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupReferences(this, addingKeywords, removingKeywords, (ApiReferenceListUpdate)it, KeywordTypeEnum.Certification);
        }
        ApiAlignmentListUpdate apiAlignmentListUpdate = skillUpdate.getStandards();
        if (apiAlignmentListUpdate != null) {
            it = apiAlignmentListUpdate;
            boolean bl = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupAlignments(this, addingKeywords, removingKeywords, (ApiAlignmentListUpdate)it, KeywordTypeEnum.Standard);
        }
        ApiAlignmentListUpdate apiAlignmentListUpdate2 = skillUpdate.getAlignments();
        if (apiAlignmentListUpdate2 != null) {
            it = apiAlignmentListUpdate2;
            boolean bl = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupAlignments(this, addingKeywords, removingKeywords, (ApiAlignmentListUpdate)it, KeywordTypeEnum.Alignment);
        }
        ApiReferenceListUpdate apiReferenceListUpdate2 = skillUpdate.getEmployers();
        if (apiReferenceListUpdate2 != null) {
            it = apiReferenceListUpdate2;
            boolean bl = false;
            RichSkillRepositoryImpl.rsdUpdateFromApi$lookupReferences(this, addingKeywords, removingKeywords, (ApiReferenceListUpdate)it, KeywordTypeEnum.Employer);
        }
        ListFieldUpdate listFieldUpdate = addingKeywords.size() > 0 || removingKeywords.size() > 0 ? new ListFieldUpdate(addingKeywords.size() > 0 ? addingKeywords : CollectionsKt.emptyList(), removingKeywords.size() > 0 ? removingKeywords : CollectionsKt.emptyList()) : (allKeywordsUpdate = null);
        ListFieldUpdate jobCodesUpdate = jobsToAdd.size() > 0 || jobsToRemove.size() > 0 ? new ListFieldUpdate(jobsToAdd.size() > 0 ? jobsToAdd : CollectionsKt.emptyList(), jobsToRemove.size() > 0 ? jobsToRemove : CollectionsKt.emptyList()) : null;
        String string = skillUpdate.getSkillName();
        String string2 = skillUpdate.getSkillStatement();
        PublishStatus publishStatus = skillUpdate.getPublishStatus();
        ListFieldUpdate listFieldUpdate2 = addingCollections.size() + removingCollections.size() > 0 ? new ListFieldUpdate(addingCollections, removingCollections) : null;
        return new RsdUpdateObject(null, string, string2, allKeywordsUpdate, jobCodesUpdate, listFieldUpdate2, publishStatus, 1, null);
    }

    @Override
    @NotNull
    public ApiBatchResult changeStatusesForTask(@NotNull PublishTask publishTask) {
        Intrinsics.checkNotNullParameter((Object)publishTask, (String)"publishTask");
        Ref.IntRef modifiedCount = new Ref.IntRef();
        int totalCount = 0;
        Function2 publishSkill2 = (Function2)new Function2<RichSkillDescriptorDao, PublishTask, Boolean>(this){
            final /* synthetic */ RichSkillRepositoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull RichSkillDescriptorDao skillDao, @NotNull PublishTask task) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)skillDao, (String)"skillDao");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                PublishStatus oldStatus = skillDao.publishStatus();
                if (oldStatus != task.getPublishStatus()) {
                    PublishStatus newStatus;
                    RichSkillDescriptorDao updatedDao;
                    RsdUpdateObject updateObj = new RsdUpdateObject((Long)skillDao.getId().getValue(), null, null, null, null, null, task.getPublishStatus(), 62, null);
                    RichSkillDescriptorDao richSkillDescriptorDao = updatedDao = this.this$0.update(updateObj, task.getUserString());
                    PublishStatus publishStatus = newStatus = richSkillDescriptorDao != null ? richSkillDescriptorDao.publishStatus() : null;
                    bl = newStatus != oldStatus;
                } else {
                    bl = false;
                }
                return bl;
            }
        };
        Function1 handleSkillDao2 = (Function1)new Function1<RichSkillDescriptorDao, Unit>((Function2<? super RichSkillDescriptorDao, ? super PublishTask, Boolean>)publishSkill2, publishTask, modifiedCount){
            final /* synthetic */ Function2<RichSkillDescriptorDao, PublishTask, Boolean> $publishSkill;
            final /* synthetic */ PublishTask $publishTask;
            final /* synthetic */ Ref.IntRef $modifiedCount;
            {
                this.$publishSkill = $publishSkill;
                this.$publishTask = $publishTask;
                this.$modifiedCount = $modifiedCount;
                super(1);
            }

            @Nullable
            public final Unit invoke(@Nullable RichSkillDescriptorDao skillDao) {
                Unit unit;
                RichSkillDescriptorDao richSkillDescriptorDao = skillDao;
                if (richSkillDescriptorDao != null) {
                    RichSkillDescriptorDao richSkillDescriptorDao2 = richSkillDescriptorDao;
                    Function2<RichSkillDescriptorDao, PublishTask, Boolean> function2 = this.$publishSkill;
                    PublishTask publishTask = this.$publishTask;
                    Ref.IntRef intRef = this.$modifiedCount;
                    RichSkillDescriptorDao it = richSkillDescriptorDao2;
                    boolean bl = false;
                    if (((Boolean)function2.invoke((Object)it, (Object)publishTask)).booleanValue()) {
                        ++intRef.element;
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        };
        Collection collection = publishTask.getSearch().getUuids();
        if (!(collection == null || collection.isEmpty())) {
            totalCount = publishTask.getSearch().getUuids().size();
            Iterable $this$forEach$iv = publishTask.getSearch().getUuids();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String uuid = (String)element$iv;
                boolean bl = false;
                handleSkillDao2.invoke((Object)this.findByUUID(uuid));
            }
        } else {
            RichSkillEsRepo richSkillEsRepo = this.getRichSkillEsRepo();
            ApiSearch apiSearch = publishTask.getSearch();
            Set<PublishStatus> set = publishTask.getFilterByStatus();
            Pageable pageable = Pageable.unpaged();
            Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"unpaged()");
            SearchHits searchHits = richSkillEsRepo.byApiSearch(apiSearch, set, pageable, publishTask.getCollectionUuid());
            totalCount = (int)searchHits.getTotalHits();
            Iterable $this$forEach$iv = (Iterable)searchHits;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SearchHit hit = (SearchHit)element$iv;
                boolean bl = false;
                handleSkillDao2.invoke((Object)this.findById(((RichSkillDoc)hit.getContent()).getId()));
            }
        }
        return new ApiBatchResult(true, null, modifiedCount.element, totalCount, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SizedIterable<RichSkillDescriptorDao> containingJobCode(@NotNull String jobCode) {
        void $this$containingJobCode_u24lambda_u2447;
        Intrinsics.checkNotNullParameter((Object)jobCode, (String)"jobCode");
        FieldSet $this$select$iv = RichSkillDescriptorTable.INSTANCE.innerJoin((ColumnSet)RichSkillJobCodes.INSTANCE).innerJoin((ColumnSet)JobCodeTable.INSTANCE).slice(RichSkillDescriptorTable.INSTANCE.getColumns());
        boolean $i$f$select = false;
        SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
        FieldSet fieldSet = $this$select$iv;
        boolean bl = false;
        Query query = QueriesKt.select((FieldSet)fieldSet, (Op)$this$containingJobCode_u24lambda_u2447.eq((ExpressionWithColumnType)JobCodeTable.INSTANCE.getCode(), (Object)jobCode));
        return RichSkillDescriptorDao.Companion.wrapRows((SizedIterable)query);
    }

    @Override
    @NotNull
    public Query publishStatusSetToQuery(@NotNull Set<? extends PublishStatus> publishStatusSet) {
        return RichSkillRepository.DefaultImpls.publishStatusSetToQuery(this, publishStatusSet);
    }

    @Override
    @NotNull
    public Streamable<Pair<Column<?>, SortOrder>> sortToQueryOrder(@NotNull Sort sort, @NotNull Query query) {
        return RichSkillRepository.DefaultImpls.sortToQueryOrder(this, sort, query);
    }

    /*
     * WARNING - void declaration
     */
    private static final void rsdUpdateFromApi$lookupReferences(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiReferenceListUpdate lud, KeywordTypeEnum keywordType) {
        block4: {
            Iterable it;
            ApiNamedReference it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            boolean $i$f$map;
            Iterable $this$map$iv;
            List list = lud.getAdd();
            if (list != null) {
                $this$map$iv = list;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ApiNamedReference apiNamedReference = (ApiNamedReference)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(KeywordRepository.DefaultImpls.findOrCreate$default(this$0.getKeywordRepository(), keywordType, it2.getName(), it2.getId(), null, 8, null));
                }
                list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    addingKeywords.addAll((Collection)it);
                }
            }
            List<ApiNamedReference> list2 = lud.getRemove();
            if (list2 == null) break block4;
            $this$map$iv = list2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (ApiNamedReference)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KeywordRepository.DefaultImpls.findByValueOrUri$default(this$0.getKeywordRepository(), keywordType, it2.getName(), it2.getId(), null, 8, null));
            }
            List it3 = (List)destination$iv$iv;
            boolean bl = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void rsdUpdateFromApi$lookupAlignments(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiAlignmentListUpdate lud, KeywordTypeEnum keywordType) {
        block4: {
            Iterable it;
            ApiAlignment it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            boolean $i$f$map;
            Iterable $this$map$iv;
            List list = lud.getAdd();
            if (list != null) {
                $this$map$iv = list;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ApiAlignment apiAlignment = (ApiAlignment)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    ApiNamedReference apiNamedReference = it2.isPartOf();
                    collection.add(this$0.getKeywordRepository().findOrCreate(keywordType, it2.getSkillName(), it2.getId(), apiNamedReference != null ? apiNamedReference.getName() : null));
                }
                list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    addingKeywords.addAll((Collection)it);
                }
            }
            List<ApiAlignment> list2 = lud.getRemove();
            if (list2 == null) break block4;
            $this$map$iv = list2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (ApiAlignment)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ApiNamedReference apiNamedReference = it2.isPartOf();
                collection.add(this$0.getKeywordRepository().findByValueOrUri(keywordType, it2.getSkillName(), it2.getId(), apiNamedReference != null ? apiNamedReference.getName() : null));
            }
            List it3 = (List)destination$iv$iv;
            boolean bl = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void rsdUpdateFromApi$lookupKeywords(RichSkillRepositoryImpl this$0, List<KeywordDao> addingKeywords, List<KeywordDao> removingKeywords, ApiStringListUpdate slud, KeywordTypeEnum keywordType) {
        block4: {
            Iterable it;
            String it2;
            Collection collection;
            void $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            boolean $i$f$map;
            Iterable $this$map$iv;
            List list = slud.getAdd();
            if (list != null) {
                $this$map$iv = list;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(KeywordRepository.DefaultImpls.findOrCreate$default(this$0.getKeywordRepository(), keywordType, it2, null, null, 12, null));
                }
                list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    addingKeywords.addAll((Collection)it);
                }
            }
            List<String> list2 = slud.getRemove();
            if (list2 == null) break block4;
            $this$map$iv = list2;
            $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KeywordRepository.DefaultImpls.findByValueOrUri$default(this$0.getKeywordRepository(), keywordType, it2, null, null, 12, null));
            }
            List it3 = (List)destination$iv$iv;
            boolean bl = false;
            removingKeywords.addAll(CollectionsKt.filterNotNull((Iterable)it3));
        }
    }
}

