/*
 * Decompiled with CFR 0.152.
 */
package edu.wgu.osmt.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.wgu.osmt.api.model.ApiCollection;
import edu.wgu.osmt.api.model.ApiSkillSummary;
import edu.wgu.osmt.config.AppConfig;
import edu.wgu.osmt.db.PublishStatus;
import edu.wgu.osmt.keyword.Keyword;
import edu.wgu.osmt.keyword.KeywordCount;
import edu.wgu.osmt.keyword.KeywordTypeEnum;
import edu.wgu.osmt.richskill.RichSkillDescriptor;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 ;2\u00020\u0001:\u0001;B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0002\u001a\u00020\u00038\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00138\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0015R\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010 \u001a\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R(\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u0013\u0010&\u001a\u0004\u0018\u00010\u00138G\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0015R\u0013\u0010(\u001a\u0004\u0018\u00010\u000f8G\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0011R&\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00050\b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010#R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00058WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010/R\u0013\u00101\u001a\u0004\u0018\u0001028G\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u00138\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0015R\u0011\u00107\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0011R\u0011\u00109\u001a\u00020\u00138G\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0015\u00a8\u0006<"}, d2={"Ledu/wgu/osmt/api/model/ApiCollection;", "", "collection", "Ledu/wgu/osmt/collection/Collection;", "ss", "", "Ledu/wgu/osmt/richskill/RichSkillDescriptor;", "keywords", "", "Ledu/wgu/osmt/keyword/KeywordTypeEnum;", "Ledu/wgu/osmt/keyword/KeywordCount;", "appConfig", "Ledu/wgu/osmt/config/AppConfig;", "(Ledu/wgu/osmt/collection/Collection;Ljava/util/List;Ljava/util/Map;Ledu/wgu/osmt/config/AppConfig;)V", "archiveDate", "Ljava/time/ZonedDateTime;", "getArchiveDate", "()Ljava/time/ZonedDateTime;", "author", "", "getAuthor", "()Ljava/lang/String;", "getCollection", "()Ledu/wgu/osmt/collection/Collection;", "context", "getContext", "creationDate", "getCreationDate", "creator", "getCreator", "description", "getDescription", "id", "getId", "getKeywords", "()Ljava/util/Map;", "name", "getName", "owner", "getOwner", "publishDate", "getPublishDate", "skillKeywords", "getSkillKeywords", "skills", "Ledu/wgu/osmt/api/model/ApiSkillSummary;", "getSkills", "()Ljava/util/List;", "getSs", "status", "Ledu/wgu/osmt/db/PublishStatus;", "getStatus", "()Ledu/wgu/osmt/db/PublishStatus;", "type", "getType", "updateDate", "getUpdateDate", "uuid", "getUuid", "Companion", "osmt-api"})
public class ApiCollection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonIgnore
    @NotNull
    private final edu.wgu.osmt.collection.Collection collection;
    @JsonIgnore
    @NotNull
    private final List<RichSkillDescriptor> ss;
    @JsonIgnore
    @NotNull
    private final Map<KeywordTypeEnum, List<KeywordCount>> keywords;
    @NotNull
    private final AppConfig appConfig;
    @JsonProperty(value="@context")
    @NotNull
    private final String context;
    @JsonProperty
    @NotNull
    private final String type;

    public ApiCollection(@NotNull edu.wgu.osmt.collection.Collection collection, @NotNull List<? extends RichSkillDescriptor> ss, @NotNull Map<KeywordTypeEnum, ? extends List<KeywordCount>> keywords, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter(ss, (String)"ss");
        Intrinsics.checkNotNullParameter(keywords, (String)"keywords");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.collection = collection;
        this.ss = ss;
        this.keywords = keywords;
        this.appConfig = appConfig;
        this.context = this.appConfig.getRsdContextUrl();
        this.type = "RichSkillCollection";
    }

    @NotNull
    public edu.wgu.osmt.collection.Collection getCollection() {
        return this.collection;
    }

    @NotNull
    public List<RichSkillDescriptor> getSs() {
        return this.ss;
    }

    @NotNull
    public Map<KeywordTypeEnum, List<KeywordCount>> getKeywords() {
        return this.keywords;
    }

    @JsonProperty
    @NotNull
    public final String getId() {
        return this.getCollection().canonicalUrl(this.appConfig.getBaseUrl());
    }

    @NotNull
    public final String getContext() {
        return this.context;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @JsonProperty
    @NotNull
    public final String getUuid() {
        return this.getCollection().getUuid().toString();
    }

    @JsonProperty
    @NotNull
    public final String getName() {
        return this.getCollection().getName();
    }

    @JsonProperty
    @Nullable
    public final String getDescription() {
        return this.getCollection().getDescription();
    }

    @JsonProperty
    @NotNull
    public final String getCreator() {
        return this.appConfig.getDefaultCreatorUri();
    }

    @JsonProperty
    @Nullable
    public final String getAuthor() {
        Keyword keyword = this.getCollection().getAuthor();
        return keyword != null ? keyword.getValue() : null;
    }

    @JsonProperty
    @Nullable
    public final PublishStatus getStatus() {
        return this.getCollection().getStatus();
    }

    @JsonProperty
    @NotNull
    public final ZonedDateTime getCreationDate() {
        ZonedDateTime zonedDateTime = this.getCollection().getCreationDate().atZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"collection.creationDate.atZone(ZoneId.of(\"UTC\"))");
        return zonedDateTime;
    }

    @JsonProperty
    @NotNull
    public final ZonedDateTime getUpdateDate() {
        ZonedDateTime zonedDateTime = this.getCollection().getUpdateDate().atZone(ZoneId.of("UTC"));
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"collection.updateDate.atZone(ZoneId.of(\"UTC\"))");
        return zonedDateTime;
    }

    @JsonProperty
    @Nullable
    public final ZonedDateTime getPublishDate() {
        LocalDateTime localDateTime = this.getCollection().getPublishDate();
        return localDateTime != null ? localDateTime.atZone(ZoneId.of("UTC")) : null;
    }

    @JsonProperty
    @Nullable
    public final ZonedDateTime getArchiveDate() {
        LocalDateTime localDateTime = this.getCollection().getArchiveDate();
        return localDateTime != null ? localDateTime.atZone(ZoneId.of("UTC")) : null;
    }

    /*
     * WARNING - void declaration
     */
    @JsonProperty
    @NotNull
    public List<ApiSkillSummary> getSkills() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RichSkillDescriptor richSkillDescriptor = (RichSkillDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ApiSkillSummary.Companion.fromSkill((RichSkillDescriptor)it, this.appConfig));
        }
        return (List)destination$iv$iv;
    }

    @JsonProperty
    @NotNull
    public Map<KeywordTypeEnum, List<KeywordCount>> getSkillKeywords() {
        return this.getKeywords();
    }

    @JsonProperty
    @Nullable
    public final String getOwner() {
        return this.getCollection().getWorkspaceOwner();
    }
}

